/*
 * Decompiled with CFR 0.152.
 */
package org.fakeservlet;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FakeCookie {
    private final String name;
    private final String value;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public FakeCookie(String name, String value) {
        this.name = name;
        String string = this.value = value != null ? value : "";
        if (this.value.isEmpty()) {
            this.attributes.putIfAbsent("Expires", Instant.ofEpochMilli(0L));
            this.attributes.putIfAbsent("Max-Age", 0);
        }
    }

    public static FakeCookie delete(String name) {
        return new FakeCookie(name, null);
    }

    public static FakeCookie parseSetCookieHeader(String rfc6264String) {
        int endValue;
        int offset = 0;
        int startKey = FakeCookie.scanToNot(rfc6264String, offset, List.of(Character.valueOf('\t'), Character.valueOf(' ')));
        if (startKey == rfc6264String.length()) {
            throw new IllegalArgumentException("Illegal empty set-cookie header");
        }
        int endKey = FakeCookie.scanTo(rfc6264String, startKey + 1, List.of(Character.valueOf('\t'), Character.valueOf(' '), Character.valueOf('=')));
        String key = rfc6264String.substring(startKey, endKey);
        int equalPos = FakeCookie.scanTo(rfc6264String, endKey - 1, List.of(Character.valueOf('=')));
        if (equalPos == -1) {
            throw new IllegalArgumentException("No value for rfc6264String string " + rfc6264String);
        }
        int startValue = FakeCookie.scanToNot(rfc6264String, equalPos + 1, List.of(Character.valueOf('\t'), Character.valueOf(' ')));
        if (rfc6264String.charAt(startValue) == '\"') {
            if ((endValue = FakeCookie.scanTo(rfc6264String, ++startValue, List.of(Character.valueOf('\"')))) == -1) {
                throw new IllegalArgumentException("Quoted rfc6264String value not terminated " + rfc6264String);
            }
            offset = FakeCookie.scanTo(rfc6264String, endValue, List.of(Character.valueOf(';')));
        } else {
            endValue = FakeCookie.scanTo(rfc6264String, startValue, List.of(Character.valueOf(';')));
            if (endValue == rfc6264String.length()) {
                offset = endValue;
            } else if (rfc6264String.charAt(endValue + 1) != ';') {
                offset = FakeCookie.scanTo(rfc6264String, endValue, List.of(Character.valueOf(';')));
            }
        }
        String value = URLDecoder.decode(rfc6264String.substring(startValue, endValue), StandardCharsets.UTF_8);
        FakeCookie cookie = new FakeCookie(key, value);
        while (offset < rfc6264String.length()) {
            int attributeStart = FakeCookie.scanToNot(rfc6264String, offset + 1, List.of(Character.valueOf(' ')));
            int attributeEnd = FakeCookie.scanTo(rfc6264String, attributeStart, List.of(Character.valueOf('='), Character.valueOf(';')));
            String attribute = rfc6264String.substring(attributeStart, attributeEnd);
            if (attributeEnd < rfc6264String.length() && rfc6264String.charAt(attributeEnd) == '=') {
                int attributeValueEnd = FakeCookie.scanTo(rfc6264String, attributeEnd, List.of(Character.valueOf(';')));
                String attributeValue = rfc6264String.substring(attributeEnd + 1, attributeValueEnd);
                cookie.setAttribute(attribute, attributeValue);
                offset = attributeValueEnd;
                continue;
            }
            cookie.setAttribute(attribute, true);
            offset = attributeEnd;
        }
        return cookie;
    }

    public static Map<String, String> parseCookieHeader(String cookie) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int offset = 0;
        while (offset < cookie.length()) {
            int endValue;
            if (cookie.charAt(offset) == ';') {
                ++offset;
            }
            int startKey = FakeCookie.scanToNot(cookie, offset, List.of(Character.valueOf('\t'), Character.valueOf(' ')));
            int endKey = FakeCookie.scanTo(cookie, startKey + 1, List.of(Character.valueOf('\t'), Character.valueOf(' '), Character.valueOf('=')));
            String key = cookie.substring(startKey, endKey);
            int equalPos = FakeCookie.scanTo(cookie, endKey - 1, List.of(Character.valueOf('=')));
            if (equalPos == cookie.length()) {
                throw new IllegalArgumentException("No value for cookie string " + cookie);
            }
            int startValue = FakeCookie.scanToNot(cookie, equalPos + 1, List.of(Character.valueOf('\t'), Character.valueOf(' ')));
            if (cookie.charAt(startValue) == '\"') {
                if ((endValue = FakeCookie.scanTo(cookie, ++startValue, List.of(Character.valueOf('\"')))) == cookie.length()) {
                    throw new IllegalArgumentException("Quoted cookie value not terminated " + cookie);
                }
                offset = FakeCookie.scanTo(cookie, endValue, List.of(Character.valueOf(';')));
            } else {
                offset = endValue = FakeCookie.scanTo(cookie, startValue, List.of(Character.valueOf(';')));
            }
            String value = cookie.substring(startValue, endValue);
            result.put(key, URLDecoder.decode(value, StandardCharsets.UTF_8));
        }
        return result;
    }

    private static int scanTo(String s, int startPos, List<Character> characters) {
        for (int i = startPos; i < s.length(); ++i) {
            if (!characters.contains(Character.valueOf(s.charAt(i)))) continue;
            return i;
        }
        return s.length();
    }

    private static int scanToNot(String s, int startPos, List<Character> characters) {
        for (int i = startPos; i < s.length(); ++i) {
            if (characters.contains(Character.valueOf(s.charAt(i)))) continue;
            return i;
        }
        return s.length();
    }

    public static Optional<String> asClientCookieHeader(Collection<FakeCookie> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(cookies.stream().map(FakeCookie::toClientCookieString).collect(Collectors.joining(";")));
    }

    public static List<FakeCookie> parseSetCookieHeaders(List<String> setCookieHeaders) {
        if (setCookieHeaders == null) {
            return List.of();
        }
        return setCookieHeaders.stream().map(FakeCookie::parseSetCookieHeader).collect(Collectors.toList());
    }

    public static Supplier<Map<String, List<String>>> parseClientCookieMap(final List<String> cookieHeaders) {
        return new Supplier<Map<String, List<String>>>(){
            private final AtomicReference<Map<String, List<String>>> cookies = new AtomicReference();

            @Override
            public Map<String, List<String>> get() {
                Map<String, List<String>> result = this.cookies.get();
                if (result != null) {
                    return result;
                }
                return this.cookies.updateAndGet(cur -> FakeCookie.parseClientCookies(cookieHeaders));
            }
        };
    }

    public static Map<String, List<String>> parseClientCookies(List<String> cookieHeaders) {
        if (cookieHeaders == null) {
            return Map.of();
        }
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (String cookieHeader : cookieHeaders) {
            FakeCookie.parseCookieHeader(cookieHeader).forEach((name, value) -> result.computeIfAbsent((String)name, n -> new ArrayList()).add(value));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String toStringRFC6265() {
        String attributeValues = this.cookieAttributeValues();
        return this.toClientCookieString() + (String)(attributeValues.isEmpty() ? "" : "; " + attributeValues);
    }

    public String toClientCookieString() {
        String value = this.value.isEmpty() ? "" : "\"" + URLEncoder.encode(this.value, StandardCharsets.UTF_8) + "\"";
        return this.name + "=" + value;
    }

    String cookieAttributeValues() {
        ArrayList<Object> builder = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                builder.add(entry.getKey());
                continue;
            }
            if (entry.getValue() instanceof Instant) {
                Instant instant = (Instant)entry.getValue();
                builder.add(entry.getKey() + "=" + DateTimeFormatter.RFC_1123_DATE_TIME.format(instant.atZone(ZoneOffset.UTC)));
                continue;
            }
            if (entry.getValue() == null) continue;
            builder.add(entry.getKey() + "=" + entry.getValue());
        }
        return String.join((CharSequence)"; ", builder);
    }

    public boolean isUnexpired() {
        Object attribute = this.getAttribute("Max-Age");
        return attribute == null || !attribute.equals(-1) && attribute.equals("-1");
    }

    public FakeCookie domain(String domain) {
        return this.setAttribute("Domain", domain);
    }

    public FakeCookie maxAge(int maxAge) {
        return this.setAttribute("Max-age", maxAge != -1 ? String.valueOf(maxAge) : null);
    }

    public FakeCookie path(String path) {
        return this.setAttribute("Path", path);
    }

    public FakeCookie sameSite(String sameSite) {
        return this.setAttribute("SameSite", sameSite);
    }

    public FakeCookie secure(boolean secure) {
        return this.setAttribute("Secure", secure);
    }

    public boolean secure() {
        return this.getBooleanAttribute("Secure");
    }

    public FakeCookie httpOnly(boolean httpOnly) {
        return this.setAttribute("HttpOnly", httpOnly);
    }

    public boolean httpOnly() {
        return this.getBooleanAttribute("HttpOnly");
    }

    public FakeCookie setAttribute(String key, String value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        return this;
    }

    public FakeCookie setAttribute(String key, Boolean value) {
        if (value == null || !value.booleanValue()) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, true);
        }
        return this;
    }

    private boolean getBooleanAttribute(String key) {
        return this.attributes.containsKey(key) && this.attributes.get(key) == Boolean.TRUE;
    }

    public String toString() {
        return "FakeCookie{name='" + this.name + "', value='" + this.value + "', attributes=" + this.attributes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakeCookie that = (FakeCookie)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.attributes);
    }
}

