/*
 * Decompiled with CFR 0.152.
 */
package org.fakeservlet.jakarta;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import org.fakeservlet.jakarta.FakeJakartaHttpSession;
import org.fakeservlet.jakarta.FakeJakartaResponse;

public class FakeJakartaRequest
implements HttpServletRequest {
    private final String scheme;
    private final int port;
    private final String host;
    private String method;
    private final String contextPath;
    private final String servletPath;
    private String pathInfo;
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
    private HttpSession httpSession;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private byte[] requestBody;
    private Principal userPrincipal;
    private final String protocol = "HTTP/1.1";
    private List<String> userRoles = new ArrayList<String>();
    private List<Cookie> cookies = new ArrayList<Cookie>();

    public FakeJakartaRequest(String method, URL contextRoot, String servletPath, String pathInfo) {
        this.setMethod(method);
        this.contextPath = contextRoot.getPath();
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.scheme = contextRoot.getProtocol();
        this.port = contextRoot.getPort() != -1 ? contextRoot.getPort() : this.defaultPort(this.scheme);
        this.host = contextRoot.getHost();
    }

    private int defaultPort(String scheme) {
        return scheme.equals("https") ? 443 : 80;
    }

    public String getAuthType() {
        throw this.unimplemented();
    }

    public void addCookie(String key, String value) {
        this.cookies.add(new Cookie(key, URLEncoder.encode(value, StandardCharsets.UTF_8)));
    }

    public Cookie[] getCookies() {
        return this.cookies.isEmpty() ? null : this.cookies.toArray(new Cookie[0]);
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String s = this.getHeader(name);
        return s != null ? DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)s, Instant::from).toEpochMilli() : -1L;
    }

    public String getHeader(String s) {
        return Optional.ofNullable(this.headers.get(s)).map(l -> (String)l.get(0)).orElse(null);
    }

    public Enumeration<String> getHeaders(String s) {
        return Optional.ofNullable(this.headers.get(s)).map(Collections::enumeration).orElse(null);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        return Optional.ofNullable(this.getHeader(name)).map(Integer::parseInt).orElse(-1);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathTranslated() {
        throw this.unimplemented();
    }

    private AssertionError unimplemented() {
        return new AssertionError((Object)"called unexpected method");
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        if (this.parameters.isEmpty()) {
            return null;
        }
        return this.parameters.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().map(v -> this.urlEncode((String)entry.getKey()) + "=" + this.urlEncode((String)v)).collect(Collectors.joining("&"))).collect(Collectors.joining("&"));
    }

    private String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.US_ASCII);
    }

    public String getRemoteUser() {
        return this.getUserPrincipal() != null ? this.getUserPrincipal().getName() : null;
    }

    public boolean isUserInRole(String s) {
        return this.userRoles.contains(s);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        throw this.unimplemented();
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath() + (this.getPathInfo() != null ? this.getPathInfo() : "");
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = this.getAuthority();
        url.append(this.getRequestURI());
        return url;
    }

    public StringBuffer getAuthority() {
        StringBuffer url = new StringBuffer(128);
        url.append(this.getScheme()).append("://").append(this.getRemoteHost());
        if (this.port > 0 && this.port != this.defaultPort(this.scheme)) {
            url.append(':').append(this.port);
        }
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (this.httpSession == null && create) {
            this.httpSession = new FakeJakartaHttpSession();
        }
        return this.httpSession;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        throw this.unimplemented();
    }

    public boolean isRequestedSessionIdValid() {
        throw this.unimplemented();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw this.unimplemented();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw this.unimplemented();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw this.unimplemented();
    }

    public boolean authenticate(HttpServletResponse response) {
        response.setStatus(401);
        return false;
    }

    public void login(String s, String s1) {
    }

    public void logout() {
    }

    public Collection<Part> getParts() {
        throw this.unimplemented();
    }

    public Part getPart(String s) {
        throw this.unimplemented();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) {
        throw this.unimplemented();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public String getCharacterEncoding() {
        throw this.unimplemented();
    }

    public void setCharacterEncoding(String s) {
    }

    public int getContentLength() {
        throw this.unimplemented();
    }

    public long getContentLengthLong() {
        throw this.unimplemented();
    }

    public String getContentType() {
        throw this.unimplemented();
    }

    public ServletInputStream getInputStream() {
        if (this.requestBody != null) {
            final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.requestBody);
            return new ServletInputStream(){

                public boolean isFinished() {
                    return inputStream.available() == 0;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                    throw FakeJakartaRequest.this.unimplemented();
                }

                public int read() {
                    return inputStream.read();
                }

                public int read(byte[] b, int off, int len) {
                    return inputStream.read(b, off, len);
                }
            };
        }
        throw new AssertionError((Object)"Call setRequestBody first");
    }

    public String getParameter(String s) {
        return this.parameters.containsKey(s) ? this.parameters.get(s).get(0) : null;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.parameters.keySet()).elements();
    }

    public String[] getParameterValues(String s) {
        return this.parameters.containsKey(s) ? this.parameters.get(s).toArray(new String[0]) : null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        this.parameters.forEach((k, v) -> map.put((String)k, this.getParameterValues((String)k)));
        return map;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.host;
    }

    public int getServerPort() {
        return this.port;
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return this.getServerName();
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        throw this.unimplemented();
    }

    public Enumeration<Locale> getLocales() {
        throw this.unimplemented();
    }

    public boolean isSecure() {
        throw this.unimplemented();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        throw this.unimplemented();
    }

    public String getRealPath(String s) {
        throw this.unimplemented();
    }

    public int getRemotePort() {
        throw this.unimplemented();
    }

    public String getLocalName() {
        throw this.unimplemented();
    }

    public String getLocalAddr() {
        throw this.unimplemented();
    }

    public int getLocalPort() {
        throw this.unimplemented();
    }

    public ServletContext getServletContext() {
        throw this.unimplemented();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new IllegalStateException("async context not supported");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.startAsync();
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        throw new IllegalStateException("async context not supported");
    }

    public DispatcherType getDispatcherType() {
        throw this.unimplemented();
    }

    public void addParameter(String key, String value) {
        this.parameters.computeIfAbsent(key, n -> new ArrayList()).add(value);
    }

    public void setSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, n -> new ArrayList()).add(value);
    }

    public void setRequestBody(byte[] requestBody) {
        this.requestBody = requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.setRequestBody(requestBody.getBytes());
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public FakeJakartaResponse service(HttpServlet servlet) throws ServletException, IOException {
        FakeJakartaResponse response = new FakeJakartaResponse(this);
        servlet.service((ServletRequest)this, (ServletResponse)response);
        return response;
    }

    public void setUser(String username, List<String> userRoles) {
        this.setUserPrincipal(() -> username);
        this.userRoles = userRoles;
    }
}

