/*
 * Decompiled with CFR 0.152.
 */
package org.fakeservlet.jakarta;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fakeservlet.FakeCookie;
import org.fakeservlet.jakarta.FakeJakartaRequest;

public class FakeJakartaResponse
implements HttpServletResponse {
    public static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private final FakeJakartaRequest request;
    private int statusCode = 200;
    private String statusMessage;
    private String contentType;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private String characterEncoding;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final ServletOutputStream servletOutputStream = new ServletOutputStream(){

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public void write(int b) {
            FakeJakartaResponse.this.outputStream.write(b);
        }
    };
    private final PrintWriter writer = new PrintWriter((OutputStream)this.servletOutputStream);

    public FakeJakartaResponse(FakeJakartaRequest request) {
        this.request = request;
    }

    public void addCookie(Cookie c) {
        this.addHeader("Set-Cookie", new FakeCookie(c.getName(), URLDecoder.decode(c.getValue(), StandardCharsets.UTF_8)).domain(c.getDomain()).maxAge(c.getMaxAge()).path(c.getPath()).secure(c.getSecure()).httpOnly(c.isHttpOnly()).toStringRFC6265());
    }

    public List<String> getCookies(String name) {
        return this.streamCookies().filter(c -> c.getName().equalsIgnoreCase(name)).map(FakeCookie::getValue).collect(Collectors.toList());
    }

    public List<FakeCookie> getCookies() {
        return this.streamCookies().collect(Collectors.toList());
    }

    private Stream<FakeCookie> streamCookies() {
        return this.getHeaders("Set-Cookie").stream().map(FakeCookie::parseSetCookieHeader);
    }

    public boolean containsHeader(String s) {
        throw this.unimplemented();
    }

    public String encodeURL(String s) {
        return this.encodeUrl(s);
    }

    public String encodeRedirectURL(String s) {
        return this.encodeRedirectUrl(s);
    }

    public String encodeUrl(String s) {
        return s;
    }

    public String encodeRedirectUrl(String s) {
        return this.encodeURL(s);
    }

    public void sendError(int sc, String msg) {
        this.setStatus(sc, msg);
    }

    public void sendError(int sc) {
        this.sendError(sc, "Server Error");
    }

    public void sendRedirect(String location) {
        this.statusCode = 302;
        if (((String)location).startsWith("/")) {
            location = this.request.getAuthority() + this.request.getContextPath() + (String)location;
        }
        this.setHeader("Location", this.encodeRedirectURL((String)location));
    }

    public void setDateHeader(String name, long epochMillis) {
        this.setHeader(name, DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.ofEpochMilli(epochMillis).atZone(ZoneId.systemDefault())));
    }

    public void addDateHeader(String s, long l) {
        throw this.unimplemented();
    }

    public void setHeader(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.put(name, List.of(value));
        }
    }

    public void addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, k -> new ArrayList()).add(value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String s, int i) {
        throw this.unimplemented();
    }

    public void setStatus(int sc) {
        this.setStatus(sc, null);
    }

    public void setStatus(int sc, String reason) {
        this.statusCode = sc;
        this.statusMessage = reason;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getHeader(String name) {
        return this.headers.containsKey(name) ? this.headers.get(name).get(0) : null;
    }

    public List<String> getHeaders(String s) {
        return this.headers.getOrDefault(s, new ArrayList());
    }

    public Collection<String> getHeaderNames() {
        throw this.unimplemented();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() {
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    private AssertionError unimplemented() {
        return new AssertionError((Object)"called unexpected method");
    }

    public void setContentLength(int i) {
        this.setContentLengthLong(i);
    }

    public void setContentLengthLong(long l) {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBufferSize(int i) {
        throw this.unimplemented();
    }

    public int getBufferSize() {
        throw this.unimplemented();
    }

    public void flushBuffer() {
        this.writer.flush();
    }

    public void resetBuffer() {
        throw this.unimplemented();
    }

    public boolean isCommitted() {
        throw this.unimplemented();
    }

    public void reset() {
        throw this.unimplemented();
    }

    public void setLocale(Locale locale) {
        throw this.unimplemented();
    }

    public Locale getLocale() {
        throw this.unimplemented();
    }

    public void assertNoError() {
        if (this.statusCode >= 400) {
            throw new AssertionError((Object)("Unexpected error " + this.statusCode + " " + this.statusMessage));
        }
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public byte[] getBody() {
        this.flushBuffer();
        return this.outputStream.toByteArray();
    }

    public String getBodyString() {
        return new String(this.getBody());
    }
}

