/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhannes.openapi.javalombok;

import io.github.jhannes.openapi.javalombok.PatchedHandlebarsEngineAdapter;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.ModelUtils;

public class JavaCodegen
extends AbstractJavaCodegen {
    private final Set<String> mixinInterfaces = new HashSet<String>();

    public JavaCodegen() {
        this.openApiNullable = false;
        this.templateDir = "JavaLombok";
        super.setTemplatingEngine((TemplatingEngineAdapter)new PatchedHandlebarsEngineAdapter());
        this.apiDocTemplateFiles.clear();
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.importMapping.put("EqualsAndHashCode", "lombok.EqualsAndHashCode");
        this.importMapping.put("Data", "lombok.Data");
        this.importMapping.put("ToString", "lombok.ToString");
        this.importMapping.put("Getter", "lombok.Getter");
        this.importMapping.put("RequiredArgsConstructor", "lombok.RequiredArgsConstructor");
    }

    public String getName() {
        return "java-lombok";
    }

    protected void addImports(CodegenModel m, IJsonSchemaValidationProperties type) {
        if (!type.getIsModel() && !type.getIsEnum() && (type.getItems() == null || type.getItems().getIsEnum() || type.getItems().isContainer)) {
            super.addImports(m, type);
        }
    }

    protected void addImport(Schema composed, Schema childSchema, CodegenModel model, String modelName) {
    }

    protected void updateModelForComposedSchema(CodegenModel m, Schema schema, Map<String, Schema> allDefinitions) {
        if (schema.getAllOf() != null) {
            m.allOf = new TreeSet();
            for (Schema refSchema : ModelUtils.getInterfaces((Schema)schema)) {
                ArrayList required = new ArrayList();
                LinkedHashMap properties = new LinkedHashMap();
                this.addProperties(properties, required, refSchema, new HashSet());
                if (StringUtils.isBlank((CharSequence)refSchema.get$ref())) {
                    this.addVars(m, this.unaliasPropertySchema(properties), required, this.unaliasPropertySchema(properties), required);
                    continue;
                }
                String ref = ModelUtils.getSimpleRef((String)refSchema.get$ref());
                m.allOf.add(this.toModelName(ref));
                this.addVars(m, Map.of(), List.of(), this.unaliasPropertySchema(properties), required);
            }
        }
        if (schema.getOneOf() != null) {
            m.oneOf = new TreeSet();
            for (Schema refSchema : ModelUtils.getInterfaces((Schema)schema)) {
                String ref = ModelUtils.getSimpleRef((String)refSchema.get$ref());
                m.oneOf.add(this.toModelName(ref));
            }
        }
    }

    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel cm = super.fromModel(name, model);
        cm.interfaceModels = new ArrayList();
        cm.imports.remove("ApiModel");
        cm.imports.remove("ApiModelProperty");
        cm.allVars.removeIf(v -> cm.vars.stream().anyMatch(vv -> vv.name.equals(v.name)));
        cm.allVars.addAll(cm.vars);
        return cm;
    }

    public String toSetter(String name) {
        return "set" + JavaCodegen.capitalizeFirst(name);
    }

    public String toGetter(String name) {
        return "get" + JavaCodegen.capitalizeFirst(name);
    }

    public void processOpts() {
        if (!this.additionalProperties.containsKey("packageName")) {
            this.additionalProperties.put("packageName", "org.openapitools.client");
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", String.valueOf(this.additionalProperties.get("packageName")) + ".api");
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", String.valueOf(this.additionalProperties.get("packageName")) + ".model");
        }
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("lombok.config", this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar), "lombok.config"));
        if (this.additionalProperties.get("generateModelTests") == Boolean.TRUE) {
            this.supportingFiles.add(new SupportingFile("sampleData.handlebars", this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar), "SampleData.java"));
            this.supportingFiles.add(new SupportingFile("sampleModelData.handlebars", this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar), "SampleModelData.java"));
        }
    }

    public void setTemplatingEngine(TemplatingEngineAdapter templatingEngine) {
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("Arrays");
    }

    public String toModelName(String name) {
        return this.mixinInterfaces.contains(name) ? name : super.toModelName(name);
    }

    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map result = super.postProcessAllModels(objs);
        this.processAllOfTypes(result);
        this.processOneOfInterfaces(result);
        this.setupDerivedVariables(result);
        return result;
    }

    private void setupDerivedVariables(Map<String, ModelsMap> result) {
        List<CodegenModel> allCodegenModels = JavaCodegen.getCodegenModels(result.values());
        for (CodegenModel model : allCodegenModels) {
            TreeSet<CodegenModel> children = new TreeSet<CodegenModel>(Comparator.comparing(CodegenModel::getClassname));
            allCodegenModels.stream().filter(c -> c.parentModel == model).forEach(children::add);
            allCodegenModels.stream().filter(c -> c.interfaceModels.contains(model)).forEach(children::add);
            model.children = new ArrayList<CodegenModel>(children);
        }
        Map allModels = this.getAllModels(result);
        for (ModelsMap modelsMap : result.values()) {
            for (ModelMap modelMap : modelsMap.getModels()) {
                CodegenModel model = modelMap.getModel();
                model.parent = model.additionalPropertiesType != null ? model.parent : (model.parentModel != null ? model.parentModel.classname : null);
                model.interfaces = model.interfaceModels.stream().map(CodegenModel::getClassname).collect(Collectors.toList());
                for (CodegenProperty var : model.getAllVars()) {
                    if (var.isModel && var.required && ((CodegenModel)allModels.get((Object)var.dataType)).oneOf.isEmpty()) {
                        var.defaultValue = "new " + var.dataType + "()";
                    }
                    if (var.get_enum() == null || var.get_enum().size() != 1) continue;
                    var.defaultValue = "\"" + (String)var.get_enum().getFirst() + "\"";
                    var.dataType = "\"" + (String)var.get_enum().getFirst() + "\"";
                    var.datatypeWithEnum = "String";
                    var.defaultValueWithParam = var.defaultValue;
                    var.isInnerEnum = false;
                    var.isEnum = false;
                    var.allowableValues = null;
                    var.isInherited = false;
                }
                model.vars = model.getAllVars().stream().filter(v -> !v.isInherited).toList();
                model.parentVars = model.getAllVars().stream().filter(v -> v.isInherited).toList();
                model.requiredVars = model.getVars().stream().filter(v -> v.required).toList();
                model.hasRequired = !model.requiredVars.isEmpty();
                model.hasMoreModels = model.vars.stream().anyMatch(v -> v.isModel);
                model.optionalVars = model.getVars().stream().filter(v -> !v.required).toList();
                model.hasOptional = !model.optionalVars.isEmpty();
                model.hasEnums = model.getVars().stream().anyMatch(v -> v.isEnum);
                model.hasEnums = model.getVars().stream().anyMatch(v -> v.isEnum);
                boolean hasInnerEnum = model.getVars().stream().anyMatch(v -> v.isInnerEnum && v.isEnum);
                if (!model.isEnum) {
                    JavaCodegen.addImport(modelsMap, "java.util.List");
                }
                if (model.oneOf.isEmpty() && !model.classname.endsWith("Interface") && !model.isEnum) {
                    JavaCodegen.addImport(modelsMap, "lombok.Data");
                    if (model.parent != null) {
                        JavaCodegen.addImport(modelsMap, "lombok.EqualsAndHashCode");
                    }
                }
                if (model.isEnum || hasInnerEnum) {
                    JavaCodegen.addImport(modelsMap, "lombok.Getter");
                    JavaCodegen.addImport(modelsMap, "lombok.RequiredArgsConstructor");
                }
                if (model.hasRequired || model.hasMoreModels) {
                    JavaCodegen.addImport(modelsMap, "java.util.ArrayList");
                }
                if (model.hasOptional) {
                    JavaCodegen.addImport(modelsMap, "java.util.Objects");
                }
                modelsMap.getImports().sort(Comparator.comparing(s -> (String)s.get("import")));
            }
        }
    }

    private static void addImport(ModelsMap modelsMap, String importedClass) {
        if (!modelsMap.getImports().contains(Map.of("import", importedClass))) {
            modelsMap.getImports().add(Map.of("import", importedClass));
        }
    }

    private void processAllOfTypes(Map<String, ModelsMap> result) {
        HashMap<String, CodegenModel> multiplyInheritedTypes = new HashMap<String, CodegenModel>();
        Map allModels = this.getAllModels(result);
        for (Map.Entry codegenEntry : allModels.entrySet()) {
            CodegenModel codegenModel = (CodegenModel)codegenEntry.getValue();
            if (codegenModel.allOf.size() > 1) {
                for (String implementedInterfaceName : codegenModel.allOf) {
                    CodegenModel implementedInterface = (CodegenModel)allModels.get(implementedInterfaceName);
                    codegenModel.interfaceModels.add(multiplyInheritedTypes.computeIfAbsent(implementedInterface.name, i -> JavaCodegen.createMixin(implementedInterface)));
                    CodegenModel parentInterface = implementedInterface.parentModel;
                    while (parentInterface != null) {
                        if (!multiplyInheritedTypes.containsKey(parentInterface.name)) {
                            multiplyInheritedTypes.put(parentInterface.name, JavaCodegen.createMixin(parentInterface));
                        }
                        parentInterface = parentInterface.parentModel;
                    }
                }
                for (CodegenProperty var : codegenModel.allVars) {
                    for (CodegenModel interfaceModel : codegenModel.interfaceModels) {
                        if (!interfaceModel.allVars.stream().anyMatch(v -> v.name.equals(var.name))) continue;
                        var.isNew = true;
                    }
                }
                continue;
            }
            if (codegenModel.allOf.isEmpty()) continue;
            codegenModel.parentModel = (CodegenModel)allModels.get(codegenModel.allOf.iterator().next());
            for (CodegenProperty var : codegenModel.allVars) {
                if (!codegenModel.parentModel.allVars.stream().anyMatch(v -> v.name.equals(var.name))) continue;
                var.isInherited = true;
                var.isNew = true;
            }
        }
        for (CodegenModel interfaceModel : multiplyInheritedTypes.values()) {
            ModelsMap modelsMap = result.get(interfaceModel.name);
            CodegenModel dtoModel = ((ModelMap)modelsMap.getModels().get(0)).getModel();
            dtoModel.interfaceModels = List.of(interfaceModel);
            dtoModel.allOf = Set.of();
            if (dtoModel.parentModel != null) {
                interfaceModel.parentModel = (CodegenModel)multiplyInheritedTypes.get(dtoModel.parentModel.name);
                interfaceModel.interfaceModels.add(interfaceModel.parentModel);
            }
            ModelMap modelMap = new ModelMap();
            modelMap.setModel(interfaceModel);
            ModelsMap models = new ModelsMap();
            models.putAll((Map)modelsMap);
            models.setModels(List.of(modelMap));
            result.put(interfaceModel.classname, models);
            this.mixinInterfaces.add(interfaceModel.classname);
            for (CodegenModel codegenModel : allModels.values()) {
                if (!codegenModel.interfaceModels.contains(interfaceModel)) continue;
                for (CodegenProperty property : codegenModel.allVars) {
                    if (!property.isEnum) continue;
                    property.isEnum = false;
                    property.dataType = property.datatypeWithEnum;
                }
            }
        }
    }

    private static CodegenModel createMixin(CodegenModel dtoModel) {
        CodegenModel interfaceModel = new CodegenModel(){
            public boolean isMixin = true;

            public Collection<CodegenModel> getDescendants() {
                TreeMap<String, CodegenModel> result = new TreeMap<String, CodegenModel>();
                this.putDescendants(this, result);
                return result.values();
            }

            private void putDescendants(CodegenModel codegenModel, Map<String, CodegenModel> descendants) {
                for (CodegenModel child : codegenModel.children) {
                    if (descendants.containsKey(child.name)) {
                        if (descendants.get((Object)child.name).interfaceModels.contains(child)) {
                            descendants.put(child.name, child);
                        }
                    } else {
                        descendants.put(child.name, child);
                    }
                    this.putDescendants(child, descendants);
                }
            }
        };
        interfaceModel.name = dtoModel.name;
        interfaceModel.interfaceModels = new ArrayList();
        interfaceModel.classname = dtoModel.name + "Interface";
        for (CodegenProperty property : dtoModel.allVars) {
            CodegenProperty clone = property.clone();
            interfaceModel.allVars.add(clone);
            property.isNew = true;
        }
        return interfaceModel;
    }

    private static List<CodegenModel> getCodegenModels(Collection<ModelsMap> modelMaps) {
        return modelMaps.stream().flatMap(m -> m.getModels().stream().map(ModelMap::getModel)).toList();
    }

    private void processOneOfInterfaces(Map<String, ModelsMap> objs) {
        HashMap<String, List<CodegenModel>> interfacesOfSubtypes = new HashMap<String, List<CodegenModel>>();
        Map allModels = this.getAllModels(objs);
        for (CodegenModel codegenModel : allModels.values()) {
            if (codegenModel.oneOf.isEmpty()) continue;
            this.postProcessOneOf(codegenModel, interfacesOfSubtypes, allModels);
        }
        for (String implementationTypeName : interfacesOfSubtypes.keySet()) {
            CodegenModel codegenModel = (CodegenModel)allModels.get(implementationTypeName);
            codegenModel.interfaceModels = (List)interfacesOfSubtypes.get(codegenModel.classname);
        }
    }

    public void postProcessOneOf(CodegenModel codegenModel, Map<String, List<CodegenModel>> interfacesOfSubtypes, Map<String, CodegenModel> allModels) {
        HashSet<CodegenDiscriminator.MappedModel> mappedModels = new HashSet<CodegenDiscriminator.MappedModel>();
        HashMap<String, String> mapping = new HashMap<String, String>();
        CodegenDiscriminator discriminator = codegenModel.discriminator;
        if (discriminator != null) {
            discriminator.setPropertyName(discriminator.getPropertyBaseName());
            discriminator.setPropertyGetter(this.toGetter(discriminator.getPropertyBaseName()));
        }
        for (String className : codegenModel.oneOf) {
            CodegenModel subModel = allModels.get(className);
            if (subModel.oneOf.isEmpty()) {
                mappedModels.add(new CodegenDiscriminator.MappedModel(subModel.name, className));
                mapping.put(subModel.name, className);
            } else if (discriminator != null && subModel.discriminator != null && subModel.discriminator.getPropertyName().equals(discriminator.getPropertyName())) {
                if (subModel.discriminator.getMapping() == null) {
                    this.postProcessOneOf(subModel, interfacesOfSubtypes, allModels);
                }
                mappedModels.addAll(subModel.discriminator.getMappedModels());
                mapping.putAll(subModel.discriminator.getMapping());
            } else if (discriminator != null && subModel.discriminator != null) continue;
            List subtypeInterfaces = interfacesOfSubtypes.computeIfAbsent(className, k -> new ArrayList());
            if (!subtypeInterfaces.contains(codegenModel)) {
                subtypeInterfaces.add(codegenModel);
            }
            if (codegenModel.getDiscriminatorName() == null || !subModel.allVars.stream().noneMatch(v -> v.baseName.equals(codegenModel.getDiscriminatorName()))) continue;
            CodegenProperty property = new CodegenProperty();
            property.name = property.baseName = codegenModel.getDiscriminatorName();
            property.getter = this.toGetter(property.name);
            property.setter = this.toSetter(property.name);
            property.isString = true;
            property.datatypeWithEnum = "String";
            property.dataType = "String";
            property.required = true;
            property.defaultValue = "\"" + subModel.name + "\"";
            property.isInherited = false;
            property.isNew = true;
            property.isDiscriminator = true;
            subModel.allVars.addFirst(property);
        }
        codegenModel.allVars.removeIf(var -> codegenModel.interfaceModels.stream().anyMatch(model -> JavaCodegen.varNotInImplementation(var, model)));
        if (discriminator != null && discriminator.getMapping() == null) {
            discriminator.setMapping(mapping);
            discriminator.setMappedModels(mappedModels);
        }
        if (discriminator != null) {
            codegenModel.allVars.removeIf(v -> v.name.equals(discriminator.getPropertyName()));
        }
    }

    private static String capitalizeFirst(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static boolean varNotInImplementation(CodegenProperty var, CodegenModel model) {
        if (!model.oneOf.isEmpty()) {
            for (CodegenModel subtype : model.interfaceModels) {
                if (!JavaCodegen.varNotInImplementation(var, subtype)) continue;
                return true;
            }
        }
        return model.allVars.stream().noneMatch(memberVar -> memberVar.name.equals(var.name) && memberVar.datatypeWithEnum.equals(var.datatypeWithEnum));
    }

    public String toEnumVarName(String value, String datatype) {
        if (this.enumNameMapping.containsKey(value)) {
            return (String)this.enumNameMapping.get(value);
        }
        if (value.isEmpty()) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        if (" ".equals(value)) {
            return "SPACE";
        }
        if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype) || "BigDecimal".equals(datatype)) {
            Object varName = "NUMBER_" + value;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            varName = ((String)varName).replaceAll("\\.", "_DOT_");
            return varName;
        }
        Object var = value.replaceAll("\\W+", "_");
        if (((String)var).matches("\\d.*")) {
            var = "_" + (String)var;
        }
        return this.reservedWords.contains(var) ? this.escapeReservedWord((String)var) : var;
    }
}

