/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.config.locale;

import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.util.WebUtils;

public class AngularCookieLocaleResolver
extends CookieLocaleResolver {
    public static final String QUOTE = "%22";

    public Locale resolveLocale(HttpServletRequest request) {
        this.parseLocaleCookieIfNecessary(request);
        return (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
    }

    public LocaleContext resolveLocaleContext(final HttpServletRequest request) {
        this.parseLocaleCookieIfNecessary(request);
        return new TimeZoneAwareLocaleContext(){

            public Locale getLocale() {
                return (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
            }

            public TimeZone getTimeZone() {
                return (TimeZone)request.getAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME);
            }
        };
    }

    public void addCookie(HttpServletResponse response, String cookieValue) {
        super.addCookie(response, this.quote(cookieValue));
    }

    private void parseLocaleCookieIfNecessary(HttpServletRequest request) {
        if (request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME) == null) {
            Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
            Locale locale = null;
            TimeZone timeZone = null;
            if (cookie != null) {
                String value = cookie.getValue();
                String localePart = value = StringUtils.replace((String)value, (String)QUOTE, (String)"");
                String timeZonePart = null;
                int spaceIndex = localePart.indexOf(32);
                if (spaceIndex != -1) {
                    localePart = value.substring(0, spaceIndex);
                    timeZonePart = value.substring(spaceIndex + 1);
                }
                Locale locale2 = locale = !"-".equals(localePart) ? StringUtils.parseLocaleString((String)localePart.replace('-', '_')) : null;
                if (timeZonePart != null) {
                    timeZone = StringUtils.parseTimeZoneString(timeZonePart);
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Parsed cookie value [" + cookie.getValue() + "] into locale '" + locale + "'" + (timeZone != null ? " and time zone '" + timeZone.getID() + "'" : "")));
                }
            }
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, locale != null ? locale : this.determineDefaultLocale(request));
            request.setAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME, timeZone != null ? timeZone : this.determineDefaultTimeZone(request));
        }
    }

    String quote(String string) {
        return QUOTE + string + QUOTE;
    }
}

