/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.domain.util;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;

public final class JSR310DateConverters {
    private JSR310DateConverters() {
    }

    public static class DateToLocalDateConverter
    implements Converter<Date, LocalDate> {
        public static final DateToLocalDateConverter INSTANCE = new DateToLocalDateConverter();

        private DateToLocalDateConverter() {
        }

        public LocalDate convert(Date source) {
            return source == null ? null : ZonedDateTime.ofInstant(source.toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
    }

    public static class DateToLocalDateTimeConverter
    implements Converter<Date, LocalDateTime> {
        public static final DateToLocalDateTimeConverter INSTANCE = new DateToLocalDateTimeConverter();

        private DateToLocalDateTimeConverter() {
        }

        public LocalDateTime convert(Date source) {
            return source == null ? null : LocalDateTime.ofInstant(source.toInstant(), ZoneId.systemDefault());
        }
    }

    public static class DateToZonedDateTimeConverter
    implements Converter<Date, ZonedDateTime> {
        public static final DateToZonedDateTimeConverter INSTANCE = new DateToZonedDateTimeConverter();

        private DateToZonedDateTimeConverter() {
        }

        public ZonedDateTime convert(Date source) {
            return source == null ? null : ZonedDateTime.ofInstant(source.toInstant(), ZoneId.systemDefault());
        }
    }

    public static class DurationToLongConverter
    implements Converter<Duration, Long> {
        public static final DurationToLongConverter INSTANCE = new DurationToLongConverter();

        private DurationToLongConverter() {
        }

        public Long convert(Duration source) {
            return source == null ? null : Long.valueOf(source.toNanos());
        }
    }

    public static class LocalDateTimeToDateConverter
    implements Converter<LocalDateTime, Date> {
        public static final LocalDateTimeToDateConverter INSTANCE = new LocalDateTimeToDateConverter();

        private LocalDateTimeToDateConverter() {
        }

        public Date convert(LocalDateTime source) {
            return source == null ? null : Date.from(source.atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    public static class LocalDateToDateConverter
    implements Converter<LocalDate, Date> {
        public static final LocalDateToDateConverter INSTANCE = new LocalDateToDateConverter();

        private LocalDateToDateConverter() {
        }

        public Date convert(LocalDate source) {
            return source == null ? null : Date.from(source.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }

    public static class LongToDurationConverter
    implements Converter<Long, Duration> {
        public static final LongToDurationConverter INSTANCE = new LongToDurationConverter();

        private LongToDurationConverter() {
        }

        public Duration convert(Long source) {
            return source == null ? null : Duration.ofNanos(source);
        }
    }

    public static class ZonedDateTimeToDateConverter
    implements Converter<ZonedDateTime, Date> {
        public static final ZonedDateTimeToDateConverter INSTANCE = new ZonedDateTimeToDateConverter();

        private ZonedDateTimeToDateConverter() {
        }

        public Date convert(ZonedDateTime source) {
            return source == null ? null : Date.from(source.toInstant());
        }
    }
}

