/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.service;

import io.github.jhipster.service.filter.Filter;
import io.github.jhipster.service.filter.RangeFilter;
import io.github.jhipster.service.filter.StringFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class QueryService<ENTITY> {
    protected <X> Specification<ENTITY> buildSpecification(Filter<X> filter, SingularAttribute<? super ENTITY, X> field) {
        return this.buildSpecification(filter, (Root<ENTITY> root) -> root.get(field));
    }

    protected <X> Specification<ENTITY> buildSpecification(Filter<X> filter, Function<Root<ENTITY>, Expression<X>> metaclassFunction) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(metaclassFunction, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(metaclassFunction, filter.getIn());
        }
        if (filter.getNotEquals() != null) {
            return this.notEqualsSpecification(metaclassFunction, filter.getNotEquals());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(metaclassFunction, filter.getSpecified());
        }
        return null;
    }

    protected Specification<ENTITY> buildStringSpecification(StringFilter filter, SingularAttribute<? super ENTITY, String> field) {
        return this.buildSpecification(filter, (Root<ENTITY> root) -> root.get(field));
    }

    protected Specification<ENTITY> buildSpecification(StringFilter filter, Function<Root<ENTITY>, Expression<String>> metaclassFunction) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(metaclassFunction, (String)filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(metaclassFunction, filter.getIn());
        }
        if (filter.getContains() != null) {
            return this.likeUpperSpecification(metaclassFunction, filter.getContains());
        }
        if (filter.getDoesNotContain() != null) {
            return this.doesNotContainSpecification(metaclassFunction, filter.getDoesNotContain());
        }
        if (filter.getNotEquals() != null) {
            return this.notEqualsSpecification(metaclassFunction, (String)filter.getNotEquals());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(metaclassFunction, filter.getSpecified());
        }
        return null;
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> buildRangeSpecification(RangeFilter<X> filter, SingularAttribute<? super ENTITY, X> field) {
        return this.buildSpecification(filter, (Root<ENTITY> root) -> root.get(field));
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> buildSpecification(RangeFilter<X> filter, Function<Root<ENTITY>, Expression<X>> metaclassFunction) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(metaclassFunction, (Comparable)filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(metaclassFunction, filter.getIn());
        }
        Specification result = Specification.where(null);
        if (filter.getSpecified() != null) {
            result = result.and(this.byFieldSpecified(metaclassFunction, filter.getSpecified()));
        }
        if (filter.getNotEquals() != null) {
            result = result.and(this.notEqualsSpecification(metaclassFunction, (Comparable)filter.getNotEquals()));
        }
        if (filter.getGreaterThan() != null) {
            result = result.and(this.greaterThan(metaclassFunction, filter.getGreaterThan()));
        }
        if (filter.getGreaterThanOrEqual() != null) {
            result = result.and(this.greaterThanOrEqualTo(metaclassFunction, filter.getGreaterThanOrEqual()));
        }
        if (filter.getLessThan() != null) {
            result = result.and(this.lessThan(metaclassFunction, filter.getLessThan()));
        }
        if (filter.getLessThanOrEqual() != null) {
            result = result.and(this.lessThanOrEqualTo(metaclassFunction, filter.getLessThanOrEqual()));
        }
        return result;
    }

    protected <OTHER, X> Specification<ENTITY> buildReferringEntitySpecification(Filter<X> filter, SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<? super OTHER, X> valueField) {
        return this.buildSpecification(filter, (Root<ENTITY> root) -> root.get(reference).get(valueField));
    }

    protected <OTHER, X> Specification<ENTITY> buildReferringEntitySpecification(Filter<X> filter, SetAttribute<ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField) {
        return this.buildReferringEntitySpecification(filter, (Root<ENTITY> root) -> root.join(reference), (SetJoin<MISC, OTHER> entity) -> entity.get(valueField));
    }

    protected <OTHER, MISC, X> Specification<ENTITY> buildReferringEntitySpecification(Filter<X> filter, Function<Root<ENTITY>, SetJoin<MISC, OTHER>> functionToEntity, Function<SetJoin<MISC, OTHER>, Expression<X>> entityToColumn) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(functionToEntity.andThen(entityToColumn), filter.getEquals());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(root -> (Expression)functionToEntity.apply((Root)root), filter.getSpecified());
        }
        return null;
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> buildReferringEntitySpecification(RangeFilter<X> filter, SetAttribute<ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField) {
        return this.buildReferringEntitySpecification(filter, (Root<ENTITY> root) -> root.join(reference), (SetJoin<MISC, OTHER> entity) -> entity.get(valueField));
    }

    protected <OTHER, MISC, X extends Comparable<? super X>> Specification<ENTITY> buildReferringEntitySpecification(RangeFilter<X> filter, Function<Root<ENTITY>, SetJoin<MISC, OTHER>> functionToEntity, Function<SetJoin<MISC, OTHER>, Expression<X>> entityToColumn) {
        Function<Root<ENTITY>, Expression<X>> fused = functionToEntity.andThen(entityToColumn);
        if (filter.getEquals() != null) {
            return this.equalsSpecification(fused, (Comparable)filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(fused, filter.getIn());
        }
        Specification result = Specification.where(null);
        if (filter.getSpecified() != null) {
            result = result.and(this.byFieldSpecified(root -> (Expression)functionToEntity.apply((Root)root), filter.getSpecified()));
        }
        if (filter.getNotEquals() != null) {
            result = result.and(this.notEqualsSpecification(fused, (Comparable)filter.getNotEquals()));
        }
        if (filter.getGreaterThan() != null) {
            result = result.and(this.greaterThan(fused, filter.getGreaterThan()));
        }
        if (filter.getGreaterThanOrEqual() != null) {
            result = result.and(this.greaterThanOrEqualTo(fused, filter.getGreaterThanOrEqual()));
        }
        if (filter.getLessThan() != null) {
            result = result.and(this.lessThan(fused, filter.getLessThan()));
        }
        if (filter.getLessThanOrEqual() != null) {
            result = result.and(this.lessThanOrEqualTo(fused, filter.getLessThanOrEqual()));
        }
        return result;
    }

    protected <X> Specification<ENTITY> equalsSpecification(Function<Root<ENTITY>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)metaclassFunction.apply(root), value);
    }

    protected <X> Specification<ENTITY> notEqualsSpecification(Function<Root<ENTITY>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.not((Expression)builder.equal((Expression)metaclassFunction.apply(root), value));
    }

    protected Specification<ENTITY> likeUpperSpecification(Function<Root<ENTITY>, Expression<String>> metaclassFunction, String value) {
        return (Specification & Serializable)(root, query, builder) -> builder.like(builder.upper((Expression)metaclassFunction.apply(root)), this.wrapLikeQuery(value));
    }

    protected Specification<ENTITY> doesNotContainSpecification(Function<Root<ENTITY>, Expression<String>> metaclassFunction, String value) {
        return (Specification & Serializable)(root, query, builder) -> builder.not((Expression)builder.like(builder.upper((Expression)metaclassFunction.apply(root)), this.wrapLikeQuery(value)));
    }

    protected <X> Specification<ENTITY> byFieldSpecified(Function<Root<ENTITY>, Expression<X>> metaclassFunction, boolean specified) {
        return specified ? (Specification & Serializable)(root, query, builder) -> builder.isNotNull((Expression)metaclassFunction.apply(root)) : (Specification & Serializable)(root, query, builder) -> builder.isNull((Expression)metaclassFunction.apply(root));
    }

    protected <X> Specification<ENTITY> byFieldEmptiness(Function<Root<ENTITY>, Expression<Set<X>>> metaclassFunction, boolean specified) {
        return specified ? (Specification & Serializable)(root, query, builder) -> builder.isNotEmpty((Expression)metaclassFunction.apply(root)) : (Specification & Serializable)(root, query, builder) -> builder.isEmpty((Expression)metaclassFunction.apply(root));
    }

    protected <X> Specification<ENTITY> valueIn(Function<Root<ENTITY>, Expression<X>> metaclassFunction, Collection<X> values) {
        return (Specification & Serializable)(root, query, builder) -> {
            CriteriaBuilder.In in = builder.in((Expression)metaclassFunction.apply(root));
            for (Object value : values) {
                in = in.value(value);
            }
            return in;
        };
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> greaterThanOrEqualTo(Function<Root<ENTITY>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThanOrEqualTo((Expression)metaclassFunction.apply(root), value);
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> greaterThan(Function<Root<ENTITY>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThan((Expression)metaclassFunction.apply(root), value);
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> lessThanOrEqualTo(Function<Root<ENTITY>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThanOrEqualTo((Expression)metaclassFunction.apply(root), value);
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> lessThan(Function<Root<ENTITY>, Expression<X>> metaclassFunction, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThan((Expression)metaclassFunction.apply(root), value);
    }

    protected String wrapLikeQuery(String txt) {
        return "%" + txt.toUpperCase() + '%';
    }
}

