/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.loaded.hibernate;

import java.util.Collection;
import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JHipsterEntityManagerFactoryWrapper
implements EntityManagerFactory {
    private PersistenceUnitInfo info;
    private Map properties;
    private EntityManagerFactory entityManagerFactory;
    private static JHipsterEntityManagerFactoryWrapper instance;

    public JHipsterEntityManagerFactoryWrapper(PersistenceUnitInfo info, Map properties) {
        this.info = info;
        this.properties = properties;
        instance = this;
        this.build(null);
    }

    public static void reload(Collection<Class> entities) {
        instance.build(entities);
    }

    private void build(Collection<Class> entities) {
        if (entities != null) {
            MutablePersistenceUnitInfo mutablePersistenceUnitInfo = (MutablePersistenceUnitInfo)this.info;
            for (Class entity : entities) {
                mutablePersistenceUnitInfo.addManagedClassName(entity.getName());
            }
        }
        this.entityManagerFactory = Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitInfo)this.info, (Map)this.properties).build();
    }

    public EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.entityManagerFactory.createEntityManager(map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.entityManagerFactory.createEntityManager(synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.entityManagerFactory.createEntityManager(synchronizationType, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.entityManagerFactory.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.entityManagerFactory.getMetamodel();
    }

    public boolean isOpen() {
        return this.entityManagerFactory.isOpen();
    }

    public void close() {
        this.entityManagerFactory.close();
    }

    public Map<String, Object> getProperties() {
        return this.entityManagerFactory.getProperties();
    }

    public Cache getCache() {
        return this.entityManagerFactory.getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.entityManagerFactory.getPersistenceUnitUtil();
    }

    public void addNamedQuery(String name, Query query) {
        this.entityManagerFactory.addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.entityManagerFactory.unwrap(cls);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.entityManagerFactory.addNamedEntityGraph(graphName, entityGraph);
    }
}

