/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.loaded.instrument;

import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import org.springsource.loaded.LoadtimeInstrumentationPlugin;

public class JHipsterLoadtimeInstrumentationPlugin
implements LoadtimeInstrumentationPlugin {
    private final Logger log = Logger.getLogger(JHipsterLoadtimeInstrumentationPlugin.class.getName());

    @Override
    public boolean accept(String slashedTypeName, ClassLoader classLoader, ProtectionDomain protectionDomain, byte[] bytes) {
        return slashedTypeName != null && (slashedTypeName.equals("org/springframework/security/access/method/DelegatingMethodSecurityMetadataSource") || slashedTypeName.equals("org/springframework/aop/framework/AdvisedSupport") || slashedTypeName.equals("liquibase/ext/hibernate/snapshot/TableSnapshotGenerator") || slashedTypeName.equals("org/hibernate/jpa/HibernatePersistenceProvider") || slashedTypeName.equals("org/hibernate/engine/internal/CacheHelper") || slashedTypeName.equals("org/springframework/data/repository/core/support/TransactionalRepositoryProxyPostProcessor") || slashedTypeName.equals("org/springframework/core/LocalVariableTableParameterNameDiscoverer"));
    }

    @Override
    public byte[] modify(String slashedClassName, ClassLoader classLoader, byte[] bytes) {
        ClassPool classPool = ClassPool.getDefault();
        classPool.appendClassPath(new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
        classPool.appendClassPath(new LoaderClassPath(classLoader));
        try {
            CtMethod ctMethod;
            CtClass ctClass;
            if (slashedClassName.equals("org/springframework/security/access/method/DelegatingMethodSecurityMetadataSource")) {
                ctClass = classPool.get("org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource");
                ctMethod = ctClass.getDeclaredMethod("getAttributes");
                ctMethod.insertBefore("{synchronized (attributeCache) { attributeCache.clear();} }");
                bytes = ctClass.toBytecode();
                ctClass.defrost();
            }
            if (slashedClassName.equals("org/springframework/aop/framework/AdvisedSupport")) {
                ctClass = classPool.get("org.springframework.aop.framework.AdvisedSupport");
                ctMethod = ctClass.getDeclaredMethod("getInterceptorsAndDynamicInterceptionAdvice");
                ctMethod.insertBefore("{ adviceChanged(); }");
                bytes = ctClass.toBytecode();
                ctClass.defrost();
            }
            if (slashedClassName.equals("liquibase/ext/hibernate/snapshot/TableSnapshotGenerator")) {
                ctClass = classPool.get("liquibase.ext.hibernate.snapshot.TableSnapshotGenerator");
                ctClass.setSuperclass(classPool.get("io.github.jhipster.loaded.patch.liquibase.JHipsterTableSnapshotGenerator"));
                ctMethod = ctClass.getDeclaredMethod("snapshotObject");
                ctMethod.setBody("{ return super.snapshotObject($1, $2);}");
                bytes = ctClass.toBytecode();
                ctClass.defrost();
            }
            if (slashedClassName.equals("org/hibernate/jpa/HibernatePersistenceProvider")) {
                ctClass = classPool.get("org.hibernate.jpa.HibernatePersistenceProvider");
                ctClass.setSuperclass(classPool.get("io.github.jhipster.loaded.hibernate.JHipsterPersistenceProvider"));
                ctMethod = ctClass.getDeclaredMethod("createContainerEntityManagerFactory");
                ctMethod.setBody("{ return super.createContainerEntityManagerFactory($1, $2); }");
                bytes = ctClass.toBytecode();
                ctClass.defrost();
            }
            if (slashedClassName.equals("org/hibernate/engine/internal/CacheHelper")) {
                ctClass = classPool.get("org.hibernate.engine.internal.CacheHelper");
                CtClass sessionClass = classPool.get("org.hibernate.engine.spi.SessionImplementor");
                CtClass cacheKeyClass = classPool.get("org.hibernate.cache.spi.CacheKey");
                CtClass regionAccessStrategyClass = classPool.get("org.hibernate.cache.spi.access.RegionAccessStrategy");
                CtMethod ctMethod2 = ctClass.getDeclaredMethod("fromSharedCache", new CtClass[]{sessionClass, cacheKeyClass, regionAccessStrategyClass});
                ctMethod2.setBody("{ return null; }");
                bytes = ctClass.toBytecode();
                ctClass.defrost();
            }
            if (slashedClassName.equals("org/springframework/data/repository/core/support/TransactionalRepositoryProxyPostProcessor")) {
                ctClass = classPool.get("org.springframework.data.repository.core.support.TransactionalRepositoryProxyPostProcessor");
                ctClass.setModifiers(1);
                bytes = ctClass.toBytecode();
                ctClass.defrost();
            }
            if (slashedClassName.equals("org/springframework/core/LocalVariableTableParameterNameDiscoverer")) {
                ctClass = classPool.get("org.springframework.core.LocalVariableTableParameterNameDiscoverer");
                ctMethod = ctClass.getDeclaredMethod("getParameterNames", new CtClass[]{classPool.get("java.lang.reflect.Method")});
                ctMethod.insertBefore("{ this.parameterNamesCache.clear(); }");
                ctMethod = ctClass.getDeclaredMethod("getParameterNames", new CtClass[]{classPool.get("java.lang.reflect.Constructor")});
                ctMethod.insertBefore("{ this.parameterNamesCache.clear(); }");
                bytes = ctClass.toBytecode();
                ctClass.defrost();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Failed to modify the DelegatingMethodSecurityMetadataSource class", e);
        }
        return bytes;
    }
}

