/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.util.ArrayList;
import org.springsource.loaded.Constants;
import org.springsource.loaded.IncrementalTypeDescriptor;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Attribute;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.Label;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class DispatcherBuilder {
    public static byte[] createFor(ReloadableType rtype, IncrementalTypeDescriptor newVersionTypeDescriptor, String versionstamp) {
        ClassReader fileReader = new ClassReader(rtype.interfaceBytes);
        DispatcherBuilderVisitor dispatcherVisitor = new DispatcherBuilderVisitor(rtype, newVersionTypeDescriptor, versionstamp);
        fileReader.accept(dispatcherVisitor, 0);
        return dispatcherVisitor.getBytes();
    }

    static class DispatcherBuilderVisitor
    extends ClassVisitor
    implements Opcodes,
    Constants {
        private ClassWriter cw = new ClassWriter(1);
        private String classname;
        private String executorClassName;
        private String suffix;
        private ReloadableType rtype;
        private IncrementalTypeDescriptor typeDescriptor;

        public DispatcherBuilderVisitor(ReloadableType rtype, IncrementalTypeDescriptor typeDescriptor, String suffix) {
            super(327680);
            this.classname = rtype.getSlashedName();
            this.typeDescriptor = typeDescriptor;
            this.suffix = suffix;
            this.rtype = rtype;
            this.executorClassName = Utils.getExecutorName(this.classname, suffix);
        }

        public byte[] getBytes() {
            return this.cw.toByteArray();
        }

        public void visit(int version, int flags, String name, String signature, String superclassName, String[] interfaceNames) {
            String dispatcherName = Utils.getDispatcherName(this.classname, this.suffix);
            this.cw.visit(version, 1, dispatcherName, null, "java/lang/Object", new String[]{Utils.getInterfaceName(this.classname), "org/springsource/loaded/__DynamicallyDispatchable"});
            this.generateDefaultConstructor();
        }

        private void generateDefaultConstructor() {
            MethodVisitor mv = this.cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        private void generateClinitDispatcher() {
            MethodVisitor mv = this.cw.visitMethod(1, "___clinit___", "()V", null, null);
            mv.visitCode();
            mv.visitMethodInsn(184, this.executorClassName, "___clinit___", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return null;
        }

        public void visitAttribute(Attribute arg0) {
        }

        public void visitEnd() {
        }

        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }

        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            if (name.equals("__execute")) {
                this.generateDynamicDispatchMethod(name, descriptor, signature, exceptions);
            } else if (!name.equals("<init>")) {
                this.generateRegularMethod(name, descriptor, signature, exceptions);
            }
            return null;
        }

        private void generateDynamicDispatchMethod(String name, String descriptor, String signature, String[] exceptions) {
            boolean indexDispatcherInstance = false;
            boolean indexArgs = true;
            int indexTarget = 2;
            int indexNameAndDescriptor = 3;
            MethodVisitor mv = this.cw.visitMethod(1, name, descriptor, signature, exceptions);
            mv.visitCode();
            int maxStack = 0;
            ArrayList<MethodMember> methods = new ArrayList<MethodMember>(this.typeDescriptor.getNewOrChangedMethods());
            for (MethodMember m : this.typeDescriptor.getOriginal().getMethods()) {
                methods.add(m);
            }
            for (MethodMember method : methods) {
                if (MethodMember.isCatcher(method) || MethodMember.isSuperDispatcher(method)) continue;
                String nameWithDescriptor = method.name + method.descriptor;
                mv.visitVarInsn(25, 3);
                mv.visitLdcInsn(nameWithDescriptor);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
                Label label = new Label();
                mv.visitJumpInsn(153, label);
                if (!method.isStatic()) {
                    mv.visitVarInsn(25, 2);
                    mv.visitTypeInsn(192, this.classname);
                }
                String callDescriptor = method.isStatic() ? method.descriptor : Utils.insertExtraParameter(this.classname, method.descriptor);
                int pcount = Utils.getParameterCount(method.descriptor);
                if (pcount > maxStack) {
                    pcount = maxStack;
                }
                Utils.generateInstructionsToUnpackArrayAccordingToDescriptor(mv, method.descriptor, 1);
                Utils.ReturnType returnType = Utils.getReturnTypeDescriptor(method.descriptor);
                mv.visitMethodInsn(184, this.executorClassName, method.name, callDescriptor, false);
                if (returnType.isVoid()) {
                    mv.visitInsn(1);
                } else if (returnType.isPrimitive()) {
                    Utils.insertBoxInsns(mv, returnType.descriptor);
                }
                mv.visitInsn(176);
                mv.visitLabel(label);
            }
            for (MethodMember ctor : this.typeDescriptor.getLatestTypeDescriptor().getConstructors()) {
                String nameWithDescriptor = ctor.name + ctor.descriptor;
                mv.visitVarInsn(25, 3);
                mv.visitLdcInsn(nameWithDescriptor);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
                Label label = new Label();
                mv.visitJumpInsn(153, label);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, this.classname);
                String callDescriptor = Utils.insertExtraParameter(this.classname, ctor.descriptor);
                int pcount = Utils.getParameterCount(ctor.descriptor);
                if (pcount > maxStack) {
                    pcount = maxStack;
                }
                Utils.generateInstructionsToUnpackArrayAccordingToDescriptor(mv, ctor.descriptor, 1);
                mv.visitMethodInsn(184, this.executorClassName, "___init___", callDescriptor, false);
                mv.visitInsn(1);
                mv.visitInsn(176);
                mv.visitLabel(label);
            }
            String slashedSupertypeName = this.rtype.getTypeDescriptor().getSupertypeName();
            mv.visitFieldInsn(178, slashedSupertypeName, "r$type", "Lorg/springsource/loaded/ReloadableType;");
            mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "getDispatcher", "()Lorg/springsource/loaded/__DynamicallyDispatchable;", false);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(185, "org/springsource/loaded/__DynamicallyDispatchable", "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", false);
            mv.visitInsn(176);
            mv.visitMaxs(maxStack, 6);
            mv.visitEnd();
        }

        private void generateRegularMethod(String name, String descriptor, String signature, String[] exceptions) {
            boolean isClinit = name.equals("___clinit___");
            String originalDescriptor = isClinit ? descriptor : Utils.stripFirstParameter(descriptor);
            MethodMember method = null;
            if (name.equals("___init___")) {
                method = this.rtype.getConstructor(originalDescriptor);
            } else {
                if (isClinit) {
                    this.generateClinitDispatcher();
                    return;
                }
                method = name.startsWith("__") && !name.equals("__$swapInit") ? this.rtype.getMethod(name.substring(2), originalDescriptor) : this.rtype.getMethod(name, originalDescriptor);
            }
            boolean isStatic = method.isStatic();
            MethodVisitor mv = this.cw.visitMethod(1, name, descriptor, signature, exceptions);
            mv.visitCode();
            Utils.ReturnType returnTypeDescriptor = Utils.getReturnTypeDescriptor(descriptor);
            int params = Utils.getParameterCount(descriptor);
            String callDescriptor = isStatic ? originalDescriptor : descriptor;
            Utils.createLoadsBasedOnDescriptor(mv, callDescriptor, isStatic ? 2 : 1);
            mv.visitMethodInsn(184, this.executorClassName, name, callDescriptor, false);
            Utils.addCorrectReturnInstruction(mv, returnTypeDescriptor, false);
            mv.visitMaxs(params, params + 1);
            mv.visitEnd();
        }

        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        public void visitSource(String arg0, String arg1) {
        }
    }
}

