/*
 * Decompiled with CFR 0.152.
 */
package io.github.jihongkim98.redisextensions;

import java.lang.reflect.Method;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.serializer.RedisSerializer;

public class BroadcastMethodInvoker
implements MessageListener {
    private static final RedisSerializer<String> serializer = RedisSerializer.string();
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final Object delegate;
    private final Method method;

    public BroadcastMethodInvoker(Object delegate, Method method) {
        this.delegate = delegate;
        this.method = method;
    }

    public void onMessage(Message message, byte[] pattern) {
        byte[] body = message.getBody();
        String payload = (String)serializer.deserialize(body);
        try {
            this.method.invoke(this.delegate, payload);
        }
        catch (Throwable th) {
            this.logger.error(th, (CharSequence)("Failed to invoke method '" + this.method.getName() + "' on delegate '" + this.delegate.getClass().getName() + "'"));
        }
    }
}

