/*
 * Decompiled with CFR 0.152.
 */
package io.github.jihongkim98.redisextensions;

import io.github.jihongkim98.redisextensions.TopicRegistrar;
import io.github.jihongkim98.redisextensions.annotation.RedisBroadcastListener;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.Topic;
import org.springframework.util.Assert;

public class RedisBroadcastAnnotationBeanPostProcessor
implements BeanPostProcessor,
SmartInitializingSingleton,
ApplicationContextAware {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final Set<Class<?>> nonAnnotatedClasses = Collections.synchronizedSet(new HashSet());
    private final TopicRegistrar topicRegistrar = new TopicRegistrar();
    private ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (this.nonAnnotatedClasses.contains(targetClass)) {
            return bean;
        }
        this.detectAnnotations(bean, targetClass);
        return bean;
    }

    private void detectAnnotations(Object bean, Class<?> targetClass) {
        Map annotationMethods = MethodIntrospector.selectMethods(targetClass, method -> (RedisBroadcastListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RedisBroadcastListener.class));
        if (annotationMethods.isEmpty()) {
            this.nonAnnotatedClasses.add(targetClass);
        }
        annotationMethods.forEach((key, value) -> this.processAnnotation(bean, (Method)key, (RedisBroadcastListener)value));
    }

    private void processAnnotation(Object bean, Method method, RedisBroadcastListener annotation) {
        String[] channels = annotation.channels();
        String[] patterns = annotation.patterns();
        boolean hasChannels = this.hasValidValues(channels);
        boolean hasPatterns = this.hasValidValues(patterns);
        Assert.state((hasChannels || hasPatterns ? 1 : 0) != 0, (String)"Either 'channels' or 'patterns' must be defined and must not contain empty values.");
        if (hasChannels) {
            for (String channel : channels) {
                ChannelTopic channelTopic = new ChannelTopic(channel);
                this.topicRegistrar.registry(bean, method, (Topic)channelTopic);
            }
        }
        if (hasPatterns) {
            for (String pattern : patterns) {
                PatternTopic patternTopic = new PatternTopic(pattern);
                this.topicRegistrar.registry(bean, method, (Topic)patternTopic);
            }
        }
    }

    private boolean hasValidValues(String[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (String value : array) {
            if (value != null && !value.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void afterSingletonsInstantiated() {
        this.topicRegistrar.setApplicationContext(this.applicationContext);
        this.topicRegistrar.afterSingletonsInstantiated();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

