/*
 * Decompiled with CFR 0.152.
 */
package io.github.jihongkim98.redisextensions;

import io.github.jihongkim98.redisextensions.BroadcastMethodInvoker;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

public class TopicRegistrar
implements SmartInitializingSingleton {
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final Map<BroadcastMethodInvoker, List<Topic>> invokers = new ConcurrentHashMap<BroadcastMethodInvoker, List<Topic>>();
    private ApplicationContext applicationContext;
    private RedisMessageListenerContainer container;

    public void registry(Object delegate, Method method, Topic topic) {
        BroadcastMethodInvoker invoker = new BroadcastMethodInvoker(delegate, method);
        this.invokers.computeIfAbsent(invoker, v -> new ArrayList()).add(topic);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        try {
            this.container = (RedisMessageListenerContainer)this.applicationContext.getBean(RedisMessageListenerContainer.class);
        }
        catch (BeansException e) {
            this.logger.error((CharSequence)"RedisMessageListenerContainer bean is missing in the application context. Please register it as a @Bean in your configuration class to enable Redis Pub/Sub functionality.");
            throw e;
        }
        this.containerRegistry();
        this.container.start();
    }

    private void containerRegistry() {
        this.invokers.forEach((invoker, topics) -> this.container.addMessageListener((MessageListener)invoker, (Collection)topics));
    }
}

