/*
 * Decompiled with CFR 0.152.
 */
package io.github.jimmydbe.imdb.domain;

import java.util.List;

public class MovieDetails {
    private final String movieName;
    private final String movieOriginalName;
    private final Integer year;
    private final String description;
    private final Double rating;
    private final List<String> directors;
    private final List<String> writers;
    private final List<String> stars;
    private final List<String> categories;
    private final String image;
    private final Integer duration;

    private MovieDetails(Builder builder) {
        this.movieName = builder.movieName;
        this.movieOriginalName = builder.movieOriginalName;
        this.year = builder.year;
        this.description = builder.description;
        this.rating = builder.rating;
        this.directors = builder.directors;
        this.writers = builder.writers;
        this.stars = builder.stars;
        this.categories = builder.categories;
        this.image = builder.image;
        this.duration = builder.duration;
    }

    public String getMovieName() {
        return this.movieName;
    }

    public String getMovieOriginalName() {
        return this.movieOriginalName;
    }

    public Integer getYear() {
        return this.year;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getRating() {
        return this.rating;
    }

    public List<String> getDirectors() {
        return this.directors;
    }

    public List<String> getWriters() {
        return this.writers;
    }

    public List<String> getStars() {
        return this.stars;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public String getImage() {
        return this.image;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public static final class Builder {
        private String movieName;
        private String movieOriginalName;
        private Integer year;
        private String description;
        private Double rating;
        private List<String> directors;
        private List<String> writers;
        private List<String> stars;
        private List<String> categories;
        private String image;
        private Integer duration;

        public Builder withMovieName(String val) {
            this.movieName = val;
            return this;
        }

        public Builder withMovieOriginalName(String val) {
            this.movieOriginalName = val;
            return this;
        }

        public Builder withYear(Integer val) {
            this.year = val;
            return this;
        }

        public Builder withDescription(String val) {
            this.description = val;
            return this;
        }

        public Builder withRating(Double val) {
            this.rating = val;
            return this;
        }

        public Builder withDirectors(List<String> val) {
            this.directors = val;
            return this;
        }

        public Builder withWriters(List<String> val) {
            this.writers = val;
            return this;
        }

        public Builder withStars(List<String> val) {
            this.stars = val;
            return this;
        }

        public Builder withCategories(List<String> val) {
            this.categories = val;
            return this;
        }

        public Builder withImage(String val) {
            this.image = val;
            return this;
        }

        public Builder withDuration(Integer val) {
            this.duration = val;
            return this;
        }

        public MovieDetails build() {
            return new MovieDetails(this);
        }
    }
}

