/*
 * Decompiled with CFR 0.152.
 */
package io.github.jimmydbe.imdb.domain;

import java.util.Objects;

public class SearchResult {
    private final String id;
    private final String name;
    private final int year;
    private final String type;
    private final String thumbnail;

    public SearchResult(String id, String name, int year, String type, String thumbnail) {
        this.id = id;
        this.name = name;
        this.year = year;
        this.type = type;
        this.thumbnail = thumbnail;
    }

    private SearchResult(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.year = builder.year;
        this.type = builder.type;
        this.thumbnail = builder.thumbnail;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getYear() {
        return this.year;
    }

    public String getType() {
        return this.type;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return this.year == that.year && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.thumbnail, that.thumbnail);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.year, this.type, this.thumbnail);
    }

    public static final class Builder {
        private String id;
        private String name;
        private int year;
        private String type;
        private String thumbnail;

        public Builder withId(String val) {
            this.id = val;
            return this;
        }

        public Builder withName(String val) {
            this.name = val;
            return this;
        }

        public Builder withYear(int val) {
            this.year = val;
            return this;
        }

        public Builder withType(String val) {
            this.type = val;
            return this;
        }

        public Builder withThumbnail(String val) {
            this.thumbnail = val;
            return this;
        }

        public SearchResult build() {
            return new SearchResult(this);
        }
    }
}

