/*
 * Decompiled with CFR 0.152.
 */
package io.github.jimmydbe.imdb.domain;

import java.time.LocalDate;
import java.util.List;

public class TvEpisodeDetails {
    private final String showName;
    private final String episodeName;
    private final long seasonNumber;
    private final long episodeNumber;
    private final List<String> genres;
    private final LocalDate airDate;

    private TvEpisodeDetails(Builder builder) {
        this.showName = builder.showName;
        this.episodeName = builder.episodeName;
        this.seasonNumber = builder.seasonNumber;
        this.episodeNumber = builder.episodeNumber;
        this.genres = builder.genres;
        this.airDate = builder.airDate;
    }

    public String getShowName() {
        return this.showName;
    }

    public String getEpisodeName() {
        return this.episodeName;
    }

    public long getSeasonNumber() {
        return this.seasonNumber;
    }

    public long getEpisodeNumber() {
        return this.episodeNumber;
    }

    public List<String> getGenres() {
        return this.genres;
    }

    public LocalDate getAirDate() {
        return this.airDate;
    }

    public static final class Builder {
        private String showName;
        private String episodeName;
        private long seasonNumber;
        private long episodeNumber;
        private List<String> genres;
        private LocalDate airDate;

        public Builder withShowName(String val) {
            this.showName = val;
            return this;
        }

        public Builder withEpisodeName(String val) {
            this.episodeName = val;
            return this;
        }

        public Builder withSeasonNumber(long val) {
            this.seasonNumber = val;
            return this;
        }

        public Builder withEpisodeNumber(long val) {
            this.episodeNumber = val;
            return this;
        }

        public Builder withGenres(List<String> val) {
            this.genres = val;
            return this;
        }

        public Builder withAirDate(LocalDate val) {
            this.airDate = val;
            return this;
        }

        public TvEpisodeDetails build() {
            return new TvEpisodeDetails(this);
        }
    }
}

