/*
 * Decompiled with CFR 0.152.
 */
package io.github.jimmydbe.imdb.parsers;

import io.github.jimmydbe.imdb.domain.MovieDetails;
import io.github.jimmydbe.imdb.parsers.Parser;
import io.github.jimmydbe.imdb.util.ElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MovieDetailsPageParser
implements Parser<MovieDetails> {
    private static final String IMAGE = "MovieDetailsPageParser.image";
    private static final String CATEGORIES = "MovieDetailsPageParser.categories";
    private static final String DESCRIPTION = "MovieDetailsPageParser.description";
    private static final String RATING = "MovieDetailsPageParser.rating";
    private static final String WRITERS = "MovieDetailsPageParser.writers";
    private static final String DIRECTORS = "MovieDetailsPageParser.directors";
    private static final String YEAR = "MovieDetailsPageParser.year";
    private static final String NAME_TITLE_HEADER = "MovieDetailsPageParser.nameTitleHeader";
    private static final String NAME_TITLE_EXTRA = "MovieDetailsPageParser.nameTitleExtra";
    private static final String NAME_TITLE_NORMAL = "MovieDetailsPageParser.nameTitleNormal";
    private static final String NAME_TITLE_ORIGINAL = "MovieDetailsPageParser.nameTitleOriginal";
    private static final String STARS = "MovieDetailsPageParser.stars";
    private static final String DURATION = "MovieDetailsPageParser.duration";
    private final ElementUtil elementUtil;
    private final Properties properties;

    public MovieDetailsPageParser(ElementUtil elementUtil, Properties properties) {
        this.elementUtil = elementUtil;
        this.properties = properties;
    }

    @Override
    public MovieDetails parse(Element document, Optional<Element> detailsDocument) {
        String movieName = this.parseMovieName(document);
        String movieOriginalName = this.parseMovieOriginalName(document);
        Integer year = this.parseMovieYear(document);
        String description = this.parseDescription(document);
        Double rating = this.parseRating(document);
        List directors = detailsDocument.map(this::parseDirectors).orElse(new ArrayList());
        List writers = detailsDocument.map(this::parseWriters).orElse(new ArrayList());
        List stars = detailsDocument.map(this::parseStars).orElse(new ArrayList());
        List<String> categories = this.parseCategories(document);
        String image = this.parseImage(document);
        Integer duration = this.parseDuration(document);
        return new MovieDetails.Builder().withMovieName(movieName).withMovieOriginalName(movieOriginalName).withYear(year).withDescription(description).withRating(rating).withDirectors(directors).withWriters(writers).withStars(stars).withCategories(categories).withImage(image).withDuration(duration).build();
    }

    private String parseMovieOriginalName(Element document) {
        return document.select(this.properties.get(NAME_TITLE_ORIGINAL).toString()).text().replace("Original title: ", "");
    }

    private Integer parseDuration(Element document) {
        String minutes;
        String hours;
        String durationString = document.select(this.properties.get(DURATION).toString()).text();
        durationString = durationString.replace("Runtime ", "");
        int duration = 0;
        if (durationString.contains("hours") || durationString.contains("hour")) {
            hours = durationString.substring(0, durationString.indexOf("h")).trim();
            duration += Integer.parseInt(hours) * 60;
            durationString = durationString.substring(durationString.indexOf("h") + 5).trim();
        } else if (durationString.contains("h")) {
            hours = durationString.substring(0, durationString.indexOf("h")).trim();
            duration += Integer.parseInt(hours) * 60;
            durationString = durationString.substring(durationString.indexOf("h")).trim();
        }
        if (durationString.contains("minutes")) {
            minutes = durationString.replace("minutes", "").trim();
            duration += Integer.parseInt(minutes);
        } else if (durationString.contains("minute")) {
            minutes = durationString.replace("minute", "").trim();
            duration += Integer.parseInt(minutes);
        } else if (durationString.contains("min")) {
            int startPosition = durationString.indexOf(" ") != -1 ? durationString.indexOf(" ") : 0;
            duration += Integer.parseInt(durationString.substring(startPosition, durationString.length() - 3).trim());
        }
        return duration;
    }

    private String parseImage(Element document) {
        return document.select(this.properties.get(IMAGE).toString()).select("img").attr("src");
    }

    private List<String> parseCategories(Element document) {
        ArrayList answer = new ArrayList();
        Collections.addAll(answer, document.select(this.properties.get(CATEGORIES).toString()).text().split("(?=\\p{Upper})"));
        return answer.stream().map(String::trim).collect(Collectors.toList());
    }

    private String parseDescription(Element document) {
        return document.select(this.properties.get(DESCRIPTION).toString()).text();
    }

    private Double parseRating(Element document) {
        Elements elements = document.select(".AggregateRatingButton__ContentWrap-sc-1ll29m0-0");
        String value = ((Element)elements.get(0)).text().trim();
        if (value.length() > 0) {
            return Double.parseDouble(value.substring(0, value.indexOf("/")));
        }
        return null;
    }

    private List<String> parseWriters(Element document) {
        ArrayList<String> writers = new ArrayList<String>();
        document.select(this.properties.get(WRITERS).toString()).next().select("tbody").forEach(element -> element.children().select("td.name").forEach(element1 -> writers.add(element1.text())));
        return writers;
    }

    private List<String> parseDirectors(Element document) {
        ArrayList<String> directors = new ArrayList<String>();
        document.select(this.properties.get(DIRECTORS).toString()).next().select("tbody").forEach(element -> element.children().select("td.name").forEach(element1 -> directors.add(element1.text())));
        return directors;
    }

    private List<String> parseStars(Element document) {
        ArrayList stars = new ArrayList();
        document.select(this.properties.get(STARS).toString()).next().select("tbody").forEach(element -> element.children().select("td").not("td.character").not("td.ellipsis").forEach(element1 -> stars.add(element1.text())));
        return stars.stream().map(String::trim).filter(n -> !n.isEmpty()).collect(Collectors.toList());
    }

    private String parseMovieName(Element document) {
        Elements header = document.select(this.properties.get(NAME_TITLE_HEADER).toString());
        if (header.select(this.properties.get(NAME_TITLE_EXTRA).toString()).size() > 0) {
            String text = ((Element)header.select(this.properties.get(NAME_TITLE_EXTRA).toString()).get(0)).ownText();
            if (text.startsWith("\"")) {
                text = text.substring(1, text.length() - 1);
            }
            return text;
        }
        String title = document.select(this.properties.get(NAME_TITLE_NORMAL).toString()).text();
        return title.contains("(") ? title.substring(0, title.indexOf("(")).trim() : title.trim();
    }

    private Integer parseMovieYear(Element document) {
        String yearString = document.select(this.properties.get(YEAR).toString()).text().trim();
        return Integer.parseInt(yearString);
    }
}

