/*
 * Decompiled with CFR 0.152.
 */
package io.github.jimmydbe.imdb.parsers;

import io.github.jimmydbe.imdb.domain.SearchResult;
import io.github.jimmydbe.imdb.exceptions.ParseException;
import io.github.jimmydbe.imdb.parsers.Parser;
import java.util.Optional;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MovieFindResultParser
implements Parser<SearchResult> {
    @Override
    public SearchResult parse(Element document, Optional<Element> detailsDocument) throws ParseException {
        SearchResult.Builder builder = new SearchResult.Builder();
        String thumbnail = this.getPhotoResult(document);
        Element textResult = this.getTextResult(document);
        builder.withId(this.getMovieId(textResult)).withName(this.getMovieName(textResult)).withYear(0).withType("Movie").withThumbnail(thumbnail);
        String metaInfo = this.getMetaInfo(textResult);
        this.setupMetaInfo(builder, metaInfo);
        return builder.build();
    }

    private String getPhotoResult(Element document) throws ParseException {
        Elements photoElement = document.select(".primary_photo");
        if (photoElement.size() != 1) {
            throw new ParseException("Unexpected number of primary_photo elements");
        }
        String image = ((Element)((Element)((Element)photoElement.get(0)).getElementsByTag("a").get(0)).getElementsByTag("img").get(0)).attr("src");
        return image;
    }

    private String getMovieId(Element textResult) {
        String href = ((Element)textResult.getElementsByTag("a").get(0)).attr("href");
        if ((href = href.substring(0, href.indexOf("?"))).endsWith("/")) {
            href = href.substring(0, href.length() - 1);
        }
        href = href.substring(href.lastIndexOf("/") + 1);
        return href;
    }

    private void setupMetaInfo(SearchResult.Builder builder, String metaInfo) {
        if (metaInfo.length() == 0) {
            return;
        }
        String[] components = metaInfo.substring(1, metaInfo.length() - 1).split("\\) \\(");
        if (components.length > 0) {
            int compIndex = 0;
            if (this.isVersionNumber(components[compIndex])) {
                ++compIndex;
            }
            if (components.length > compIndex) {
                try {
                    int year = Integer.parseInt(components[compIndex]);
                    builder.withYear(year);
                    if (components.length > compIndex + 1) {
                        builder.withType(components[compIndex + 1]);
                    }
                }
                catch (NumberFormatException e) {
                    builder.withType(components[compIndex]);
                }
            }
        }
    }

    private boolean isVersionNumber(String component) {
        for (int i = 0; i < component.length(); ++i) {
            if (component.charAt(i) == 'I') continue;
            return false;
        }
        return true;
    }

    private String getMovieName(Element textResult) {
        return ((Element)textResult.select("a").get(0)).text();
    }

    private Element getTextResult(Element document) throws ParseException {
        Elements textResults = document.select(".result_text");
        if (textResults.size() != 1) {
            throw new ParseException("Unexpected number of result_text elements");
        }
        return (Element)textResults.get(0);
    }

    private String getMetaInfo(Element textResult) {
        return textResult.ownText().substring(0, textResult.ownText().lastIndexOf(41) + 1);
    }
}

