/*
 * Decompiled with CFR 0.152.
 */
package io.github.jimmydbe.imdb.parsers;

import io.github.jimmydbe.imdb.domain.SearchResult;
import io.github.jimmydbe.imdb.exceptions.ParseException;
import io.github.jimmydbe.imdb.parsers.MovieFindResultParser;
import io.github.jimmydbe.imdb.parsers.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SearchedMoviesParser
implements Parser<List<SearchResult>> {
    private final MovieFindResultParser movieFindResultParser;

    public SearchedMoviesParser(MovieFindResultParser movieFindResultParser) {
        this.movieFindResultParser = movieFindResultParser;
    }

    @Override
    public List<SearchResult> parse(Element document, Optional<Element> detailsDocument) throws ParseException {
        ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>();
        Element element = this.getSearchResultsFromDocument(document);
        if (element == null) {
            return searchResultList;
        }
        Elements results = this.getSearchResults(element);
        try {
            for (Element result : results) {
                Object searchResult = this.movieFindResultParser.parse(result, Optional.empty());
                searchResultList.add((SearchResult)searchResult);
            }
        }
        catch (ParseException e) {
            throw new ParseException("Could not parse search results", e);
        }
        return searchResultList;
    }

    private Elements getSearchResults(Element element) {
        return element.select(".findList .findResult");
    }

    private Element getSearchResultsFromDocument(Element document) {
        Elements findSections = document.select("#main .article .findSection");
        if (findSections.size() != 1) {
            return null;
        }
        return (Element)findSections.get(0);
    }
}

