/*
 * Decompiled with CFR 0.152.
 */
package io.github.jimmydbe.imdb.parsers;

import io.github.jimmydbe.imdb.domain.TvShowDetails;
import io.github.jimmydbe.imdb.parsers.Parser;
import io.github.jimmydbe.imdb.util.ElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.nodes.Element;

public class TvShowDetailsPageParser
implements Parser<TvShowDetails> {
    private static final String CREATORS = "TvShowDetailsPageParser.creators";
    private static final String NAME = "TvShowDetailsPageParser.name";
    private static final String PLOT = "TvShowDetailsPageParser.plot";
    private static final String DURATION = "TvShowDetailsPageParser.duration";
    private static final String GENRES = "TvShowDetailsPageParser.genres";
    private static final String YEAR = "TvShowDetailsPageParser.year";
    private static final String RATING = "TvShowDetailsPageParser.rating";
    private static final char separatorChar = '\u2013';
    private static final Pattern YEAR_PATTERN = Pattern.compile("\\d{4}");
    private final Properties properties;
    private final ElementUtil elementUtil;

    public TvShowDetailsPageParser(Properties properties, ElementUtil elementUtil) {
        this.properties = properties;
        this.elementUtil = elementUtil;
    }

    @Override
    public TvShowDetails parse(Element document, Optional<Element> detailsDocument) {
        String plot = this.getPlot(document);
        String name = this.getName(document);
        Double rating = this.getRating(document);
        Integer startYear = this.getStartYear(document);
        Integer endYear = this.getEndYear(document);
        Set<String> genres = this.getGenres(document);
        Set<String> creators = this.getCreators(detailsDocument.get());
        return new TvShowDetails.Builder().withName(name).withRating(rating).withStartYear(startYear).withEndYear(endYear).withGenres(genres).withPlot(plot).withCreators(creators).build();
    }

    private Set<String> getCreators(Element document) {
        HashSet<String> writers = new HashSet<String>();
        document.select(this.properties.get(CREATORS).toString()).next().select("tbody").forEach(element -> element.children().select("td.name").forEach(element1 -> writers.add(element1.text())));
        return writers;
    }

    private Set<String> getGenres(Element document) {
        ArrayList answer = new ArrayList();
        Collections.addAll(answer, document.select(this.properties.get(GENRES).toString()).text().split("(?=\\p{Upper})"));
        return answer.stream().map(n -> n.trim()).collect(Collectors.toSet());
    }

    private Integer getEndYear(Element document) {
        String yearString = document.select(this.properties.get(YEAR).toString()).text();
        Matcher matcher = YEAR_PATTERN.matcher(yearString);
        matcher.find();
        matcher.find();
        String endYear = matcher.group();
        if (endYear.equals(" ")) {
            return -1;
        }
        return Integer.parseInt(endYear);
    }

    private Integer getStartYear(Element document) {
        String yearString = document.select(this.properties.get(YEAR).toString()).text();
        Matcher matcher = YEAR_PATTERN.matcher(yearString);
        matcher.find();
        return Integer.parseInt(matcher.group());
    }

    private Double getRating(Element document) {
        return Double.parseDouble(document.select(this.properties.get(RATING).toString()).text());
    }

    private String getName(Element document) {
        return document.select(this.properties.get(NAME).toString()).text();
    }

    private String getPlot(Element document) {
        return document.select(this.properties.get(PLOT).toString()).text();
    }
}

