/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.generate;

import io.github.jklingsporn.vertx.jooq.generate.VertxGeneratorStrategy;
import io.github.jklingsporn.vertx.jooq.generate.VertxJavaWriter;
import io.github.jklingsporn.vertx.jooq.shared.JsonArrayConverter;
import io.github.jklingsporn.vertx.jooq.shared.JsonObjectConverter;
import io.github.jklingsporn.vertx.jooq.shared.ObjectToJsonObjectBinding;
import io.github.jklingsporn.vertx.jooq.shared.internal.AbstractVertxDAO;
import io.github.jklingsporn.vertx.jooq.shared.postgres.PgConverter;
import io.vertx.core.Vertx;
import io.vertx.core.impl.Arguments;
import java.io.File;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jooq.Record;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.JavaGenerator;
import org.jooq.codegen.JavaWriter;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.JooqLogger;

public abstract class VertxGenerator
extends JavaGenerator {
    private static final JooqLogger logger = JooqLogger.getLogger(VertxGenerator.class);
    private final boolean generateJson;
    protected VertxGeneratorStrategy vertxGeneratorStrategy;

    public VertxGenerator() {
        this(true);
    }

    public VertxGenerator(boolean generateJson) {
        this.generateJson = generateJson;
        this.setGeneratePojos(true);
    }

    protected boolean handleCustomTypeFromJson(TypedElementDefinition<?> column, String setter, String columnType, String javaMemberName, JavaWriter out) {
        return false;
    }

    protected boolean handleCustomTypeToJson(TypedElementDefinition<?> column, String getter, String columnType, String javaMemberName, JavaWriter out) {
        return false;
    }

    protected abstract String renderFindOneType(String var1);

    protected abstract String renderFindManyType(String var1);

    protected abstract String renderExecType();

    protected abstract String renderInsertReturningType(String var1);

    protected abstract String renderQueryExecutor(String var1, String var2, String var3);

    protected abstract String renderDAOInterface(String var1, String var2, String var3);

    protected abstract void writeDAOConstructor(JavaWriter var1, String var2, String var3, String var4, String var5, String var6, String var7);

    protected void writeDAOImports(JavaWriter out) {
    }

    protected void writeDAOClassAnnotation(JavaWriter out) {
    }

    protected void writeDAOConstructorAnnotation(JavaWriter out) {
    }

    protected void overwriteDAOMethods(JavaWriter out, String className, String tableIdentifier, String rType, String pType, String tType) {
    }

    protected String renderDaoExtendsClassName() {
        return AbstractVertxDAO.class.getName();
    }

    protected String renderFQVertxName() {
        return Vertx.class.getName();
    }

    protected Collection<JavaWriter> writeExtraData(SchemaDefinition definition, Function<File, JavaWriter> writerGenerator) {
        return Collections.emptyList();
    }

    protected void generatePojoClassFooter(TableDefinition table, JavaWriter out) {
        super.generatePojoClassFooter(table, out);
        if (this.generateJson) {
            this.generateFromJsonConstructor(table, out, GeneratorStrategy.Mode.POJO);
            if (!this.generateInterfaces()) {
                this.generateFromJson(table, out, GeneratorStrategy.Mode.POJO);
                this.generateToJson(table, out, GeneratorStrategy.Mode.POJO);
            }
        }
    }

    protected void generateInterfaceClassFooter(TableDefinition table, JavaWriter out) {
        super.generateInterfaceClassFooter(table, out);
        if (this.generateJson && this.generateInterfaces()) {
            this.generateFromJson(table, out, GeneratorStrategy.Mode.INTERFACE);
            this.generateToJson(table, out, GeneratorStrategy.Mode.INTERFACE);
        }
    }

    protected void generateRecordClassFooter(TableDefinition table, JavaWriter out) {
        super.generateRecordClassFooter(table, out);
        if (this.generateJson) {
            this.generateFromJsonConstructor(table, out, GeneratorStrategy.Mode.RECORD);
            if (!this.generateInterfaces()) {
                this.generateFromJson(table, out, GeneratorStrategy.Mode.RECORD);
                this.generateToJson(table, out, GeneratorStrategy.Mode.RECORD);
            }
        }
    }

    protected JavaWriter newJavaWriter(File file) {
        return new VertxJavaWriter(file, this.generateFullyQualifiedTypes(), this.targetEncoding);
    }

    protected void printPackage(JavaWriter out, Definition definition, GeneratorStrategy.Mode mode) {
        super.printPackage(out, definition, mode);
        if (mode.equals((Object)GeneratorStrategy.Mode.DAO)) {
            out.println("import %s;", new Object[]{List.class.getName()});
            this.writeDAOImports(out);
        }
    }

    protected void generateDaos(SchemaDefinition schema) {
        super.generateDaos(schema);
        this.writeExtraData(schema);
    }

    private void writeExtraData(SchemaDefinition definition) {
        Collection<JavaWriter> writers = this.writeExtraData(definition, this::newJavaWriter);
        writers.forEach(arg_0 -> ((VertxGenerator)this).closeJavaWriter(arg_0));
    }

    private void generateFromJson(TableDefinition table, JavaWriter out, GeneratorStrategy.Mode mode) {
        out.println();
        ((JavaWriter)out.tab(1)).override();
        String className = this.getStrategy().getJavaClassName((Definition)table, mode);
        ((JavaWriter)out.tab(1)).println("public %s%s fromJson(io.vertx.core.json.JsonObject json) {", new Object[]{mode == GeneratorStrategy.Mode.INTERFACE ? "default " : "", className});
        for (TypedElementDefinition column : table.getColumns()) {
            String setter = this.getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
            String columnType = this.getJavaType(column.getType());
            String javaMemberName = this.getJsonKeyName(column);
            ((JavaWriter)out.tab(2)).println("try {");
            if (!this.handleCustomTypeFromJson(column, setter, columnType, javaMemberName, out)) {
                if (this.isType(columnType, Integer.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getInteger(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (this.isType(columnType, Short.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getInteger(\"%s\")==null?null:json.getInteger(\"%s\").shortValue());", new Object[]{setter, javaMemberName, javaMemberName});
                } else if (this.isType(columnType, Byte.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getInteger(\"%s\")==null?null:json.getInteger(\"%s\").byteValue());", new Object[]{setter, javaMemberName, javaMemberName});
                } else if (this.isType(columnType, Long.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getLong(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (this.isType(columnType, Float.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getFloat(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (this.isType(columnType, Double.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getDouble(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (this.isType(columnType, Boolean.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getBoolean(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (this.isType(columnType, String.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getString(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (columnType.equals(Byte.TYPE.getName() + "[]")) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getBinary(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (this.isType(columnType, Instant.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getInstant(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (this.isEnum(table, column)) {
                    if (column.getType().getConverter() == null) {
                        ((JavaWriter)out.tab(3)).println("%s(java.util.Arrays.stream(%s.values()).filter(td -> td.getLiteral().equals(json.getString(\"%s\"))).findFirst().orElse(null));", new Object[]{setter, columnType, javaMemberName});
                    } else {
                        ((JavaWriter)out.tab(3)).println("String %sString = json.getString(\"%s\");", new Object[]{javaMemberName, javaMemberName});
                        ((JavaWriter)out.tab(3)).println("%s(%sString == null ? null : %s.valueOf(%sString));", new Object[]{setter, javaMemberName, columnType, javaMemberName});
                    }
                } else if (column.getType().getConverter() != null && this.isType(column.getType().getConverter(), JsonObjectConverter.class) || column.getType().getBinding() != null && this.isType(column.getType().getBinding(), ObjectToJsonObjectBinding.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getJsonObject(\"%s\"));", new Object[]{setter, javaMemberName});
                } else if (column.getType().getConverter() != null && this.isType(column.getType().getConverter(), JsonArrayConverter.class)) {
                    ((JavaWriter)out.tab(3)).println("%s(json.getJsonArray(\"%s\"));", new Object[]{setter, javaMemberName});
                } else {
                    logger.warn((Object)String.format("Omitting unrecognized type %s for column %s in table %s!", columnType, column.getName(), table.getName()));
                    ((JavaWriter)out.tab(3)).println(String.format("// Omitting unrecognized type %s for column %s!", columnType, column.getName()));
                }
            }
            out.ref("io.github.jklingsporn.vertx.jooq.shared.UnexpectedJsonValueType");
            ((JavaWriter)out.tab(2)).println("} catch (java.lang.ClassCastException e) {");
            ((JavaWriter)out.tab(3)).println("throw new UnexpectedJsonValueType(\"%s\",\"%s\",e);", new Object[]{javaMemberName, columnType});
            ((JavaWriter)out.tab(2)).println("}");
        }
        ((JavaWriter)out.tab(2)).println("return this;");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
    }

    public boolean isEnum(TableDefinition table, TypedElementDefinition<?> column) {
        return table.getDatabase().getEnum(table.getSchema(), column.getType().getUserType()) != null || column.getType().getConverter() != null && column.getType().getConverter().endsWith("EnumConverter");
    }

    protected boolean isType(String columnType, Class<?> clazz) {
        return columnType.equals(clazz.getName());
    }

    protected Class<?> getPgConverterFromType(String columnType, String converter) {
        try {
            Class<?> converterClazz = Class.forName(converter);
            if (PgConverter.class.isAssignableFrom(converterClazz)) {
                PgConverter converterInstance = (PgConverter)converterClazz.newInstance();
                return converterInstance.pgConverter().fromType();
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.info((Object)String.format("'%s' to map '%s' could not be accessed from code generator.", converter, columnType));
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.info((Object)String.format("'%s' to map '%s' could not be instantiated from code generator.", converter, columnType));
            return null;
        }
    }

    public String getJavaType(DataTypeDefinition type) {
        return super.getJavaType(type);
    }

    private void generateToJson(TableDefinition table, JavaWriter out, GeneratorStrategy.Mode mode) {
        out.println();
        ((JavaWriter)out.tab(1)).override();
        ((JavaWriter)out.tab(1)).println("public %sio.vertx.core.json.JsonObject toJson() {", new Object[]{mode == GeneratorStrategy.Mode.INTERFACE ? "default " : ""});
        ((JavaWriter)out.tab(2)).println("io.vertx.core.json.JsonObject json = new io.vertx.core.json.JsonObject();");
        for (TypedElementDefinition column : table.getColumns()) {
            String columnType;
            String getter;
            if (this.handleCustomTypeToJson(column, getter = this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE), columnType = this.getJavaType(column.getType()), this.getJsonKeyName(column), out)) continue;
            if (this.isEnum(table, column)) {
                if (column.getType().getConverter() == null) {
                    ((JavaWriter)out.tab(2)).println("json.put(\"%s\",%s()==null?null:%s().getLiteral());", new Object[]{this.getJsonKeyName(column), getter, getter});
                    continue;
                }
                ((JavaWriter)out.tab(2)).println("json.put(\"%s\",%s()==null?null:%s().name());", new Object[]{this.getJsonKeyName(column), getter, getter});
                continue;
            }
            if (this.isAllowedJsonType(column, columnType)) {
                ((JavaWriter)out.tab(2)).println("json.put(\"%s\",%s());", new Object[]{this.getJsonKeyName(column), getter});
                continue;
            }
            logger.warn((Object)String.format("Omitting unrecognized type %s for column %s in table %s!", columnType, column.getName(), table.getName()));
            ((JavaWriter)out.tab(2)).println(String.format("// Omitting unrecognized type %s for column %s!", columnType, column.getName()));
        }
        ((JavaWriter)out.tab(2)).println("return json;");
        ((JavaWriter)out.tab(1)).println("}");
        out.println();
    }

    protected String getJsonKeyName(TypedElementDefinition<?> column) {
        return this.vertxGeneratorStrategy.getJsonKeyName(column);
    }

    private boolean isAllowedJsonType(TypedElementDefinition<?> column, String columnType) {
        return this.isType(columnType, Integer.class) || this.isType(columnType, Short.class) || this.isType(columnType, Byte.class) || this.isType(columnType, Long.class) || this.isType(columnType, Float.class) || this.isType(columnType, Double.class) || this.isType(columnType, Boolean.class) || this.isType(columnType, String.class) || this.isType(columnType, Instant.class) || columnType.equals(Byte.TYPE.getName() + "[]") || column.getType().getConverter() != null && (this.isType(column.getType().getConverter(), JsonObjectConverter.class) || this.isType(column.getType().getConverter(), JsonArrayConverter.class)) || column.getType().getBinding() != null && this.isType(column.getType().getBinding(), ObjectToJsonObjectBinding.class);
    }

    public void setStrategy(GeneratorStrategy strategy) {
        Arguments.require((boolean)(strategy instanceof VertxGeneratorStrategy), (String)"Requires instance of VertxGeneratorStrategy");
        super.setStrategy(strategy);
        this.vertxGeneratorStrategy = (VertxGeneratorStrategy)strategy;
    }

    public VertxGeneratorStrategy getVertxGeneratorStrategy() {
        return this.vertxGeneratorStrategy;
    }

    private void generateFromJsonConstructor(TableDefinition table, JavaWriter out, GeneratorStrategy.Mode mode) {
        String className = this.getStrategy().getJavaClassName((Definition)table, mode);
        out.println();
        ((JavaWriter)out.tab(1)).println("public %s(io.vertx.core.json.JsonObject json) {", new Object[]{className});
        ((JavaWriter)out.tab(2)).println("this();");
        ((JavaWriter)out.tab(2)).println("fromJson(json);");
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void generateFetchMethods(TableDefinition table, JavaWriter out) {
        VertxJavaWriter vOut = (VertxJavaWriter)out;
        String pType = vOut.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        UniqueKeyDefinition primaryKey = table.getPrimaryKey();
        ColumnDefinition firstPrimaryKeyColumn = (ColumnDefinition)primaryKey.getKeyColumns().get(0);
        List indexes = table.getIndexes();
        for (ColumnDefinition column : table.getColumns()) {
            String colName = column.getOutputName();
            String colClass = this.getStrategy().getJavaClassName((Definition)column);
            String colType = vOut.ref(this.getJavaType(column.getType()));
            String colIdentifier = vOut.ref(this.getStrategy().getFullJavaIdentifier((Definition)column), this.colRefSegments((TypedElementDefinition<?>)column));
            if (firstPrimaryKeyColumn.equals(column)) continue;
            this.generateFindManyByMethods(out, pType, colName, colClass, colType, colIdentifier);
        }
        for (IndexDefinition index : indexes) {
            ColumnDefinition column;
            if (!index.isUnique() || index.getIndexColumns().size() != 1 || (column = ((IndexColumnDefinition)index.getIndexColumns().get(0)).getColumn()).equals(firstPrimaryKeyColumn)) continue;
            String colName = column.getOutputName();
            String colClass = this.getStrategy().getJavaClassName((Definition)column);
            String colType = vOut.ref(this.getJavaType(column.getType()));
            String colIdentifier = vOut.ref(this.getStrategy().getFullJavaIdentifier((Definition)column), this.colRefSegments((TypedElementDefinition<?>)column));
            this.generateFindOneByMethods(out, pType, colName, colClass, colType, colIdentifier);
        }
    }

    protected void generateFindOneByMethods(JavaWriter out, String pType, String colName, String colClass, String colType, String colIdentifier) {
        ((JavaWriter)out.tab(1)).javadoc("Find a unique record that has <code>%s = value</code> asynchronously", new Object[]{colName});
        ((JavaWriter)out.tab(1)).println("public %s findOneBy%s(%s value) {", new Object[]{this.renderFindOneType(pType), colClass, colType});
        ((JavaWriter)out.tab(2)).println("return findOneByCondition(%s.eq(value));", new Object[]{colIdentifier});
        ((JavaWriter)out.tab(1)).println("}");
    }

    protected void generateFindManyByMethods(JavaWriter out, String pType, String colName, String colClass, String colType, String colIdentifier) {
        ((JavaWriter)out.tab(1)).javadoc("Find records that have <code>%s IN (values)</code> asynchronously", new Object[]{colName});
        ((JavaWriter)out.tab(1)).println("public %s findManyBy%s(%s<%s> values) {", new Object[]{this.renderFindManyType(pType), colClass, Collection.class, colType});
        ((JavaWriter)out.tab(2)).println("return findManyByCondition(%s.in(values));", new Object[]{colIdentifier});
        ((JavaWriter)out.tab(1)).println("}");
    }

    public String getKeyType(UniqueKeyDefinition key) {
        String tType;
        List keyColumns = key.getKeyColumns();
        if (keyColumns.size() == 1) {
            tType = this.getJavaType(((ColumnDefinition)keyColumns.get(0)).getType());
        } else if (keyColumns.size() <= 22) {
            String generics = "";
            String separator = "";
            for (ColumnDefinition column : keyColumns) {
                generics = generics + separator + this.getJavaType(column.getType());
                separator = ", ";
            }
            tType = Record.class.getName() + keyColumns.size() + "<" + generics + ">";
        } else {
            tType = Record.class.getName();
        }
        return tType;
    }

    private int colRefSegments(TypedElementDefinition<?> column) {
        if (column != null && column.getContainer() instanceof UDTDefinition) {
            return 2;
        }
        if (!this.getStrategy().getInstanceFields()) {
            return 2;
        }
        return 3;
    }

    protected void generateDao(TableDefinition table, JavaWriter out1) {
        UniqueKeyDefinition key = table.getPrimaryKey();
        if (key == null) {
            logger.info((Object)"Skipping DAO generation", (Object)out1.file().getName());
            return;
        }
        VertxJavaWriter out = (VertxJavaWriter)out1;
        this.generateDAO(key, table, out);
    }

    private void generateDAO(UniqueKeyDefinition key, TableDefinition table, VertxJavaWriter out) {
        String separator;
        String className = this.getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO);
        List interfaces = out.ref(this.getStrategy().getJavaClassImplements((Definition)table, GeneratorStrategy.Mode.DAO));
        String tableRecord = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD));
        String daoImpl = out.ref(this.renderDaoExtendsClassName());
        String tableIdentifier = out.ref(this.getStrategy().getFullJavaIdentifier((Definition)table), 2);
        String tType = "Void";
        String pType = out.ref(this.getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO));
        List keyColumns = key.getKeyColumns();
        if (keyColumns.size() == 1) {
            tType = this.getJavaType(((ColumnDefinition)keyColumns.get(0)).getType());
        } else if (keyColumns.size() <= 22) {
            String generics = "";
            separator = "";
            for (ColumnDefinition column : keyColumns) {
                generics = generics + separator + out.ref(this.getJavaType(column.getType()));
                separator = ", ";
            }
            tType = Record.class.getName() + keyColumns.size() + "<" + generics + ">";
        } else {
            tType = Record.class.getName();
        }
        tType = out.ref(tType);
        interfaces.add(this.renderDAOInterface(tableRecord, pType, tType));
        this.printPackage(out, (Definition)table, GeneratorStrategy.Mode.DAO);
        this.generateDaoClassJavadoc(table, out);
        this.printClassAnnotations(out, table.getSchema());
        if (this.generateSpringAnnotations()) {
            out.println("@%s", new Object[]{out.ref("org.springframework.stereotype.Repository")});
        }
        this.writeDAOClassAnnotation(out);
        out.println("public class %s extends %s<%s, %s, %s, %s, %s, %s, %s>[[before= implements ][%s]] {", new Object[]{className, daoImpl, tableRecord, pType, tType, this.renderFindManyType(pType), this.renderFindOneType(pType), this.renderExecType(), this.renderInsertReturningType(tType), interfaces});
        if (this.generateSpringAnnotations()) {
            ((JavaWriter)out.tab(1)).println("@%s", new Object[]{out.ref("org.springframework.beans.factory.annotation.Autowired")});
        }
        this.writeDAOConstructorAnnotation(out);
        this.writeDAOConstructor(out, className, tableIdentifier, tableRecord, pType, tType, table.getSchema().getName());
        ((JavaWriter)out.tab(1)).overrideInherit();
        ((JavaWriter)out.tab(1)).println("protected %s getId(%s object) {", new Object[]{tType, pType});
        if (keyColumns.size() == 1) {
            ((JavaWriter)out.tab(2)).println("return object.%s();", new Object[]{this.getStrategy().getJavaGetterName((Definition)keyColumns.get(0), GeneratorStrategy.Mode.POJO)});
        } else {
            String params = "";
            separator = "";
            for (ColumnDefinition column : keyColumns) {
                params = params + separator + "object." + this.getStrategy().getJavaGetterName((Definition)column, GeneratorStrategy.Mode.POJO) + "()";
                separator = ", ";
            }
            ((JavaWriter)out.tab(2)).println("return compositeKeyRecord(%s);", new Object[]{params});
        }
        ((JavaWriter)out.tab(1)).println("}");
        this.generateFetchMethods(table, out);
        this.generateDaoClassFooter(table, out);
        this.overwriteDAOMethods(out, className, tableIdentifier, tableRecord, pType, tType);
        out.println("}");
    }
}

