/*
 * Decompiled with CFR 0.152.
 */
package io.github.jklingsporn.vertx.jooq.generate.builder;

import io.github.jklingsporn.vertx.jooq.generate.builder.APIStep;
import io.github.jklingsporn.vertx.jooq.generate.builder.BuildOptions;
import io.github.jklingsporn.vertx.jooq.generate.builder.ComponentBasedVertxGenerator;
import io.github.jklingsporn.vertx.jooq.generate.builder.ConverterInstantiationMethod;
import io.github.jklingsporn.vertx.jooq.generate.builder.DIStep;
import io.github.jklingsporn.vertx.jooq.generate.builder.ExecutionStep;
import io.github.jklingsporn.vertx.jooq.generate.builder.FinalStep;
import io.github.jklingsporn.vertx.jooq.generate.builder.NamedInjectionStrategy;
import io.github.jklingsporn.vertx.jooq.generate.builder.RenderQueryExecutorTypesComponent;
import io.github.jklingsporn.vertx.jooq.shared.JsonArrayConverter;
import io.github.jklingsporn.vertx.jooq.shared.JsonObjectConverter;
import io.github.jklingsporn.vertx.jooq.shared.ObjectToJsonObjectBinding;
import io.github.jklingsporn.vertx.jooq.shared.internal.AbstractVertxDAO;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.jooq.Configuration;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.JavaWriter;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;

public class VertxGeneratorBuilder {
    static final Map<String, String> SUPPORTED_MYSQL_INSERT_RETURNING_TYPES_MAP = new HashMap<String, String>();

    private VertxGeneratorBuilder() {
    }

    public static APIStep init() {
        return new APIStepImpl(new ComponentBasedVertxGenerator().setRenderFQVertxNameDelegate(() -> "io.vertx.core.Vertx"));
    }

    static String resolveConverterInstance(String converterName, SchemaDefinition schema, ComponentBasedVertxGenerator generator) {
        String converter_instance = generator.buildOptions.getConverterInstantiationMethod().apply(converterName);
        return generator.buildOptions.getConverterInstantiationMethod().equals(ConverterInstantiationMethod.NEW) ? converter_instance : generator.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables.converters.Converters." + converter_instance;
    }

    static {
        SUPPORTED_MYSQL_INSERT_RETURNING_TYPES_MAP.put(Byte.class.getSimpleName(), Byte.TYPE.getSimpleName());
        SUPPORTED_MYSQL_INSERT_RETURNING_TYPES_MAP.put(Short.class.getSimpleName(), Short.TYPE.getSimpleName());
        SUPPORTED_MYSQL_INSERT_RETURNING_TYPES_MAP.put(Integer.class.getSimpleName(), Integer.TYPE.getSimpleName());
        SUPPORTED_MYSQL_INSERT_RETURNING_TYPES_MAP.put(Long.class.getSimpleName(), Long.TYPE.getSimpleName());
    }

    static class FinalStepImpl
    implements FinalStep {
        protected final ComponentBasedVertxGenerator base;

        FinalStepImpl(ComponentBasedVertxGenerator base) {
            this.base = base;
        }

        @Override
        public ComponentBasedVertxGenerator build() {
            return this.build(new BuildOptions());
        }

        @Override
        public ComponentBasedVertxGenerator build(BuildOptions buildOptions) {
            this.base.buildOptions = buildOptions;
            if (buildOptions.getConverterInstantiationMethod().equals(ConverterInstantiationMethod.SINGLETON)) {
                this.base.addWriteExtraDataDelegate((schema, writerGen) -> {
                    ComponentBasedVertxGenerator.logger.info((Object)"Generate Converters ... ");
                    String packageName = (this.base.getActiveGenerator().getStrategy().getTargetDirectory() + "/" + this.base.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables.converters").replaceAll("\\.", "/");
                    File moduleFile = new File(packageName, "Converters.java");
                    JavaWriter out = (JavaWriter)writerGen.apply(moduleFile);
                    this.generateConverters((SchemaDefinition)schema, out);
                    return out;
                });
                this.base.addWriteExtraDataDelegate((schema, writerGen) -> {
                    ComponentBasedVertxGenerator.logger.info((Object)"Generate Bindings ... ");
                    String packageName = (this.base.getActiveGenerator().getStrategy().getTargetDirectory() + "/" + this.base.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables.converters").replaceAll("\\.", "/");
                    File moduleFile = new File(packageName, "Bindings.java");
                    JavaWriter out = (JavaWriter)writerGen.apply(moduleFile);
                    this.generateBindings((SchemaDefinition)schema, out);
                    return out;
                });
            }
            return this.base;
        }

        private void generateConverters(SchemaDefinition schema, JavaWriter out) {
            out.println("package " + this.base.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables.converters;");
            out.println();
            out.println("public class Converters {");
            out.println();
            schema.getTables().stream().flatMap(td -> td.getColumns().stream()).filter(cd -> cd.getType().getConverter() != null).map(cd -> cd.getType().getConverter()).distinct().forEach(conv -> {
                JavaWriter cfr_ignored_0 = (JavaWriter)out.println("public static final %s %s = new %s();", new Object[]{conv, ConverterInstantiationMethod.SINGLETON.apply((String)conv), conv});
            });
            out.println();
            out.println("}");
        }

        private void generateBindings(SchemaDefinition schema, JavaWriter out) {
            out.println("package " + this.base.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables.converters;");
            out.println();
            out.println("public class Bindings {");
            out.println();
            schema.getTables().stream().flatMap(td -> td.getColumns().stream()).filter(cd -> cd.getType().getBinding() != null).map(cd -> cd.getType().getBinding()).distinct().forEach(binding -> {
                JavaWriter cfr_ignored_0 = (JavaWriter)out.println("public static final %s %s = new %s();", new Object[]{binding, ConverterInstantiationMethod.SINGLETON.apply((String)binding), binding});
            });
            out.println();
            out.println("}");
        }
    }

    static class DIStepImpl
    extends FinalStepImpl
    implements DIStep {
        public DIStepImpl(ComponentBasedVertxGenerator base) {
            super(base);
        }

        @Override
        public FinalStep withGuice(boolean generateGuiceModules, NamedInjectionStrategy namedInjectionStrategy) {
            this.base.setWriteDAOConstructorAnnotationDelegate(out -> {
                JavaWriter cfr_ignored_0 = (JavaWriter)((JavaWriter)out.tab(1)).println("@javax.inject.Inject");
            });
            this.base.setWriteDAOClassAnnotationDelegate(out -> {
                JavaWriter cfr_ignored_0 = (JavaWriter)out.println("@javax.inject.Singleton");
            });
            this.base.setNamedInjectionStrategy(namedInjectionStrategy);
            if (generateGuiceModules) {
                this.base.addWriteExtraDataDelegate((schema, writerGen) -> {
                    String daoClassName;
                    ComponentBasedVertxGenerator.logger.info((Object)"Generate DaoModule ... ");
                    switch (this.base.apiType) {
                        case CLASSIC: {
                            daoClassName = "io.github.jklingsporn.vertx.jooq.classic.VertxDAO";
                            break;
                        }
                        case COMPLETABLE_FUTURE: {
                            daoClassName = "io.github.jklingsporn.vertx.jooq.completablefuture.VertxDAO";
                            break;
                        }
                        case RX: {
                            daoClassName = "io.github.jklingsporn.vertx.jooq.rx.VertxDAO";
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(this.base.apiType.toString());
                        }
                    }
                    String packageName = (this.base.getActiveGenerator().getStrategy().getTargetDirectory() + "/" + this.base.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables.modules").replaceAll("\\.", "/");
                    File moduleFile = new File(packageName, "DaoModule.java");
                    JavaWriter out = (JavaWriter)writerGen.apply(moduleFile);
                    out.println("package " + this.base.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables.modules;");
                    out.println();
                    out.println("import com.google.inject.AbstractModule;");
                    out.println("import com.google.inject.TypeLiteral;");
                    out.println("import %s;", new Object[]{daoClassName});
                    out.println();
                    out.println("public class DaoModule extends AbstractModule {");
                    ((JavaWriter)out.tab(1)).println("@Override");
                    ((JavaWriter)out.tab(1)).println("protected void configure() {");
                    for (TableDefinition table : schema.getTables()) {
                        UniqueKeyDefinition key = table.getPrimaryKey();
                        if (key == null) {
                            ComponentBasedVertxGenerator.logger.info((Object)"{} has no primary key. Skipping...", (Object)out.file().getName());
                            continue;
                        }
                        String keyType = this.base.getActiveGenerator().getKeyType(key);
                        String tableRecord = this.base.getActiveGenerator().getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.RECORD);
                        String pType = this.base.getActiveGenerator().getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO);
                        String className = this.base.getActiveGenerator().getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.DAO);
                        if (this.base.generateInterfaces()) {
                            String iType = this.base.getActiveGenerator().getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.INTERFACE);
                            ((JavaWriter)out.tab(2)).println("bind(new TypeLiteral<VertxDAO<%s, ? extends %s, %s>>() {}).to(%s.class).asEagerSingleton();", new Object[]{tableRecord, iType, keyType, className});
                        }
                        ((JavaWriter)out.tab(2)).println("bind(new TypeLiteral<VertxDAO<%s, %s, %s>>() {}).to(%s.class).asEagerSingleton();", new Object[]{tableRecord, pType, keyType, className});
                    }
                    ((JavaWriter)out.tab(1)).println("}");
                    out.println("}");
                    return out;
                });
            }
            return new FinalStepImpl(this.base);
        }
    }

    static class ExecutionStepImpl
    implements ExecutionStep {
        private final ComponentBasedVertxGenerator base;

        ExecutionStepImpl(ComponentBasedVertxGenerator base) {
            this.base = base;
        }

        @Override
        public DIStep withJDBCDriver() {
            this.base.setRenderDAOExtendsDelegate(AbstractVertxDAO.class::getName);
            switch (this.base.apiType) {
                case CLASSIC: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.classic.jdbc.JDBCClassicQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("JDBCClassicQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration The Configuration used for rendering and query execution.\n     * @param vertx the vertx instance", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s%s configuration, %s vertx) {", new Object[]{className, this.base.namedInjectionStrategy.apply(schema), Configuration.class, this.base.renderFQVertxName()});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,%s.class,vertx));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), pType});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
                case COMPLETABLE_FUTURE: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.completablefuture.jdbc.JDBCCompletableFutureQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("JDBCCompletableFutureQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration The Configuration used for rendering and query execution.\n     * @param vertx the vertx instance", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s%s configuration, %s vertx) {", new Object[]{className, this.base.namedInjectionStrategy.apply(schema), Configuration.class, this.base.renderFQVertxName()});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,%s.class,vertx));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), pType});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
                case RX: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.rx.jdbc.JDBCRXQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("JDBCRXQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration The Configuration used for rendering and query execution.\n     * @param vertx the vertx instance", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s%s configuration, %s vertx) {", new Object[]{className, this.base.namedInjectionStrategy.apply(schema), Configuration.class, this.base.renderFQVertxName()});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,%s.class,vertx));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), pType});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
            }
            throw new UnsupportedOperationException(this.base.apiType.toString());
        }

        @Override
        public DIStep withAsyncDriver() {
            this.base.setRenderDAOExtendsDelegate(() -> "io.github.jklingsporn.vertx.jooq.shared.async.AbstractAsyncVertxDAO");
            this.base.addOverwriteDAODelegate((out, className, tableIdentifier, tableRecord, pType, tType) -> {
                if (SUPPORTED_MYSQL_INSERT_RETURNING_TYPES_MAP.containsKey(tType)) {
                    out.println();
                    ((JavaWriter)out.tab(1)).override();
                    ((JavaWriter)out.tab(1)).println("protected java.util.function.Function<Object,%s> keyConverter(){", new Object[]{tType});
                    ((JavaWriter)out.tab(2)).println("return lastId -> %s.valueOf(((%s)lastId).getLong(0).%sValue());", new Object[]{tType, JsonArray.class.getName(), SUPPORTED_MYSQL_INSERT_RETURNING_TYPES_MAP.get(tType)});
                    ((JavaWriter)out.tab(1)).println("}");
                }
            });
            switch (this.base.apiType) {
                case CLASSIC: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.classic.async.AsyncClassicQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("AsyncClassicQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration Used for rendering, so only SQLDialect must be set and must be one of the MYSQL types or POSTGRES.\n     * @param delegate A configured AsyncSQLClient that is used for query execution", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s configuration, %sio.vertx.ext.asyncsql.AsyncSQLClient delegate) {", new Object[]{className, Configuration.class, this.base.namedInjectionStrategy.apply(schema)});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,delegate,%s::new, %s));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), pType, tableIdentifier});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
                case COMPLETABLE_FUTURE: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.completablefuture.async.AsyncCompletableFutureQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("AsyncCompletableFutureQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration Used for rendering, so only SQLDialect must be set and must be one of the MYSQL types or POSTGRES.\n     * @param vertx the vertx instance\n     * @param delegate A configured AsyncSQLClient that is used for query execution", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s configuration, %s vertx, %sio.vertx.ext.asyncsql.AsyncSQLClient delegate) {", new Object[]{className, Configuration.class, this.base.renderFQVertxName(), this.base.namedInjectionStrategy.apply(schema)});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,vertx,delegate,%s::new, %s));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), pType, tableIdentifier});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
                case RX: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.rx.async.AsyncRXQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("AsyncRXQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration Used for rendering, so only SQLDialect must be set and must be one of the MYSQL types or POSTGRES.\n     * @param delegate A configured AsyncSQLClient that is used for query execution", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s configuration,%sio.vertx.reactivex.ext.asyncsql.AsyncSQLClient delegate) {", new Object[]{className, Configuration.class, this.base.namedInjectionStrategy.apply(schema)});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,delegate,%s::new, %s));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), pType, tableIdentifier});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
            }
            throw new UnsupportedOperationException(this.base.apiType.toString());
        }

        @Override
        public DIStep withPostgresReactiveDriver() {
            this.base.setRenderDAOExtendsDelegate(() -> "io.github.jklingsporn.vertx.jooq.shared.reactive.AbstractReactiveVertxDAO");
            this.base.addWriteExtraDataDelegate((schema, writerGen) -> {
                ComponentBasedVertxGenerator.logger.info((Object)"Generate RowMappers ... ");
                String mappersSubPackage = this.base.getActiveGenerator().getVertxGeneratorStrategy().getRowMappersSubPackage();
                String packageName = this.base.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables." + mappersSubPackage;
                String dir = this.base.getActiveGenerator().getStrategy().getTargetDirectory();
                dir = File.separator.equals("/") ? dir.replace("\\", File.separator) : dir.replace("/", File.separator);
                dir = dir + File.separator + packageName.replace(".", File.separator);
                File moduleFile = new File(dir, "RowMappers.java");
                JavaWriter out = (JavaWriter)writerGen.apply(moduleFile);
                out.println("package " + this.base.getActiveGenerator().getStrategy().getJavaPackageName((Definition)schema) + ".tables." + mappersSubPackage + ";");
                out.println();
                out.println("import io.vertx.sqlclient.Row;");
                out.println("import %s;", new Object[]{Function.class.getName()});
                out.println();
                out.println("public class RowMappers {");
                out.println();
                ((JavaWriter)out.tab(1)).println("private RowMappers(){}");
                out.println();
                HashSet<String> supportedRowTypes = new HashSet<String>();
                supportedRowTypes.add(Boolean.class.getName());
                supportedRowTypes.add(Short.class.getName());
                supportedRowTypes.add(Integer.class.getName());
                supportedRowTypes.add(Long.class.getName());
                supportedRowTypes.add(Float.class.getName());
                supportedRowTypes.add(Double.class.getName());
                supportedRowTypes.add(BigDecimal.class.getName());
                supportedRowTypes.add(String.class.getName());
                supportedRowTypes.add(Character.class.getName());
                supportedRowTypes.add(Buffer.class.getName());
                supportedRowTypes.add(UUID.class.getName());
                supportedRowTypes.add(Instant.class.getName());
                supportedRowTypes.add(Temporal.class.getName());
                supportedRowTypes.add(LocalTime.class.getName());
                supportedRowTypes.add(LocalDate.class.getName());
                supportedRowTypes.add(LocalDateTime.class.getName());
                supportedRowTypes.add(OffsetTime.class.getName());
                supportedRowTypes.add(OffsetDateTime.class.getName());
                supportedRowTypes.add("io.vertx.pgclient.data.Interval");
                supportedRowTypes.add("io.vertx.sqlclient.data.Numeric");
                for (TableDefinition table : schema.getTables()) {
                    UniqueKeyDefinition key = table.getPrimaryKey();
                    if (key == null) {
                        ComponentBasedVertxGenerator.logger.info((Object)"{} has no primary key. Skipping...", (Object)out.file().getName());
                        continue;
                    }
                    String pType = this.base.getActiveGenerator().getStrategy().getFullJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO);
                    ((JavaWriter)out.tab(1)).println("public static Function<Row,%s> get%sMapper() {", new Object[]{pType, this.base.getActiveGenerator().getStrategy().getJavaClassName((Definition)table, GeneratorStrategy.Mode.POJO)});
                    ((JavaWriter)out.tab(2)).println("return row -> {");
                    ((JavaWriter)out.tab(3)).println("%s pojo = new %s();", new Object[]{pType, pType});
                    for (ColumnDefinition column : table.getColumns()) {
                        boolean isEnumType;
                        String setter = this.base.getActiveGenerator().getStrategy().getJavaSetterName((Definition)column, GeneratorStrategy.Mode.INTERFACE);
                        String javaType = this.base.getActiveGenerator().getJavaType(column.getType());
                        boolean bl = isEnumType = javaType.contains("enums.") || column.getType().getConverter() != null && column.getType().getConverter().endsWith("EnumConverter");
                        if (supportedRowTypes.contains(javaType)) {
                            try {
                                ((JavaWriter)out.tab(3)).println("pojo.%s(row.get%s(\"%s\"));", new Object[]{setter, Class.forName(javaType).getSimpleName(), column.getName()});
                            }
                            catch (ClassNotFoundException e) {
                                ComponentBasedVertxGenerator.logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        if (javaType.equals(JsonObject.class.getName()) || column.getType().getConverter() != null && column.getType().getConverter().equalsIgnoreCase(JsonObjectConverter.class.getName()) || column.getType().getBinding() != null && column.getType().getBinding().equalsIgnoreCase(ObjectToJsonObjectBinding.class.getName())) {
                            ((JavaWriter)out.tab(3)).println("pojo.%s(row.get(io.vertx.core.json.JsonObject.class,row.getColumnIndex(\"%s\")));", new Object[]{setter, column.getName()});
                            continue;
                        }
                        if (javaType.equals(JsonArray.class.getName()) || column.getType().getConverter() != null && column.getType().getConverter().equalsIgnoreCase(JsonArrayConverter.class.getName())) {
                            ((JavaWriter)out.tab(3)).println("pojo.%s(row.get(io.vertx.core.json.JsonArray.class,row.getColumnIndex(\"%s\")));", new Object[]{setter, column.getName()});
                            continue;
                        }
                        if (isEnumType) {
                            if (column.getType().getConverter() == null) {
                                ((JavaWriter)out.tab(3)).println("pojo.%s(java.util.Arrays.stream(%s.values()).filter(td -> td.getLiteral().equals(row.getString(\"%s\"))).findFirst().orElse(null));", new Object[]{setter, javaType, column.getName()});
                                continue;
                            }
                            ((JavaWriter)out.tab(3)).println("String %sString = row.getString(\"%s\");", new Object[]{column.getName(), column.getName()});
                            ((JavaWriter)out.tab(3)).println("pojo.%s(%sString == null ? null : %s.valueOf(%sString));", new Object[]{setter, column.getName(), javaType, column.getName()});
                            continue;
                        }
                        if (column.getType().getConverter() != null && (column.getType().getType().equalsIgnoreCase(SQLDataType.JSONB.getTypeName()) || column.getType().getType().equalsIgnoreCase(SQLDataType.JSON.getTypeName()))) {
                            ((JavaWriter)out.tab(3)).println("pojo.%s(%s.pgConverter().from(row.get(io.vertx.core.json.JsonObject.class,row.getColumnIndex(\"%s\"))));", new Object[]{setter, VertxGeneratorBuilder.resolveConverterInstance(column.getType().getConverter(), schema, this.base), column.getName()});
                            continue;
                        }
                        if (column.getType().getBinding() != null && (column.getType().getType().equalsIgnoreCase(SQLDataType.JSONB.getTypeName()) || column.getType().getType().equalsIgnoreCase(SQLDataType.JSON.getTypeName()))) {
                            ((JavaWriter)out.tab(3)).println("pojo.%s(%s.converter().pgConverter().from(row.get(io.vertx.core.json.JsonObject.class,row.getColumnIndex(\"%s\"))));", new Object[]{setter, VertxGeneratorBuilder.resolveConverterInstance(column.getType().getBinding(), schema, this.base), column.getName()});
                            continue;
                        }
                        ComponentBasedVertxGenerator.logger.warn((Object)String.format("Omitting unrecognized type %s (%s) for column %s in table %s!", column.getType(), javaType, column.getName(), table.getName()));
                        ((JavaWriter)out.tab(3)).println(String.format("// Omitting unrecognized type %s (%s) for column %s!", column.getType(), javaType, column.getName()));
                    }
                    ((JavaWriter)out.tab(3)).println("return pojo;");
                    ((JavaWriter)out.tab(2)).println("};");
                    ((JavaWriter)out.tab(1)).println("}");
                    out.println();
                }
                out.println("}");
                return out;
            });
            switch (this.base.apiType) {
                case CLASSIC: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.classic.reactivepg.ReactiveClassicQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("ReactiveClassicQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        String temp = pType.substring(0, pType.lastIndexOf(46));
                        String basePath = temp.substring(0, temp.lastIndexOf(46));
                        String pojoName = pType.substring(pType.lastIndexOf(".") + 1, pType.length());
                        String mapperFactory = String.format("%s.%s.RowMappers.get%sMapper()", basePath, this.base.getVertxGeneratorStrategy().getRowMappersSubPackage(), pojoName);
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration Used for rendering, so only SQLDialect must be set and must be one of the POSTGREs types.\n     * @param delegate A configured AsyncSQLClient that is used for query execution", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s%s configuration, io.vertx.sqlclient.SqlClient delegate) {", new Object[]{className, this.base.namedInjectionStrategy.apply(schema), Configuration.class});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,delegate,%s));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), mapperFactory});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
                case COMPLETABLE_FUTURE: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.completablefuture.reactivepg.ReactiveCompletableFutureQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("ReactiveCompletableFutureQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        String temp = pType.substring(0, pType.lastIndexOf(46));
                        String basePath = temp.substring(0, temp.lastIndexOf(46));
                        String pojoName = pType.substring(pType.lastIndexOf(".") + 1, pType.length());
                        String mapperFactory = String.format("%s.%s.RowMappers.get%sMapper()", basePath, this.base.getVertxGeneratorStrategy().getRowMappersSubPackage(), pojoName);
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration The Configuration used for rendering and query execution.\n     * @param vertx the vertx instance", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s configuration, %sio.vertx.sqlclient.SqlClient delegate, %s vertx) {", new Object[]{className, Configuration.class, this.base.namedInjectionStrategy.apply(schema), this.base.renderFQVertxName()});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,delegate,%s,vertx));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), mapperFactory});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
                case RX: {
                    return new DIStepImpl(this.base.setWriteDAOImportsDelegate(this.base.writeDAOImportsDelegate.andThen(out -> {
                        JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.github.jklingsporn.vertx.jooq.rx.reactivepg.ReactiveRXQueryExecutor;");
                    })).setRenderQueryExecutorDelegate((rType, pType, tType) -> String.format("ReactiveRXQueryExecutor<%s,%s,%s>", rType, pType, tType)).setWriteConstructorDelegate((out, className, tableIdentifier, tableRecord, pType, tType, schema) -> {
                        String temp = pType.substring(0, pType.lastIndexOf(46));
                        String basePath = temp.substring(0, temp.lastIndexOf(46));
                        String pojoName = pType.substring(pType.lastIndexOf(".") + 1, pType.length());
                        String mapperFactory = String.format("%s.%s.RowMappers.get%sMapper()", basePath, this.base.getVertxGeneratorStrategy().getRowMappersSubPackage(), pojoName);
                        ((JavaWriter)out.tab(1)).javadoc("@param configuration The Configuration used for rendering and query execution.\n     * @param vertx the vertx instance", new Object[0]);
                        ((JavaWriter)out.tab(1)).println("public %s(%s configuration, %sio.vertx.reactivex.sqlclient.SqlClient delegate) {", new Object[]{className, Configuration.class, this.base.namedInjectionStrategy.apply(schema)});
                        ((JavaWriter)out.tab(2)).println("super(%s, %s.class, new %s(configuration,delegate,%s));", new Object[]{tableIdentifier, pType, this.base.renderQueryExecutor(tableRecord, pType, tType), mapperFactory});
                        ((JavaWriter)out.tab(1)).println("}");
                    }));
                }
            }
            throw new UnsupportedOperationException(this.base.apiType.toString());
        }
    }

    static class APIStepImpl
    implements APIStep {
        private final ComponentBasedVertxGenerator base;

        APIStepImpl(ComponentBasedVertxGenerator base) {
            this.base = base;
            this.base.addOverwriteDAODelegate((out, className, tableIdentifier, tableRecord, pType, tType) -> {
                out.println();
                ((JavaWriter)out.tab(1)).override();
                ((JavaWriter)out.tab(1)).println("public %s queryExecutor(){", new Object[]{base.renderQueryExecutor(tableRecord, pType, tType)});
                ((JavaWriter)out.tab(2)).println("return (%s) super.queryExecutor();", new Object[]{base.renderQueryExecutor(tableRecord, pType, tType)});
                ((JavaWriter)out.tab(1)).println("}");
            });
        }

        @Override
        public ExecutionStep withClassicAPI() {
            return new ExecutionStepImpl(this.base.setApiType(APIType.CLASSIC).setWriteDAOImportsDelegate(out -> {
                JavaWriter cfr_ignored_0 = (JavaWriter)out.println("import io.vertx.core.Future;");
            }).setRenderQueryExecutorTypesDelegate(new RenderQueryExecutorTypesComponent(){

                @Override
                public String renderFindOneType(String pType) {
                    return String.format("Future<%s>", pType);
                }

                @Override
                public String renderFindManyType(String pType) {
                    return String.format("Future<List<%s>>", pType);
                }

                @Override
                public String renderExecType() {
                    return "Future<Integer>";
                }

                @Override
                public String renderInsertReturningType(String tType) {
                    return String.format("Future<%s>", tType);
                }
            }).setRenderDAOInterfaceDelegate((rType, pType, tType) -> String.format("io.github.jklingsporn.vertx.jooq.classic.VertxDAO<%s,%s,%s>", rType, pType, tType)));
        }

        @Override
        public ExecutionStep withCompletableFutureAPI() {
            return new ExecutionStepImpl(this.base.setApiType(APIType.COMPLETABLE_FUTURE).setWriteDAOImportsDelegate(out -> {
                out.println("import java.util.concurrent.CompletableFuture;");
                out.println("import io.github.jklingsporn.vertx.jooq.completablefuture.VertxDAO;");
            }).setRenderQueryExecutorTypesDelegate(new RenderQueryExecutorTypesComponent(){

                @Override
                public String renderFindOneType(String pType) {
                    return String.format("CompletableFuture<%s>", pType);
                }

                @Override
                public String renderFindManyType(String pType) {
                    return String.format("CompletableFuture<List<%s>>", pType);
                }

                @Override
                public String renderExecType() {
                    return "CompletableFuture<Integer>";
                }

                @Override
                public String renderInsertReturningType(String tType) {
                    return String.format("CompletableFuture<%s>", tType);
                }
            }).setRenderDAOInterfaceDelegate((rType, pType, tType) -> String.format("io.github.jklingsporn.vertx.jooq.completablefuture.VertxDAO<%s,%s,%s>", rType, pType, tType)));
        }

        @Override
        public ExecutionStep withRXAPI() {
            return new ExecutionStepImpl(this.base.setRenderFQVertxNameDelegate(() -> "io.vertx.reactivex.core.Vertx").setApiType(APIType.RX).setWriteDAOImportsDelegate(out -> {
                out.println("import io.reactivex.Single;");
                out.println("import java.util.Optional;");
            }).setRenderQueryExecutorTypesDelegate(new RenderQueryExecutorTypesComponent(){

                @Override
                public String renderFindOneType(String pType) {
                    return String.format("Single<Optional<%s>>", pType);
                }

                @Override
                public String renderFindManyType(String pType) {
                    return String.format("Single<List<%s>>", pType);
                }

                @Override
                public String renderExecType() {
                    return "Single<Integer>";
                }

                @Override
                public String renderInsertReturningType(String tType) {
                    return String.format("Single<%s>", tType);
                }
            }).setRenderDAOInterfaceDelegate((rType, pType, tType) -> String.format("io.github.jklingsporn.vertx.jooq.rx.VertxDAO<%s,%s,%s>", rType, pType, tType)));
        }
    }

    static enum APIType {
        CLASSIC,
        COMPLETABLE_FUTURE,
        RX;

    }
}

