/*
 * Decompiled with CFR 0.152.
 */
package dev.wonddak.capturable;

import android.graphics.Bitmap;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.ImageBitmap;
import dev.wonddak.capturable.ImageType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"toByteArray", "", "Landroidx/compose/ui/graphics/ImageBitmap;", "type", "Ldev/wonddak/capturable/ImageType;", "capturable_release"})
public final class ImageBitmapExtension_androidKt {
    @NotNull
    public static final byte[] toByteArray(@NotNull ImageBitmap $this$toByteArray, @NotNull ImageType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Bitmap androidBitmap = AndroidImageBitmap_androidKt.asAndroidBitmap((ImageBitmap)$this$toByteArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageType imageType = type;
        if (imageType instanceof ImageType.JPEG) {
            bl = androidBitmap.compress(Bitmap.CompressFormat.JPEG, ((ImageType.JPEG)type).getQuality(), (OutputStream)byteArrayOutputStream);
        } else if (imageType instanceof ImageType.PNG) {
            bl = androidBitmap.compress(Bitmap.CompressFormat.PNG, ((ImageType.PNG)type).getQuality(), (OutputStream)byteArrayOutputStream);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }
}

