/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.FContent;
import au.edu.apsr.mtk.base.FLocat;
import au.edu.apsr.mtk.base.METSElement;
import au.edu.apsr.mtk.base.METSException;
import au.edu.apsr.mtk.base.Stream;
import au.edu.apsr.mtk.base.TransformFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class File
extends METSElement {
    List<FLocat> flocats = null;
    List<File> files = null;
    List<TransformFile> tfiles = null;
    List<Stream> streams = null;
    FContent fContent = null;

    public File(Node n) throws METSException {
        super(n, "file");
        this.init();
    }

    public FLocat newFLocat() throws METSException {
        return new FLocat(this.newElement("FLocat"));
    }

    public File newFile() throws METSException {
        return new File(this.newElement("file"));
    }

    public TransformFile newTransformFile() throws METSException {
        return new TransformFile(this.newElement("transformFile"));
    }

    public Stream newStream() throws METSException {
        return new Stream(this.newElement("stream"));
    }

    public String getID() {
        return super.getAttributeValue("ID");
    }

    public void setID(String id) {
        super.setAttributeValue("ID", id);
    }

    public String getDmdID() {
        return super.getAttributeValue("DMDID");
    }

    public String[] getDmdIDs() {
        return super.getAttributeValue("DMDID").split("\\s+");
    }

    public void setDmdID(String dmdID) {
        super.setAttributeValue("DMDID", dmdID);
    }

    public void removeDmdID() {
        super.removeAttribute("DMDID");
    }

    public String getGroupID() {
        return super.getAttributeValue("GROUPID");
    }

    public void setGroupID(String groupID) {
        super.setAttributeValue("GROUPID", groupID);
    }

    public void removeGroupID() {
        super.removeAttribute("GROUPID");
    }

    public String getAdmID() {
        return super.getAttributeValue("ADMID");
    }

    public String[] getAdmIDs() {
        return super.getAttributeValue("ADMID").split("\\s+");
    }

    public void setAmdID(String amdID) {
        super.setAttributeValue("ADMID", amdID);
    }

    public void removeAdmID() {
        super.removeAttribute("ADMID");
    }

    public String getOwnerID() {
        return super.getAttributeValue("OWNERID");
    }

    public void setOwnerID(String ownerID) {
        super.setAttributeValue("OWNERID", ownerID);
    }

    public void removeOwnerID() {
        super.removeAttribute("OWNERID");
    }

    public String getUse() {
        return super.getAttributeValue("USE");
    }

    public void setUse(String use) {
        super.setAttributeValue("USE", use);
    }

    public void removeUse() {
        super.removeAttribute("USE");
    }

    public String getSeq() {
        return super.getAttributeValue("SEQ");
    }

    public void setSeq(String seq) {
        super.setAttributeValue("SEQ", seq);
    }

    public void removeSeq() {
        super.removeAttribute("SEQ");
    }

    public String getMIMEType() {
        return super.getAttributeValue("MIMETYPE");
    }

    public void setMIMEType(String mimeType) {
        super.setAttributeValue("MIMETYPE", mimeType);
    }

    public void removeMIMEType() {
        super.removeAttribute("MIMETYPE");
    }

    public String getChecksum() {
        return super.getAttributeValue("CHECKSUM");
    }

    public void setChecksum(String checksum) {
        super.setAttributeValue("CHECKSUM", checksum);
    }

    public void removeChecksum() {
        super.removeAttribute("CHECKSUM");
    }

    public String getChecksumType() {
        return super.getAttributeValue("CHECKSUMTYPE");
    }

    public void setChecksumType(String cType) {
        super.setAttributeValue("CHECKSUMTYPE", cType);
    }

    public void removeChecksumType() {
        super.removeAttribute("CHECKSUMTYPE");
    }

    public String getBegin() {
        return super.getAttributeValue("BEGIN");
    }

    public void setBegin(String begin) {
        super.setAttributeValue("BEGIN", begin);
    }

    public void removeBegin() {
        super.removeAttribute("BEGIN");
    }

    public String getEnd() {
        return super.getAttributeValue("END");
    }

    public void setEnd(String end) {
        super.setAttributeValue("END", end);
    }

    public void removeEnd() {
        super.removeAttribute("END");
    }

    public String getBEType() {
        return super.getAttributeValue("BETYPE");
    }

    public void setBEType(String beType) {
        super.setAttributeValue("BETYPE", beType);
    }

    public void removeBEType() {
        super.removeAttribute("BETYPE");
    }

    public long getSize() {
        String s = super.getAttributeValue("SIZE");
        if (s.length() == 0) {
            return -1L;
        }
        return Long.valueOf(s);
    }

    public void setSize(long size) {
        super.setAttributeValue("SIZE", String.valueOf(size));
    }

    public void removeSize() {
        super.removeAttribute("SIZE");
    }

    public String getCreated() {
        return super.getAttributeValue("CREATED");
    }

    public void setCreated(String created) {
        super.setAttributeValue("CREATED", created);
    }

    public void removeCreated() {
        super.removeAttribute("CREATED");
    }

    public Node getXMLData() {
        NodeList nl = super.getElements("xmlData");
        if (nl.getLength() == 1) {
            return nl.item(0).getFirstChild();
        }
        return null;
    }

    public void setXMLData(Element content) throws METSException {
        FContent fc = new FContent(this.newElement("FContent"));
        fc.setXMLData(content);
        this.getElement().appendChild(fc.getElement());
    }

    public String getEncodedData() {
        NodeList nl = super.getElements("binData");
        if (nl.getLength() == 1) {
            return nl.item(0).getTextContent();
        }
        return null;
    }

    public void setBinData(String content) throws METSException {
        FContent fc = new FContent(this.newElement("FContent"));
        fc.setEncodedData(content);
        this.getElement().appendChild(fc.getElement());
    }

    public boolean hasEncodedData() {
        NodeList nl = super.getElements("binData");
        return nl.getLength() > 0;
    }

    public List<FLocat> getFLocats() throws METSException {
        return this.flocats;
    }

    public FLocat addFLocat(FLocat flocat) {
        if (flocat.getID().equals("")) {
            this.getElement().appendChild(flocat.getElement());
            this.flocats.add(flocat);
            return null;
        }
        for (FLocat f : this.flocats) {
            if (!f.getID().equals(flocat.getID())) continue;
            this.getElement().replaceChild(flocat.getElement(), f.getElement());
            this.flocats.add(flocat);
            return f;
        }
        this.getElement().appendChild(flocat.getElement());
        this.flocats.add(flocat);
        return null;
    }

    public FLocat removeFLocat(String id) {
        Iterator<FLocat> i = this.flocats.iterator();
        while (i.hasNext()) {
            FLocat flocat = i.next();
            if (!flocat.getID().equals(id)) continue;
            this.getElement().removeChild(flocat.getElement());
            i.remove();
            return flocat;
        }
        return null;
    }

    public FLocat removeFLocat(int pos) {
        for (int i = 0; i < this.flocats.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.flocats.get(i).getElement());
            return this.flocats.remove(i);
        }
        return null;
    }

    public List<TransformFile> getTransformFiles() throws METSException {
        return this.tfiles;
    }

    public TransformFile addTransformFile(TransformFile transformFile) {
        if (transformFile.getID().equals("")) {
            this.getElement().appendChild(transformFile.getElement());
            this.tfiles.add(transformFile);
            return null;
        }
        for (TransformFile tf : this.tfiles) {
            if (!tf.getID().equals(transformFile.getID())) continue;
            this.getElement().replaceChild(transformFile.getElement(), tf.getElement());
            this.tfiles.add(transformFile);
            return tf;
        }
        this.getElement().appendChild(transformFile.getElement());
        this.tfiles.add(transformFile);
        return null;
    }

    public TransformFile removeTransformFile(String id) {
        Iterator<TransformFile> i = this.tfiles.iterator();
        while (i.hasNext()) {
            TransformFile tf = i.next();
            if (!tf.getID().equals(id)) continue;
            this.getElement().removeChild(tf.getElement());
            i.remove();
            return tf;
        }
        return null;
    }

    public TransformFile removeTransformFile(int pos) {
        for (int i = 0; i < this.tfiles.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.tfiles.get(i).getElement());
            return this.tfiles.remove(i);
        }
        return null;
    }

    public List<Stream> getStreams() throws METSException {
        return this.streams;
    }

    public Stream addStream(Stream stream) {
        if (stream.getID().equals("")) {
            this.getElement().appendChild(stream.getElement());
            this.streams.add(stream);
            return null;
        }
        for (Stream s : this.streams) {
            if (!s.getID().equals(stream.getID())) continue;
            this.getElement().replaceChild(stream.getElement(), s.getElement());
            this.streams.add(stream);
            return s;
        }
        this.getElement().appendChild(stream.getElement());
        this.streams.add(stream);
        return null;
    }

    public Stream removeStream(String id) {
        Iterator<Stream> i = this.streams.iterator();
        while (i.hasNext()) {
            Stream s = i.next();
            if (!s.getID().equals(id)) continue;
            this.getElement().removeChild(s.getElement());
            i.remove();
            return s;
        }
        return null;
    }

    public Stream removeStream(int pos) {
        for (int i = 0; i < this.streams.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.streams.get(i).getElement());
            return this.streams.remove(i);
        }
        return null;
    }

    public List<File> getFiles() throws METSException {
        return this.files;
    }

    public File getFile(String id) throws METSException {
        File file = null;
        for (File f : this.files) {
            if (!f.getID().equals(id)) continue;
            file = f;
            break;
        }
        return file;
    }

    public File addFile(File file) {
        for (File f : this.files) {
            if (!f.getID().equals(file.getID())) continue;
            this.getElement().replaceChild(file.getElement(), f.getElement());
            this.files.add(file);
            return f;
        }
        this.getElement().appendChild(file.getElement());
        this.files.add(file);
        return null;
    }

    public File removeFile(String id) {
        Iterator<File> i = this.files.iterator();
        while (i.hasNext()) {
            File f = i.next();
            if (!f.getID().equals(id)) continue;
            this.getElement().removeChild(f.getElement());
            i.remove();
            return f;
        }
        return null;
    }

    private void init() throws METSException {
        this.initFLocats();
        this.initChildFiles();
        this.initTransformFiles();
        this.initStreams();
    }

    private void initFLocats() throws METSException {
        this.flocats = new ArrayList<FLocat>();
        NodeList nl = super.getElements("FLocat");
        for (int i = 0; i < nl.getLength(); ++i) {
            FLocat fl = new FLocat(nl.item(i));
            this.flocats.add(fl);
        }
    }

    private void initChildFiles() throws METSException {
        this.files = new ArrayList<File>();
        List<Node> l = super.getChildElements("file");
        for (Node n : l) {
            this.files.add(new File(n));
        }
    }

    private void initTransformFiles() throws METSException {
        this.tfiles = new ArrayList<TransformFile>();
        List<Node> l = super.getChildElements("transformFile");
        for (Node n : l) {
            this.tfiles.add(new TransformFile(n));
        }
    }

    private void initStreams() throws METSException {
        this.streams = new ArrayList<Stream>();
        List<Node> l = super.getChildElements("stream");
        for (Node n : l) {
            this.streams.add(new Stream(n));
        }
    }
}

