/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.File;
import au.edu.apsr.mtk.base.FileGrp;
import au.edu.apsr.mtk.base.METSElement;
import au.edu.apsr.mtk.base.METSException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileSec
extends METSElement {
    private List<FileGrp> fileGrps = null;
    private HashMap<String, File> allFiles = null;

    public FileSec(Node n) throws METSException {
        super(n, "fileSec");
        this.init();
    }

    public FileGrp newFileGrp() throws METSException {
        return new FileGrp(this.newElement("fileGrp"));
    }

    public String getID() {
        return super.getAttributeValue("ID");
    }

    public void setID(String id) {
        super.setAttributeValue("ID", id);
    }

    public void removeID() {
        super.removeAttribute("ID");
    }

    public List<FileGrp> getFileGrps() throws METSException {
        return this.fileGrps;
    }

    public List<FileGrp> getFileGrpByUse(String use) throws METSException {
        ArrayList<FileGrp> al = new ArrayList<FileGrp>();
        for (FileGrp fileGrp : this.fileGrps) {
            if (!fileGrp.getUse().equals(use)) continue;
            al.add(fileGrp);
        }
        return al;
    }

    public FileGrp addFileGrp(FileGrp fileGrp) {
        if (fileGrp.getID().equals("")) {
            this.getElement().appendChild(fileGrp.getElement());
            this.fileGrps.add(fileGrp);
            return null;
        }
        for (FileGrp fg : this.fileGrps) {
            if (!fg.getID().equals(fileGrp.getID())) continue;
            this.getElement().replaceChild(fileGrp.getElement(), fg.getElement());
            this.fileGrps.add(fileGrp);
            return fg;
        }
        this.getElement().appendChild(fileGrp.getElement());
        this.fileGrps.add(fileGrp);
        return null;
    }

    public FileGrp removeFileGrp(String id) {
        Iterator<FileGrp> i = this.fileGrps.iterator();
        while (i.hasNext()) {
            FileGrp fg = i.next();
            if (!fg.getID().equals(id)) continue;
            this.getElement().removeChild(fg.getElement());
            i.remove();
            return fg;
        }
        return null;
    }

    public FileGrp removeFileGrp(int pos) {
        for (int i = 0; i < this.fileGrps.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.fileGrps.get(i).getElement());
            return this.fileGrps.remove(i);
        }
        return null;
    }

    public File getFile(String id) throws METSException {
        return this.allFiles.get(id);
    }

    public void refresh() throws METSException {
        this.initAllFiles();
    }

    private void init() throws METSException {
        this.initAllFiles();
        this.initFileGrps();
    }

    private void initAllFiles() throws METSException {
        this.allFiles = new HashMap();
        NodeList nl = super.getElements("file");
        for (int i = 0; i < nl.getLength(); ++i) {
            File f = new File(nl.item(i));
            this.allFiles.put(f.getID(), f);
        }
    }

    private void initFileGrps() throws METSException {
        this.fileGrps = new ArrayList<FileGrp>();
        List<Node> l = super.getChildElements("fileGrp");
        for (Node n : l) {
            this.fileGrps.add(new FileGrp(n));
        }
    }
}

