/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.AmdSec;
import au.edu.apsr.mtk.base.BehaviorSec;
import au.edu.apsr.mtk.base.DmdSec;
import au.edu.apsr.mtk.base.FileSec;
import au.edu.apsr.mtk.base.METSElement;
import au.edu.apsr.mtk.base.METSException;
import au.edu.apsr.mtk.base.MetsHdr;
import au.edu.apsr.mtk.base.StructLink;
import au.edu.apsr.mtk.base.StructMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class METS
extends METSElement {
    private MetsHdr metsHdr = null;
    private HashMap<String, DmdSec> dmdSecs = null;
    private List<AmdSec> amdSecs = null;
    private FileSec fileSec = null;
    private StructLink structLink = null;
    private List<BehaviorSec> behaviorSecs = null;
    private List<StructMap> structMaps = null;

    public METS(Node n) throws METSException {
        super(n);
        this.initStructures();
    }

    public METS() throws ParserConfigurationException, METSException {
        this.initStructures();
    }

    public MetsHdr newMetsHdr() throws METSException {
        return new MetsHdr(this.newElement("metsHdr"));
    }

    public DmdSec newDmdSec() throws METSException {
        return new DmdSec(this.newElement("dmdSec"));
    }

    public AmdSec newAmdSec() throws METSException {
        return new AmdSec(this.newElement("amdSec"));
    }

    public FileSec newFileSec() throws METSException {
        return new FileSec(this.newElement("fileSec"));
    }

    public StructMap newStructMap() throws METSException {
        return new StructMap(this.newElement("structMap"));
    }

    public StructLink newStructLink() throws METSException {
        return new StructLink(this.newElement("structLink"));
    }

    public BehaviorSec newBehaviorSec() throws METSException {
        return new BehaviorSec(this.newElement("behaviorSec"));
    }

    public String getID() {
        return super.getAttributeValue("ID");
    }

    public void setID(String id) {
        super.setAttributeValue("ID", id);
    }

    public void removeID() {
        super.removeAttribute("ID");
    }

    public String getObjID() {
        return super.getAttributeValue("OBJID");
    }

    public void setObjID(String objID) {
        super.setAttributeValue("OBJID", objID);
    }

    public void removeObjID() {
        super.removeAttribute("OBJID");
    }

    public String getLabel() {
        return super.getAttributeValue("LABEL");
    }

    public void setLabel(String label) {
        super.setAttributeValue("LABEL", label);
    }

    public void removeLabel() {
        super.removeAttribute("LABEL");
    }

    public String getType() {
        return super.getAttributeValue("TYPE");
    }

    public void setType(String type) {
        super.setAttributeValue("TYPE", type);
    }

    public void removeType() {
        super.removeAttribute("TYPE");
    }

    public String getProfile() {
        return super.getAttributeValue("PROFILE");
    }

    public void setProfile(String profile) {
        super.setAttributeValue("PROFILE", profile);
    }

    public void removeProfile() {
        super.removeAttribute("PROFILE");
    }

    public MetsHdr getMetsHdr() throws METSException {
        return this.metsHdr;
    }

    public void setMetsHdr(MetsHdr hdr) {
        if (this.metsHdr == null) {
            this.getElement().appendChild(hdr.getElement());
        } else {
            this.getElement().replaceChild(hdr.getElement(), this.metsHdr.getElement());
        }
        this.metsHdr = hdr;
    }

    public void removeMetsHdr() {
        if (this.metsHdr != null) {
            this.getElement().removeChild(this.metsHdr.getElement());
            this.metsHdr = null;
        }
    }

    public DmdSec getDmdSec(String id) throws METSException {
        return this.dmdSecs.get(id);
    }

    public DmdSec getDmdSec(String[] ids, String type) throws METSException {
        for (int i = 0; i < ids.length; ++i) {
            DmdSec dmdSec = this.getDmdSec(ids[i]);
            if (!dmdSec.getMDType().equals(type)) continue;
            return dmdSec;
        }
        return null;
    }

    public DmdSec addDmdSec(DmdSec dmdSec) {
        DmdSec existingDmdSec = this.dmdSecs.get(dmdSec.getID());
        if (existingDmdSec != null) {
            this.getElement().replaceChild(dmdSec.getElement(), existingDmdSec.getElement());
        } else {
            this.getElement().appendChild(dmdSec.getElement());
        }
        this.dmdSecs.put(dmdSec.getID(), dmdSec);
        return existingDmdSec;
    }

    public DmdSec removeDmdSec(String id) {
        DmdSec d = this.dmdSecs.get(id);
        if (d != null) {
            this.getElement().removeChild(this.dmdSecs.get(id).getElement());
            this.dmdSecs.remove(id);
        }
        return d;
    }

    public boolean hasDmdSec(String id) {
        return this.dmdSecs.containsKey(id);
    }

    public List<AmdSec> getAmdSecs() throws METSException {
        return this.amdSecs;
    }

    public AmdSec getAmdSec(String id) throws METSException {
        for (AmdSec am : this.amdSecs) {
            if (!am.getID().equals(id)) continue;
            return am;
        }
        return null;
    }

    public AmdSec addAmdSec(AmdSec amdSec) {
        if (amdSec.getID().equals("")) {
            this.getElement().appendChild(amdSec.getElement());
            this.amdSecs.add(amdSec);
            return null;
        }
        for (AmdSec am : this.amdSecs) {
            if (!am.getID().equals(amdSec.getID())) continue;
            this.getElement().replaceChild(amdSec.getElement(), am.getElement());
            this.amdSecs.add(amdSec);
            return am;
        }
        return null;
    }

    public AmdSec removeAmdSec(String id) {
        Iterator<AmdSec> i = this.amdSecs.iterator();
        while (i.hasNext()) {
            AmdSec am = i.next();
            if (!am.getID().equals(id)) continue;
            this.getElement().removeChild(am.getElement());
            i.remove();
            return am;
        }
        return null;
    }

    public AmdSec removeAmdSec(int pos) {
        for (int i = 0; i < this.amdSecs.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.amdSecs.get(i).getElement());
            return this.amdSecs.remove(i);
        }
        return null;
    }

    public List<BehaviorSec> getBehaviorSecs() throws METSException {
        return this.behaviorSecs;
    }

    public BehaviorSec getBehaviorSec(String id) throws METSException {
        for (BehaviorSec bs : this.behaviorSecs) {
            if (!bs.getID().equals(id)) continue;
            return bs;
        }
        return null;
    }

    public BehaviorSec addBehaviorSec(BehaviorSec behaviorSec) {
        if (behaviorSec.getID().equals("")) {
            this.getElement().appendChild(behaviorSec.getElement());
            this.behaviorSecs.add(behaviorSec);
            return null;
        }
        for (BehaviorSec bs : this.behaviorSecs) {
            if (!bs.getID().equals(behaviorSec.getID())) continue;
            this.getElement().replaceChild(behaviorSec.getElement(), bs.getElement());
            this.behaviorSecs.add(behaviorSec);
            return bs;
        }
        return null;
    }

    public BehaviorSec removeBehaviorSec(String id) {
        Iterator<BehaviorSec> i = this.behaviorSecs.iterator();
        while (i.hasNext()) {
            BehaviorSec bs = i.next();
            if (!bs.getID().equals(id)) continue;
            this.getElement().removeChild(bs.getElement());
            i.remove();
            return bs;
        }
        return null;
    }

    public BehaviorSec removeBehaviorSec(int pos) {
        for (int i = 0; i < this.behaviorSecs.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.behaviorSecs.get(i).getElement());
            return this.behaviorSecs.remove(i);
        }
        return null;
    }

    public StructLink getStructLink() throws METSException {
        return this.structLink;
    }

    public void setStructLink(StructLink sl) {
        if (this.structLink == null) {
            this.getElement().appendChild(sl.getElement());
        } else {
            this.getElement().replaceChild(sl.getElement(), this.structLink.getElement());
        }
        this.structLink = sl;
    }

    public void removeStructLink() {
        if (this.structLink != null) {
            this.getElement().removeChild(this.structLink.getElement());
            this.structLink = null;
        }
    }

    public FileSec getFileSec() throws METSException {
        return this.fileSec;
    }

    public void setFileSec(FileSec fs) {
        if (this.fileSec == null) {
            this.getElement().appendChild(fs.getElement());
        } else {
            this.getElement().replaceChild(fs.getElement(), this.fileSec.getElement());
        }
        this.fileSec = fs;
    }

    public void removeFileSec() {
        if (this.fileSec != null) {
            this.getElement().removeChild(this.fileSec.getElement());
            this.fileSec = null;
        }
    }

    public List<StructMap> getStructMaps() throws METSException {
        return this.structMaps;
    }

    public StructMap getStructMap(String id) throws METSException {
        for (StructMap sm : this.structMaps) {
            if (!sm.getID().equals(id)) continue;
            return sm;
        }
        return null;
    }

    public StructMap addStructMap(StructMap structMap) {
        if (structMap.getID().equals("")) {
            this.getElement().appendChild(structMap.getElement());
            this.structMaps.add(structMap);
            return null;
        }
        for (StructMap sm : this.structMaps) {
            if (!sm.getID().equals(structMap.getID())) continue;
            this.getElement().replaceChild(structMap.getElement(), sm.getElement());
            this.structMaps.add(structMap);
            return sm;
        }
        this.getElement().appendChild(structMap.getElement());
        this.structMaps.add(structMap);
        return null;
    }

    public List<StructMap> getStructMapByType(String type) throws METSException {
        ArrayList<StructMap> al = new ArrayList<StructMap>();
        for (StructMap sm : this.structMaps) {
            if (!sm.getType().equals(type)) continue;
            al.add(sm);
        }
        return al;
    }

    private void initStructures() throws METSException {
        this.initMetsHdr();
        this.initDmdSecs();
        this.initAmdSecs();
        this.initBehaviorSecs();
        this.initStructLink();
        this.initFileSec();
        this.initStructMaps();
    }

    private void initDmdSecs() throws METSException {
        this.dmdSecs = new HashMap();
        NodeList nl = super.getElements("dmdSec");
        for (int i = 0; i < nl.getLength(); ++i) {
            DmdSec dmdSec = new DmdSec(nl.item(i));
            if (dmdSec.getID().length() == 0) {
                throw new METSException("Found DmdSec with null ID");
            }
            this.dmdSecs.put(dmdSec.getID(), dmdSec);
        }
    }

    private void initAmdSecs() throws METSException {
        this.amdSecs = new ArrayList<AmdSec>();
        NodeList nl = super.getElements("amdSec");
        for (int i = 0; i < nl.getLength(); ++i) {
            AmdSec as = new AmdSec(nl.item(i));
            this.amdSecs.add(as);
        }
    }

    private void initBehaviorSecs() throws METSException {
        this.behaviorSecs = new ArrayList<BehaviorSec>();
        List<Node> l = super.getChildElements("behaviorSec");
        for (Node n : l) {
            this.behaviorSecs.add(new BehaviorSec(n));
        }
    }

    private void initStructMaps() throws METSException {
        this.structMaps = new ArrayList<StructMap>();
        NodeList nl = super.getElements("structMap");
        for (int i = 0; i < nl.getLength(); ++i) {
            StructMap sm = new StructMap(nl.item(i));
            this.structMaps.add(sm);
        }
    }

    private void initMetsHdr() throws METSException {
        NodeList nl = super.getElements("metsHdr");
        if (nl.getLength() == 1) {
            this.metsHdr = new MetsHdr(nl.item(0));
        }
    }

    private void initStructLink() throws METSException {
        NodeList nl = super.getElements("structLink");
        if (nl.getLength() == 1) {
            this.structLink = new StructLink(nl.item(0));
        }
    }

    private void initFileSec() throws METSException {
        NodeList nl = super.getElements("fileSec");
        if (nl.getLength() == 1) {
            this.fileSec = new FileSec(nl.item(0));
        }
    }
}

