/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.Agent;
import au.edu.apsr.mtk.base.AltRecordID;
import au.edu.apsr.mtk.base.METSElement;
import au.edu.apsr.mtk.base.METSException;
import au.edu.apsr.mtk.base.MetsDocumentID;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetsHdr
extends METSElement {
    private List<Agent> agents = new ArrayList<Agent>();
    private List<AltRecordID> altRecordIDs = new ArrayList<AltRecordID>();
    private MetsDocumentID metsDocumentID = null;

    public MetsHdr(Node n) throws METSException {
        super(n, "metsHdr");
        this.initStructures();
    }

    public Agent newAgent() throws METSException {
        return new Agent(this.newElement("agent"));
    }

    public AltRecordID newAltRecordID() throws METSException {
        return new AltRecordID(this.newElement("altRecordID"));
    }

    public MetsDocumentID newMetsDocumentID() throws METSException {
        return new MetsDocumentID(this.newElement("metsDocumentID"));
    }

    public String getID() {
        return super.getAttributeValue("ID");
    }

    public void setID(String id) {
        super.setAttributeValue("ID", id);
    }

    public void removeID() {
        super.removeAttribute("ID");
    }

    public void setAdmID(String admID) {
        super.setAttributeValue("ADMID", admID);
    }

    public String getAdmID() {
        return super.getAttributeValue("ADMID");
    }

    public String[] getAdmIDs() {
        return super.getAttributeValue("ADMID").split("\\s+");
    }

    public void removeAdmID() {
        super.removeAttribute("ADMID");
    }

    public String getCreateDate() {
        return super.getAttributeValue("CREATEDATE");
    }

    public void setCreateDate(String createDate) {
        super.setAttributeValue("CREATEDATE", createDate);
    }

    public void removeCreateDate() {
        super.removeAttribute("CREATEDATE");
    }

    public String getLastModDate() {
        return super.getAttributeValue("LASTMODDATE");
    }

    public void setLastModDate(String lastModDate) {
        super.setAttributeValue("LASTMODDATE", lastModDate);
    }

    public void removeLastModDate() {
        super.removeAttribute("LASTMODDATE");
    }

    public String getRecordStatus() {
        return super.getAttributeValue("RECORDSTATUS");
    }

    public void setRecordStatus(String status) {
        super.setAttributeValue("RECORDSTATUS", status);
    }

    public void removeRecordStatus() {
        super.removeAttribute("RECORDSTATUS");
    }

    public List<Agent> getAgents() throws METSException {
        return this.agents;
    }

    public Agent addAgent(Agent agent) {
        if (agent.getID().equals("")) {
            this.getElement().appendChild(agent.getElement());
            this.agents.add(agent);
            return null;
        }
        for (Agent a : this.agents) {
            if (!a.getID().equals(agent.getID())) continue;
            this.getElement().replaceChild(agent.getElement(), a.getElement());
            this.agents.add(agent);
            return a;
        }
        this.getElement().appendChild(agent.getElement());
        this.agents.add(agent);
        return null;
    }

    public Agent removeAgent(String id) {
        Iterator<Agent> i = this.agents.iterator();
        while (i.hasNext()) {
            Agent agent = i.next();
            if (!agent.getID().equals(id)) continue;
            this.getElement().removeChild(agent.getElement());
            i.remove();
            return agent;
        }
        return null;
    }

    public Agent removeAgent(int pos) {
        for (int i = 0; i < this.agents.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.agents.get(i).getElement());
            return this.agents.remove(i);
        }
        return null;
    }

    public List<AltRecordID> getAltRecordIDs() throws METSException {
        return this.altRecordIDs;
    }

    public AltRecordID addAltRecordID(AltRecordID altRecordID) {
        if (altRecordID.getID().equals("")) {
            this.getElement().appendChild(altRecordID.getElement());
            this.altRecordIDs.add(altRecordID);
            return null;
        }
        for (AltRecordID a : this.altRecordIDs) {
            if (!a.getID().equals(altRecordID.getID())) continue;
            this.getElement().replaceChild(altRecordID.getElement(), a.getElement());
            this.altRecordIDs.add(altRecordID);
            return a;
        }
        this.getElement().appendChild(altRecordID.getElement());
        this.altRecordIDs.add(altRecordID);
        return null;
    }

    public AltRecordID removeAltRecordID(String id) {
        Iterator<AltRecordID> i = this.altRecordIDs.iterator();
        while (i.hasNext()) {
            AltRecordID a = i.next();
            if (!a.getID().equals(id)) continue;
            this.getElement().removeChild(a.getElement());
            i.remove();
            return a;
        }
        return null;
    }

    public AltRecordID removeAltRecordID(int pos) {
        for (int i = 0; i < this.altRecordIDs.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.altRecordIDs.get(i).getElement());
            return this.altRecordIDs.remove(i);
        }
        return null;
    }

    public MetsDocumentID addMetsDocumentID(MetsDocumentID metsDocumentID) throws METSException {
        if (this.metsDocumentID != null) {
            MetsDocumentID temp = new MetsDocumentID(this.getElement().replaceChild(metsDocumentID.getElement(), this.metsDocumentID.getElement()));
            this.metsDocumentID = metsDocumentID;
            return temp;
        }
        NodeList nl = super.getElements("metsDocumentID");
        if (nl.getLength() > 0) {
            this.metsDocumentID = new MetsDocumentID(nl.item(0));
            MetsDocumentID temp = new MetsDocumentID(this.getElement().replaceChild(metsDocumentID.getElement(), this.metsDocumentID.getElement()));
            return temp;
        }
        this.getElement().appendChild(metsDocumentID.getElement());
        return null;
    }

    public MetsDocumentID getMetsDocumentID() throws METSException {
        if (this.metsDocumentID != null) {
            return this.metsDocumentID;
        }
        List<Node> l = super.getChildElements("metsDocumentID");
        if (!l.isEmpty()) {
            return new MetsDocumentID(l.get(0));
        }
        return null;
    }

    public void removeMetsDocumentID() {
        if (this.metsDocumentID != null) {
            this.getElement().removeChild(this.metsDocumentID.getElement());
            this.metsDocumentID = null;
        }
    }

    private void initStructures() throws METSException {
        this.initMetsDocumentID();
        this.initAgents();
        this.initAltRecordIDs();
    }

    private void initMetsDocumentID() throws METSException {
        NodeList nl = super.getElements("metsDocumentID");
        if (nl.getLength() > 0) {
            this.metsDocumentID = new MetsDocumentID(nl.item(0));
        }
    }

    private void initAgents() throws METSException {
        this.agents = new ArrayList<Agent>();
        List<Node> l = super.getChildElements("agent");
        for (Node n : l) {
            this.agents.add(new Agent(n));
        }
    }

    private void initAltRecordIDs() throws METSException {
        this.altRecordIDs = new ArrayList<AltRecordID>();
        List<Node> l = super.getChildElements("altRecordID");
        for (Node n : l) {
            this.altRecordIDs.add(new AltRecordID(n));
        }
    }
}

