/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.base;

import au.edu.apsr.mtk.base.Div;
import au.edu.apsr.mtk.base.METSElement;
import au.edu.apsr.mtk.base.METSException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class StructMap
extends METSElement {
    private List<Div> divs = new ArrayList<Div>();

    public StructMap(Node n) throws METSException {
        super(n, "structMap");
    }

    public Div newDiv() throws METSException {
        return new Div(this.newElement("div"));
    }

    public String getID() {
        return super.getAttributeValue("ID");
    }

    public void setID(String id) {
        super.setAttributeValue("ID", id);
    }

    public void removeID() {
        super.removeAttribute("ID");
    }

    public String getType() {
        return super.getAttributeValue("TYPE");
    }

    public void setType(String type) {
        super.setAttributeValue("TYPE", type);
    }

    public void removeType() {
        super.removeAttribute("TYPE");
    }

    public String getLabel() {
        return super.getAttributeValue("LABEL");
    }

    public void setLabel(String label) {
        super.setAttributeValue("LABEL", label);
    }

    public void removeLabel() {
        super.removeAttribute("LABEL");
    }

    public List<Div> getDivs(String type) throws METSException {
        this.getDivs();
        ArrayList<Div> al = new ArrayList<Div>();
        for (Div div : this.divs) {
            if (!div.getType().equals(type)) continue;
            al.add(div);
        }
        return al;
    }

    public Div addDiv(Div div) {
        if (div.getID().equals("")) {
            this.getElement().appendChild(div.getElement());
            this.divs.add(div);
            return null;
        }
        for (Div d : this.divs) {
            if (!d.getID().equals(div.getID())) continue;
            this.getElement().replaceChild(div.getElement(), d.getElement());
            this.divs.add(div);
            return d;
        }
        this.getElement().appendChild(div.getElement());
        this.divs.add(div);
        return null;
    }

    public Div removeDiv(String id) {
        Iterator<Div> i = this.divs.iterator();
        while (i.hasNext()) {
            Div div = i.next();
            if (!div.getID().equals(id)) continue;
            this.getElement().removeChild(div.getElement());
            i.remove();
            return div;
        }
        return null;
    }

    public void removeDivByType(String type, boolean all) {
        Iterator<Div> i = this.divs.iterator();
        while (i.hasNext()) {
            Div div = i.next();
            if (!div.getType().equals(type)) continue;
            this.getElement().removeChild(div.getElement());
            i.remove();
            if (all) continue;
            break;
        }
    }

    public Div removeDiv(int pos) {
        for (int i = 0; i < this.divs.size(); ++i) {
            if (i != pos) continue;
            this.getElement().removeChild(this.divs.get(i).getElement());
            return this.divs.remove(i);
        }
        return null;
    }

    public List<Div> getDivs() throws METSException {
        this.divs = new ArrayList<Div>();
        List<Node> l = super.getChildElements("div");
        for (Node n : l) {
            this.divs.add(new Div(n));
        }
        return this.divs;
    }
}

