/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.example;

import au.edu.apsr.mtk.base.Agent;
import au.edu.apsr.mtk.base.Div;
import au.edu.apsr.mtk.base.FileGrp;
import au.edu.apsr.mtk.base.FileSec;
import au.edu.apsr.mtk.base.METS;
import au.edu.apsr.mtk.base.METSException;
import au.edu.apsr.mtk.base.METSWrapper;
import au.edu.apsr.mtk.base.MetsHdr;
import au.edu.apsr.mtk.base.StructMap;
import au.edu.apsr.mtk.ch.METSReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SampleMETSProcess {
    private static METS mets = null;

    public static void main(String[] args) throws METSException, FileNotFoundException, SAXException, ParserConfigurationException, IOException {
        FileSec fileSec;
        if (args.length != 1) {
            System.out.println("Usage: java au.edu.apsr.mtk.example.SampleMETSProcess <METS file>");
            System.exit(1);
        }
        FileInputStream in = new FileInputStream(args[0]);
        METSReader mr = new METSReader();
        mr.mapToDOM(in);
        METSWrapper mw = new METSWrapper(mr.getMETSDocument());
        mw.validate();
        mets = mw.getMETSObject();
        System.out.println("Package Type of " + mets.getType() + ", using profile: " + mets.getProfile());
        MetsHdr mh = mets.getMetsHdr();
        if (mh != null) {
            System.out.println("Package create date: " + mh.getCreateDate());
            System.out.println("Package last modified date: " + mh.getLastModDate());
            List<Agent> agents = mh.getAgents();
            for (Agent a : agents) {
                System.out.println("Agent " + a.getName() + " has role " + a.getRole());
            }
        }
        if ((fileSec = mets.getFileSec()) != null) {
            List<FileGrp> fgs = fileSec.getFileGrps();
            for (FileGrp fg : fgs) {
                System.out.println("FileGrp of use " + fg.getUse());
            }
        }
        List<StructMap> sms = mets.getStructMaps();
        System.out.println("Package has " + sms.size() + " structMap(s)");
        StructMap sm = sms.get(0);
        SampleMETSProcess.showDivInfo(sm.getDivs());
    }

    private static void showDivInfo(List<Div> divs) throws METSException {
        for (Div div : divs) {
            System.out.println("Div type of " + div.getType() + " with DMDID " + div.getDmdID() + " contains metadata of type " + mets.getDmdSec(div.getDmdID()).getMDType());
            SampleMETSProcess.showDivInfo(div.getDivs());
        }
    }
}

