/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockmockable.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.ModifierAdjustment;
import net.bytebuddy.description.modifier.MethodManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.runtime.extension.AbstractGlobalExtension;
import org.spockframework.runtime.extension.ExtensionException;
import spock.lang.Specification;

public class MockableExtension
extends AbstractGlobalExtension {
    private static final Logger log = LoggerFactory.getLogger(MockableExtension.class);
    private static final String PROPERTIES_FILE = "/META-INF/spock-mockable.properties";
    private static Instrumentation instrumentation;

    private static void installTransformer() {
        MockableExtension.buildAndInstallTransformer(MockableExtension.extractClassesFromPropertyResource(), MockableExtension.extractPackagesFromPropertyResource());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> extractClassesFromPropertyResource() {
        try (InputStream stream = MockableExtension.class.getResourceAsStream(PROPERTIES_FILE);){
            if (stream == null) {
                log.warn("@Mockable did not find the generated properties file '{}'. Either you did not annotate any tests or the build setup is broken.", (Object)PROPERTIES_FILE);
                Set<String> set = Collections.emptySet();
                return set;
            }
            Set<String> set = MockableExtension.readPropertyFromProperties(stream, "classes");
            return set;
        }
        catch (IOException e) {
            throw new ExtensionException("Unable to read properties file '%s' containing mockable class information", (Throwable)e).withArgs(new Object[]{PROPERTIES_FILE});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> extractPackagesFromPropertyResource() {
        try (InputStream stream = MockableExtension.class.getResourceAsStream(PROPERTIES_FILE);){
            if (stream == null) {
                log.warn("@Mockable did not find the generated properties file '{}'. Either you did not annotate any tests or the build setup is broken.", (Object)PROPERTIES_FILE);
                Set<String> set = Collections.emptySet();
                return set;
            }
            Set<String> set = MockableExtension.readPropertyFromProperties(stream, "packages");
            return set;
        }
        catch (IOException e) {
            throw new ExtensionException("Unable to read properties file '%s' containing mockable package information", (Throwable)e).withArgs(new Object[]{PROPERTIES_FILE});
        }
    }

    private static Set<String> readPropertyFromProperties(InputStream stream, String key) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        String property = properties.getProperty(key);
        if ("".equals(property)) {
            return Collections.emptySet();
        }
        return Stream.of(property.split(",")).collect(Collectors.toSet());
    }

    private static void buildAndInstallTransformer(Set<String> classes, Set<String> packages) {
        new AgentBuilder.Default(new ByteBuddy().with(TypeValidation.DISABLED)).ignore((ElementMatcher)ElementMatchers.none()).with((AgentBuilder.InstallationListener)new InstallationListener()).with((AgentBuilder.Listener)new DiscoveryListener()).with((AgentBuilder.InitializationStrategy)AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.TypeStrategy)AgentBuilder.TypeStrategy.Default.REDEFINE).type(typeDescription -> MockableExtension.isTransformable(classes, packages, typeDescription)).transform(MockableExtension::transform).installOn(instrumentation);
    }

    private static boolean isTransformable(Set<String> classes, Set<String> packages, TypeDescription typeDescription) {
        return MockableExtension.isInClasses(classes, typeDescription) || MockableExtension.isTransformableFromPackage(packages, typeDescription);
    }

    private static boolean isTransformableFromPackage(Set<String> packages, TypeDescription typeDescription) {
        return MockableExtension.isInPackages(packages, typeDescription) && MockableExtension.isNotATest(typeDescription) && MockableExtension.isNotASpockMock(typeDescription);
    }

    private static boolean isNotASpockMock(TypeDescription typeDescription) {
        return !typeDescription.getName().contains("$SpockMock$");
    }

    private static boolean isNotATest(TypeDescription typeDescription) {
        return !typeDescription.isAssignableTo(Specification.class);
    }

    private static boolean isInClasses(Set<String> classes, TypeDescription typeDescription) {
        return classes.contains(typeDescription.getName());
    }

    private static boolean isInPackages(Set<String> packages, TypeDescription typeDescription) {
        return packages.stream().anyMatch(packageName -> typeDescription.getName().startsWith(packageName + "."));
    }

    private static DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
        return builder.visit((AsmVisitorWrapper)new ModifierAdjustment().withMethodModifiers((ElementMatcher)ElementMatchers.isPrivate(), new ModifierContributor.ForMethod[]{Visibility.PROTECTED})).visit((AsmVisitorWrapper)new ModifierAdjustment().withMethodModifiers((ElementMatcher)ElementMatchers.isFinal(), new ModifierContributor.ForMethod[]{MethodManifestation.PLAIN})).visit((AsmVisitorWrapper)new ModifierAdjustment().withTypeModifiers((ElementMatcher)ElementMatchers.isFinal(), new ModifierContributor.ForType[]{TypeManifestation.PLAIN}));
    }

    static {
        if (Boolean.parseBoolean(System.getProperty("spock-mockable.disabled", "false"))) {
            log.info("@Mockable transformation is disabled by system property 'spock-mockable.disabled=true'");
        } else {
            log.info("Activating @Mockable transformation");
            instrumentation = ByteBuddyAgent.install();
            MockableExtension.installTransformer();
        }
    }

    private static class DiscoveryListener
    extends AgentBuilder.Listener.Adapter {
        private DiscoveryListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            log.warn("Could not transform class '{}'", (Object)typeName, (Object)throwable);
        }

        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            log.trace("Transformed class {}'", (Object)typeName);
        }
    }

    private static class InstallationListener
    extends AgentBuilder.InstallationListener.Adapter {
        private InstallationListener() {
        }

        public Throwable onError(Instrumentation instrumentation, ResettableClassFileTransformer classFileTransformer, Throwable throwable) {
            throw new ExtensionException("Unable install spock-mockable transformation", throwable);
        }
    }
}

