/*
 * Decompiled with CFR 0.152.
 */
package io.github.joke.spockoutputcapture;

import groovy.lang.GroovyObject;
import io.github.joke.spockoutputcapture.CapturedOutput;
import io.github.joke.spockoutputcapture.CapturedOutputImpl;
import io.github.joke.spockoutputcapture.OutputCapture;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.spockframework.runtime.IStandardStreamsListener;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.StandardStreamsCapturer;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;

public class OutputCaptureExtension
implements IAnnotationDrivenExtension<OutputCapture> {
    private final Map<FieldInfo, CapturedOutputImpl> fieldBuffers = new ConcurrentHashMap<FieldInfo, CapturedOutputImpl>();

    public void visitFieldAnnotation(OutputCapture annotation, FieldInfo field) {
        if (!((Field)field.getReflection()).getType().isAssignableFrom(CapturedOutput.class)) {
            throw new InvalidSpecException("Wrong type for field " + field.getName() + "\n@io.github.joke.spockoutputcapture.OutputCapture can only be placed on fields assignableFrom CapturedOutput.Choose either@io.github.joke.spockoutputcapture.OutputCapture logs@io.github.joke.spockoutputcapture.OutputCapture CapturedOutput logs");
        }
        this.fieldBuffers.put(field, new CapturedOutputImpl());
    }

    public void visitSpec(SpecInfo spec) {
        StandardStreamsCapturer capturer = new StandardStreamsCapturer();
        capturer.addStandardStreamsListener((IStandardStreamsListener)new Listener(this.fieldBuffers));
        spec.addInitializerInterceptor(this::interceptInitializer);
        spec.addSharedInitializerInterceptor(invocation -> this.interceptSharedInitializer(invocation, capturer));
        spec.addCleanupSpecInterceptor(invocation -> this.interceptCleanupSpec(invocation, capturer));
    }

    protected void interceptInitializer(IMethodInvocation invocation) throws Throwable {
        this.fieldBuffers.keySet().stream().filter(fieldInfo -> !fieldInfo.isShared()).forEach(fieldInfo -> this.setNewBufferToField((FieldInfo)fieldInfo, (GroovyObject)invocation.getInstance()));
        invocation.proceed();
    }

    protected void interceptSharedInitializer(IMethodInvocation invocation, StandardStreamsCapturer capturer) throws Throwable {
        capturer.start();
        this.fieldBuffers.keySet().stream().filter(FieldInfo::isShared).forEach(fieldInfo -> this.setNewBufferToField((FieldInfo)fieldInfo, (GroovyObject)invocation.getInstance()));
        invocation.proceed();
    }

    protected void interceptCleanupSpec(IMethodInvocation invocation, StandardStreamsCapturer capturer) throws Throwable {
        capturer.stop();
        invocation.proceed();
    }

    void setNewBufferToField(FieldInfo fieldInfo, GroovyObject instance) {
        CapturedOutputImpl buffer = new CapturedOutputImpl();
        this.fieldBuffers.put(fieldInfo, buffer);
        String fieldName = ((Field)fieldInfo.getReflection()).getName();
        instance.getMetaClass().setProperty((Object)instance, fieldName, (Object)buffer);
    }

    private static class Listener
    implements IStandardStreamsListener {
        private final Map<FieldInfo, CapturedOutputImpl> fieldBuffers;

        public void standardOut(String message) {
            this.fieldBuffers.values().forEach(capturedOutput -> capturedOutput.append(message));
        }

        public void standardErr(String message) {
            this.fieldBuffers.values().forEach(capturedOutput -> capturedOutput.append(message));
        }

        public Listener(Map<FieldInfo, CapturedOutputImpl> fieldBuffers) {
            this.fieldBuffers = fieldBuffers;
        }
    }
}

