/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ErtlFunctionalGroupsFinder {
    public static final ILoggingTool LOGGING_TOOL = LoggingToolFactory.createLoggingTool(ErtlFunctionalGroupsFinder.class);
    public static final String CARBONYL_C_MARKER = "EFGF-Carbonyl-C";
    public static final Set<Integer> NONMETAL_ATOMIC_NUMBERS = Set.of(1, 2, 6, 7, 8, 9, 10, 15, 16, 17, 18, 34, 35, 36, 53, 54, 86);
    private Mode envMode;
    private GraphUtil.EdgeToBondMap bondMapCache;
    private int[][] adjListCache;
    private HashSet<Integer> markedAtomsCache;
    private HashMap<Integer, Boolean> aromaticHeteroAtomIndicesToIsInGroupBoolMapCache;
    private HashMap<IAtom, List<EnvironmentalC>> markedAtomToConnectedEnvCMapCache;

    public ErtlFunctionalGroupsFinder() {
        this(Mode.DEFAULT);
    }

    public ErtlFunctionalGroupsFinder(Mode anEnvMode) {
        Objects.requireNonNull(anEnvMode, "Given environment mode cannot be null.");
        this.envMode = anEnvMode;
    }

    public static ErtlFunctionalGroupsFinder newErtlFunctionalGroupsFinderGeneralizingMode() {
        ErtlFunctionalGroupsFinder tmpEFGF = new ErtlFunctionalGroupsFinder(Mode.DEFAULT);
        return tmpEFGF;
    }

    public static ErtlFunctionalGroupsFinder newErtlFunctionalGroupsFinderFullEnvironmentMode() {
        ErtlFunctionalGroupsFinder tmpEFGF = new ErtlFunctionalGroupsFinder(Mode.NO_GENERALIZATION);
        return tmpEFGF;
    }

    public static ErtlFunctionalGroupsFinder newErtlFunctionalGroupsFinderOnlyMarkedAtomsMode() {
        ErtlFunctionalGroupsFinder tmpEFGF = new ErtlFunctionalGroupsFinder(Mode.ONLY_MARKED_ATOMS);
        return tmpEFGF;
    }

    public void setEnvMode(Mode anEnvMode) {
        Objects.requireNonNull(anEnvMode, "Given environment mode cannot be null.");
        this.envMode = anEnvMode;
    }

    public Mode getEnvMode() {
        return this.envMode;
    }

    public List<IAtomContainer> find(IAtomContainer aMolecule) throws CloneNotSupportedException {
        return this.find(aMolecule, true, false);
    }

    public List<IAtomContainer> find(IAtomContainer aMolecule, boolean aShouldInputBeCloned) throws CloneNotSupportedException {
        return this.find(aMolecule, aShouldInputBeCloned, false);
    }

    public List<IAtomContainer> find(IAtomContainer aMolecule, boolean aShouldInputBeCloned, boolean anAreInputRestrictionsApplied) throws CloneNotSupportedException, IllegalArgumentException {
        this.clearCache();
        IAtomContainer tmpMolecule = aShouldInputBeCloned ? aMolecule.clone() : aMolecule;
        for (IAtom tmpAtom : tmpMolecule.atoms()) {
            if (!Objects.isNull(tmpAtom.getImplicitHydrogenCount())) continue;
            tmpAtom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
        this.bondMapCache = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)tmpMolecule);
        this.adjListCache = GraphUtil.toAdjList((IAtomContainer)tmpMolecule, (GraphUtil.EdgeToBondMap)this.bondMapCache);
        if (anAreInputRestrictionsApplied) {
            this.checkConstraints(tmpMolecule);
        }
        this.markAtoms(tmpMolecule);
        List<IAtomContainer> tmpFunctionalGroupsList = this.extractGroups(tmpMolecule);
        if (this.envMode == Mode.DEFAULT) {
            this.expandGeneralizedEnvironments(tmpFunctionalGroupsList);
        } else if (this.envMode == Mode.NO_GENERALIZATION) {
            this.expandFullEnvironments(tmpFunctionalGroupsList);
        } else if (this.envMode != Mode.ONLY_MARKED_ATOMS) {
            throw new IllegalArgumentException("Unknown mode.");
        }
        this.clearCache();
        return tmpFunctionalGroupsList;
    }

    public static void applyPreprocessing(IAtomContainer aMolecule, Aromaticity anAromaticityModel) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(aMolecule, "Given atom container is 'null'.");
        Objects.requireNonNull(anAromaticityModel, "Given aromaticity model is 'null'.");
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)aMolecule);
            anAromaticityModel.apply(aMolecule);
        }
        catch (Exception anException) {
            LOGGING_TOOL.warn((Object)anException);
            throw new IllegalArgumentException(anException);
        }
    }

    public static Set<Integer> getNonmetalAtomicNumbers() {
        return NONMETAL_ATOMIC_NUMBERS;
    }

    public static boolean isMetalMetalloidOrPseudoAtom(IAtom anAtom) throws NullPointerException {
        Objects.requireNonNull(anAtom, "Given atom is 'null'.");
        if (Objects.isNull(anAtom.getAtomicNumber())) {
            return true;
        }
        return !ErtlFunctionalGroupsFinder.isNonmetal(anAtom);
    }

    public static boolean containsMetalMetalloidOrPseudoAtom(IAtomContainer aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'.");
        for (IAtom tmpAtom : aMolecule.atoms()) {
            boolean tmpIsAtomicNumberInvalid = ErtlFunctionalGroupsFinder.isMetalMetalloidOrPseudoAtom(tmpAtom);
            if (!tmpIsAtomicNumberInvalid) continue;
            return true;
        }
        return false;
    }

    public static boolean isCharged(IAtom anAtom) throws NullPointerException {
        Objects.requireNonNull(anAtom, "Given atom is 'null'.");
        Integer tmpFormalCharge = anAtom.getFormalCharge();
        if (Objects.isNull(tmpFormalCharge)) {
            return false;
        }
        return tmpFormalCharge != 0;
    }

    public static boolean containsChargedAtom(IAtomContainer aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'.");
        for (IAtom tmpAtom : aMolecule.atoms()) {
            boolean tmpIsAtomCharged = ErtlFunctionalGroupsFinder.isCharged(tmpAtom);
            if (!tmpIsAtomCharged) continue;
            return true;
        }
        return false;
    }

    public static boolean isStructureUnconnected(IAtomContainer aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'");
        boolean tmpIsConnected = ConnectivityChecker.isConnected((IAtomContainer)aMolecule);
        return !tmpIsConnected;
    }

    public static boolean isValidInputMoleculeWithRestrictionsTurnedOn(IAtomContainer aMolecule) throws NullPointerException, IllegalArgumentException {
        boolean tmpIsValid;
        Objects.requireNonNull(aMolecule, "Given molecule is null.");
        try {
            tmpIsValid = !ErtlFunctionalGroupsFinder.containsMetalMetalloidOrPseudoAtom(aMolecule) && !ErtlFunctionalGroupsFinder.containsChargedAtom(aMolecule) && !ErtlFunctionalGroupsFinder.isStructureUnconnected(aMolecule);
        }
        catch (Exception anException) {
            LOGGING_TOOL.warn((Object)anException);
            throw new IllegalArgumentException(anException);
        }
        return tmpIsValid;
    }

    private void clearCache() {
        this.bondMapCache = null;
        this.adjListCache = null;
        this.markedAtomsCache = null;
        this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache = null;
        this.markedAtomToConnectedEnvCMapCache = null;
    }

    private void markAtoms(IAtomContainer aMolecule) {
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)"########## Starting search for atoms to mark ... ##########");
        }
        this.markedAtomsCache = new HashSet((int)((float)aMolecule.getAtomCount() / 0.75f + 2.0f), 0.75f);
        this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache = new HashMap((int)((float)aMolecule.getAtomCount() / 0.75f + 2.0f), 0.75f);
        for (int idx = 0; idx < aMolecule.getAtomCount(); ++idx) {
            if (this.markedAtomsCache.contains(idx)) continue;
            IAtom tmpAtom = aMolecule.getAtom(idx);
            if (tmpAtom.isAromatic()) {
                if (!this.isHeteroatom(tmpAtom)) continue;
                this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache.put(idx, false);
                continue;
            }
            int tmpAtomicNr = tmpAtom.getAtomicNumber();
            if (tmpAtomicNr == 6) {
                boolean tmpIsMarked = false;
                int tmpConnectedONSatomsCounter = 0;
                for (int tmpConnectedIdx : this.adjListCache[idx]) {
                    IAtom tmpConnectedAtom = aMolecule.getAtom(tmpConnectedIdx);
                    IBond tmpConnectedBond = this.bondMapCache.get(idx, tmpConnectedIdx);
                    if (!(tmpConnectedAtom.getAtomicNumber() == 1 || tmpConnectedBond.getOrder() != IBond.Order.DOUBLE && tmpConnectedBond.getOrder() != IBond.Order.TRIPLE || tmpConnectedBond.isAromatic())) {
                        if (this.markedAtomsCache.add(tmpConnectedIdx) && ErtlFunctionalGroupsFinder.isDbg()) {
                            LOGGING_TOOL.debug((Object)String.format("Marking Atom #%d (%s) - Met condition %s", tmpConnectedIdx, tmpConnectedAtom.getSymbol(), tmpConnectedAtom.getAtomicNumber() == 6 ? "2.1/2.2" : "1"));
                        }
                        tmpIsMarked = true;
                        if (ErtlFunctionalGroupsFinder.isDbg()) {
                            LOGGING_TOOL.debug((Object)String.format("Marking Atom #%d (%s) - Met condition 2.1/2.2", idx, tmpAtom.getSymbol()));
                        }
                        if (tmpConnectedAtom.getAtomicNumber() != 8 || tmpConnectedBond.getOrder() != IBond.Order.DOUBLE || this.adjListCache[idx].length != 3) break;
                        tmpAtom.setProperty((Object)CARBONYL_C_MARKER, (Object)true);
                        if (!ErtlFunctionalGroupsFinder.isDbg()) break;
                        LOGGING_TOOL.debug((Object)"- was flagged as Carbonly-C");
                        break;
                    }
                    if (tmpConnectedAtom.getAtomicNumber() != 7 && tmpConnectedAtom.getAtomicNumber() != 8 && tmpConnectedAtom.getAtomicNumber() != 16 || tmpConnectedBond.getOrder() != IBond.Order.SINGLE) continue;
                    if (!tmpConnectedAtom.isAromatic()) {
                        this.markedAtomsCache.add(tmpConnectedIdx);
                        if (ErtlFunctionalGroupsFinder.isDbg()) {
                            LOGGING_TOOL.debug((Object)String.format("Marking Atom #%d (%s) - Met condition 1", tmpConnectedIdx, tmpConnectedAtom.getSymbol()));
                        }
                        boolean tmpIsAllSingleBonds = true;
                        int[] nArray = this.adjListCache[tmpConnectedIdx];
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            int tmpConnectedInSphere2Idx = nArray[i];
                            IBond tmpSphere2Bond = this.bondMapCache.get(tmpConnectedIdx, tmpConnectedInSphere2Idx);
                            if (tmpSphere2Bond.getOrder() == IBond.Order.SINGLE) continue;
                            tmpIsAllSingleBonds = false;
                            break;
                        }
                        if (tmpIsAllSingleBonds && ++tmpConnectedONSatomsCounter > 1 && this.adjListCache[idx].length + tmpAtom.getImplicitHydrogenCount() == 4) {
                            tmpIsMarked = true;
                            if (!ErtlFunctionalGroupsFinder.isDbg()) break;
                            LOGGING_TOOL.debug((Object)String.format("Marking Atom #%d (%s) - Met condition 2.3", idx, tmpAtom.getSymbol()));
                            break;
                        }
                    }
                    block3: for (int tmpConnectedInSphere2Idx : this.adjListCache[tmpConnectedIdx]) {
                        IAtom tmpConnectedInSphere2Atom = aMolecule.getAtom(tmpConnectedInSphere2Idx);
                        if (tmpConnectedInSphere2Atom.getAtomicNumber() != 6) continue;
                        for (int tmpConnectedInSphere3Idx : this.adjListCache[tmpConnectedInSphere2Idx]) {
                            IAtom tmpConnectedInSphere3Atom = aMolecule.getAtom(tmpConnectedInSphere3Idx);
                            if (!tmpConnectedInSphere3Atom.equals(tmpAtom)) continue;
                            this.markedAtomsCache.add(tmpConnectedInSphere2Idx);
                            this.markedAtomsCache.add(tmpConnectedInSphere3Idx);
                            if (ErtlFunctionalGroupsFinder.isDbg()) {
                                LOGGING_TOOL.debug((Object)String.format("Marking Atom #%d (%s) - Met condition 2.4", tmpConnectedInSphere2Idx, tmpConnectedInSphere2Atom.getSymbol()));
                                LOGGING_TOOL.debug((Object)String.format("Marking Atom #%d (%s) - Met condition 2.4", tmpConnectedInSphere3Idx, tmpConnectedInSphere3Atom.getSymbol()));
                            }
                            tmpIsMarked = true;
                            if (!ErtlFunctionalGroupsFinder.isDbg()) continue block3;
                            LOGGING_TOOL.debug((Object)String.format("Marking Atom #%d (%s) - Met condition 2.4", idx, tmpAtom.getSymbol()));
                            continue block3;
                        }
                    }
                }
                if (!tmpIsMarked) continue;
                this.markedAtomsCache.add(idx);
                continue;
            }
            if (tmpAtomicNr == 1) {
                if (this.adjListCache[idx].length <= 0) continue;
                IAtom tmpConnectedAtom = aMolecule.getAtom(this.adjListCache[idx][0]);
                if (Objects.isNull(tmpConnectedAtom.getImplicitHydrogenCount())) {
                    tmpConnectedAtom.setImplicitHydrogenCount(Integer.valueOf(1));
                    continue;
                }
                tmpConnectedAtom.setImplicitHydrogenCount(Integer.valueOf(tmpConnectedAtom.getImplicitHydrogenCount() + 1));
                continue;
            }
            if (!this.isHeteroatom(tmpAtom)) continue;
            this.markedAtomsCache.add(idx);
            if (!ErtlFunctionalGroupsFinder.isDbg()) continue;
            LOGGING_TOOL.debug((Object)String.format("Marking Atom #%d (%s) - Met condition 1", idx, tmpAtom.getSymbol()));
        }
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)String.format("########## End of search. Marked %d/%d atoms. ##########", this.markedAtomsCache.size(), aMolecule.getAtomCount()));
        }
    }

    private List<IAtomContainer> extractGroups(IAtomContainer aMolecule) {
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)"########## Starting identification & extraction of functional groups... ##########");
        }
        this.markedAtomToConnectedEnvCMapCache = new HashMap((int)((float)aMolecule.getAtomCount() / 0.75f + 2.0f), 0.75f);
        int[] tmpAtomIdxToFGArray = new int[aMolecule.getAtomCount()];
        Arrays.fill(tmpAtomIdxToFGArray, -1);
        int tmpFunctionalGroupIdx = -1;
        while (!this.markedAtomsCache.isEmpty()) {
            ++tmpFunctionalGroupIdx;
            int tmpBeginIdx = this.markedAtomsCache.iterator().next();
            if (ErtlFunctionalGroupsFinder.isDbg()) {
                LOGGING_TOOL.debug((Object)String.format("Searching new functional group from atom #%d (%s)...", tmpBeginIdx, aMolecule.getAtom(tmpBeginIdx).getSymbol()));
            }
            ArrayDeque<Integer> tmpQueue = new ArrayDeque<Integer>();
            tmpQueue.add(tmpBeginIdx);
            while (!tmpQueue.isEmpty()) {
                int tmpCurrentQueueIdx = (Integer)tmpQueue.poll();
                if (!this.markedAtomsCache.contains(tmpCurrentQueueIdx)) continue;
                IAtom tmpCurrentAtom = aMolecule.getAtom(tmpCurrentQueueIdx);
                if (ErtlFunctionalGroupsFinder.isDbg()) {
                    LOGGING_TOOL.debug((Object)String.format("\tvisiting marked atom: #%d (%s)", tmpCurrentQueueIdx, tmpCurrentAtom.getSymbol()));
                }
                tmpAtomIdxToFGArray[tmpCurrentQueueIdx] = tmpFunctionalGroupIdx;
                this.markedAtomsCache.remove(tmpCurrentQueueIdx);
                ArrayList<EnvironmentalC> tmpCurrentEnvironment = new ArrayList<EnvironmentalC>();
                for (int tmpConnectedIdx : this.adjListCache[tmpCurrentQueueIdx]) {
                    if (this.markedAtomsCache.contains(tmpConnectedIdx)) {
                        tmpQueue.add(tmpConnectedIdx);
                        continue;
                    }
                    if (tmpAtomIdxToFGArray[tmpConnectedIdx] >= 0) continue;
                    IAtom tmpConnectedAtom = aMolecule.getAtom(tmpConnectedIdx);
                    if (this.isHeteroatom(tmpConnectedAtom) && tmpConnectedAtom.isAromatic()) {
                        tmpAtomIdxToFGArray[tmpConnectedIdx] = tmpFunctionalGroupIdx;
                        this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache.put(tmpConnectedIdx, true);
                        if (ErtlFunctionalGroupsFinder.isDbg()) {
                            LOGGING_TOOL.debug((Object)("\t\tadded connected aromatic heteroatom " + tmpConnectedAtom.getSymbol()));
                        }
                    }
                    IBond tmpConnectedBond = this.bondMapCache.get(tmpCurrentQueueIdx, tmpConnectedIdx);
                    if (tmpConnectedAtom.getAtomicNumber() != 6) continue;
                    EnvironmentalCType tmpEnvironmentalCType = tmpConnectedAtom.isAromatic() ? EnvironmentalCType.C_AROMATIC : EnvironmentalCType.C_ALIPHATIC;
                    tmpCurrentEnvironment.add(new EnvironmentalC(tmpEnvironmentalCType, tmpConnectedBond, tmpConnectedBond.getBegin().equals(tmpConnectedAtom) ? 0 : 1));
                }
                this.markedAtomToConnectedEnvCMapCache.put(tmpCurrentAtom, tmpCurrentEnvironment);
                if (!ErtlFunctionalGroupsFinder.isDbg()) continue;
                int tmpCAromCount = 0;
                int tmpCAliphCount = 0;
                for (EnvironmentalC tmpEnvC : tmpCurrentEnvironment) {
                    if (tmpEnvC.getType() == EnvironmentalCType.C_AROMATIC) {
                        ++tmpCAromCount;
                        continue;
                    }
                    if (tmpEnvC.getType() != EnvironmentalCType.C_ALIPHATIC) continue;
                    ++tmpCAliphCount;
                }
                LOGGING_TOOL.debug((Object)String.format("\t\tlogged marked atom's environment: C_ar:%d, C_al:%d (and %d implicit hydrogens)", tmpCAromCount, tmpCAliphCount, tmpCurrentAtom.getImplicitHydrogenCount()));
            }
            if (!ErtlFunctionalGroupsFinder.isDbg()) continue;
            LOGGING_TOOL.debug((Object)"\tsearch completed.");
        }
        for (int tmpAtomIdx : this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache.keySet()) {
            if (this.aromaticHeteroAtomIndicesToIsInGroupBoolMapCache.get(tmpAtomIdx).booleanValue()) continue;
            tmpAtomIdxToFGArray[tmpAtomIdx] = ++tmpFunctionalGroupIdx;
            if (!ErtlFunctionalGroupsFinder.isDbg()) continue;
            LOGGING_TOOL.debug((Object)("Created FG for lone aromatic heteroatom: " + aMolecule.getAtom(tmpAtomIdx).getSymbol()));
        }
        List<IAtomContainer> tmpFunctionalGroupsList = this.partitionIntoGroups(aMolecule, tmpAtomIdxToFGArray, tmpFunctionalGroupIdx + 1);
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)String.format("########## Found & extracted %d functional groups. ##########", tmpFunctionalGroupIdx + 1));
        }
        return tmpFunctionalGroupsList;
    }

    private void expandGeneralizedEnvironments(List<IAtomContainer> aFunctionalGroupsList) {
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)"########## Starting generalization of functional groups... ##########");
        }
        for (IAtomContainer tmpFunctionalGroup : aFunctionalGroupsList) {
            int tmpAtomCount = tmpFunctionalGroup.getAtomCount();
            if (ErtlFunctionalGroupsFinder.isDbg()) {
                LOGGING_TOOL.debug((Object)String.format("Generalizing functional group (%d atoms)...", tmpAtomCount));
            }
            if (tmpFunctionalGroup.getAtomCount() == 1) {
                IAtom tmpAtom = tmpFunctionalGroup.getAtom(0);
                List<EnvironmentalC> tmpEnvironment = this.markedAtomToConnectedEnvCMapCache.get(tmpAtom);
                if (!Objects.isNull(tmpEnvironment)) {
                    int tmpEnvCCount = tmpEnvironment.size();
                    if (tmpAtom.getAtomicNumber() == 8 && tmpEnvCCount == 1 || tmpAtom.getAtomicNumber() == 7 && tmpEnvCCount == 1) {
                        if (ErtlFunctionalGroupsFinder.isDbg()) {
                            LOGGING_TOOL.debug((Object)String.format("\t- found single atomic %s FG with one env. C. Expanding environment...", tmpAtom.getSymbol()));
                        }
                        this.expandEnvironment(tmpAtom, tmpFunctionalGroup);
                        int tmpAtomImplicitHydrogenCount = tmpAtom.getImplicitHydrogenCount();
                        if (tmpAtomImplicitHydrogenCount == 0) continue;
                        if (ErtlFunctionalGroupsFinder.isDbg()) {
                            LOGGING_TOOL.debug((Object)String.format("\t- adding %d hydrogens...", tmpAtomImplicitHydrogenCount));
                        }
                        this.addHydrogens(tmpAtom, tmpAtomImplicitHydrogenCount, tmpFunctionalGroup);
                        tmpAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                        continue;
                    }
                    if (tmpAtom.getAtomicNumber() == 7 && tmpEnvCCount == 2 || tmpAtom.getAtomicNumber() == 16 && tmpEnvCCount == 1) {
                        int tmpAtomImplicitHydrogenCount;
                        if (ErtlFunctionalGroupsFinder.isDbg()) {
                            LOGGING_TOOL.debug((Object)"\t- found sec. amine or simple thiol");
                        }
                        if ((tmpAtomImplicitHydrogenCount = tmpAtom.getImplicitHydrogenCount().intValue()) != 0) {
                            if (ErtlFunctionalGroupsFinder.isDbg()) {
                                LOGGING_TOOL.debug((Object)String.format("\t- adding %d hydrogens...", tmpAtomImplicitHydrogenCount));
                            }
                            this.addHydrogens(tmpAtom, tmpAtomImplicitHydrogenCount, tmpFunctionalGroup);
                            tmpAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                        }
                        if (ErtlFunctionalGroupsFinder.isDbg()) {
                            LOGGING_TOOL.debug((Object)"\t- expanding environment...");
                        }
                        this.expandEnvironmentGeneralized(tmpAtom, tmpFunctionalGroup);
                        continue;
                    }
                } else if (this.isHeteroatom(tmpAtom)) {
                    int tmpRAtomCount = tmpAtom.getValency();
                    Integer tmpAtomImplicitHydrogenCount = tmpAtom.getImplicitHydrogenCount();
                    if (tmpAtomImplicitHydrogenCount != null && tmpAtomImplicitHydrogenCount != 0) {
                        tmpAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                    }
                    String tmpAtomTypeName = tmpAtom.getAtomTypeName();
                    if (ErtlFunctionalGroupsFinder.isDbg()) {
                        LOGGING_TOOL.debug((Object)String.format("\t- found single aromatic heteroatom (%s, Atomtype %s). Adding %d R-Atoms...", tmpAtom.getSymbol(), tmpAtomTypeName, tmpRAtomCount));
                    }
                    this.addRAtoms(tmpAtom, tmpRAtomCount, tmpFunctionalGroup);
                    continue;
                }
            }
            ArrayList tmpFunctionalGroupAtoms = new ArrayList(tmpFunctionalGroup.getAtomCount());
            tmpFunctionalGroup.atoms().forEach(tmpFunctionalGroupAtoms::add);
            for (IAtom tmpFunctionalGroupAtom : tmpFunctionalGroupAtoms) {
                List<EnvironmentalC> tmpFGenvCs = this.markedAtomToConnectedEnvCMapCache.get(tmpFunctionalGroupAtom);
                if (tmpFGenvCs == null) {
                    if (tmpFunctionalGroupAtom.getImplicitHydrogenCount() != 0) {
                        tmpFunctionalGroupAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                    }
                    int tmpRAtomCount = tmpFunctionalGroupAtom.getValency() - 1;
                    if (ErtlFunctionalGroupsFinder.isDbg()) {
                        LOGGING_TOOL.debug((Object)String.format("\t- found connected aromatic heteroatom (%s). Adding %d R-Atoms...", tmpFunctionalGroupAtom.getSymbol(), tmpRAtomCount));
                    }
                    this.addRAtoms(tmpFunctionalGroupAtom, tmpRAtomCount, tmpFunctionalGroup);
                }
                if (tmpFunctionalGroupAtom.getAtomicNumber() == 6) {
                    if (Objects.isNull(tmpFunctionalGroupAtom.getProperty((Object)CARBONYL_C_MARKER))) {
                        if (tmpFunctionalGroupAtom.getImplicitHydrogenCount() != 0) {
                            tmpFunctionalGroupAtom.setImplicitHydrogenCount(Integer.valueOf(0));
                        }
                        if (!ErtlFunctionalGroupsFinder.isDbg()) continue;
                        LOGGING_TOOL.debug((Object)"\t- ignoring environment for marked carbon atom");
                        continue;
                    }
                    if (ErtlFunctionalGroupsFinder.isDbg()) {
                        LOGGING_TOOL.debug((Object)"\t- found carbonyl-carbon. Expanding environment...");
                    }
                    this.expandEnvironmentGeneralized(tmpFunctionalGroupAtom, tmpFunctionalGroup);
                    continue;
                }
                if (ErtlFunctionalGroupsFinder.isDbg()) {
                    LOGGING_TOOL.debug((Object)String.format("\t- found heteroatom (%s). Expanding environment...", tmpFunctionalGroupAtom.getSymbol()));
                }
                this.expandEnvironmentGeneralized(tmpFunctionalGroupAtom, tmpFunctionalGroup);
            }
        }
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)"########## Generalization of functional groups completed. ##########");
        }
    }

    private void expandFullEnvironments(List<IAtomContainer> aFunctionalGroupsList) {
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)"########## Starting expansion of full environments for functional groups... ##########");
        }
        for (IAtomContainer tmpFunctionalGroup : aFunctionalGroupsList) {
            int tmpAtomCount = tmpFunctionalGroup.getAtomCount();
            if (ErtlFunctionalGroupsFinder.isDbg()) {
                LOGGING_TOOL.debug((Object)String.format("Expanding environment on functional group (%d atoms)...", tmpAtomCount));
            }
            for (int i = 0; i < tmpAtomCount; ++i) {
                IAtom tmpFunctionalGroupAtom = tmpFunctionalGroup.getAtom(i);
                if (ErtlFunctionalGroupsFinder.isDbg()) {
                    LOGGING_TOOL.debug((Object)String.format(" - Atom #%d   - Expanding environment...", i));
                }
                this.expandEnvironment(tmpFunctionalGroupAtom, tmpFunctionalGroup);
                int tmpImplicitHydrogenCount = tmpFunctionalGroupAtom.getImplicitHydrogenCount();
                if (tmpImplicitHydrogenCount == 0) continue;
                if (ErtlFunctionalGroupsFinder.isDbg()) {
                    LOGGING_TOOL.debug((Object)String.format("\t- adding %d hydrogens...", tmpImplicitHydrogenCount));
                }
                this.addHydrogens(tmpFunctionalGroupAtom, tmpImplicitHydrogenCount, tmpFunctionalGroup);
                tmpFunctionalGroupAtom.setImplicitHydrogenCount(Integer.valueOf(0));
            }
        }
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)"########## Expansion of full environments for functional groups completed. ##########");
        }
    }

    private void expandEnvironment(IAtom aFunctionalGroupAtom, IAtomContainer aFunctionalGroup) {
        List<EnvironmentalC> tmpEnvCAtomsList = this.markedAtomToConnectedEnvCMapCache.get(aFunctionalGroupAtom);
        if (Objects.isNull(tmpEnvCAtomsList) || tmpEnvCAtomsList.isEmpty()) {
            if (ErtlFunctionalGroupsFinder.isDbg()) {
                LOGGING_TOOL.debug((Object)"\t\tfound no environment to expand.");
            }
            return;
        }
        int tmpAromaticCAtomCount = 0;
        int tmpAliphaticCAtomCount = 0;
        for (EnvironmentalC tmpEnvCAtom : tmpEnvCAtomsList) {
            IAtom tmpCAtom = (IAtom)aFunctionalGroupAtom.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
            tmpCAtom.setAtomTypeName("C");
            tmpCAtom.setImplicitHydrogenCount(Integer.valueOf(0));
            if (tmpEnvCAtom.getType() == EnvironmentalCType.C_AROMATIC) {
                tmpCAtom.setIsAromatic(true);
                ++tmpAromaticCAtomCount;
            } else {
                ++tmpAliphaticCAtomCount;
            }
            IBond tmpBond = tmpEnvCAtom.createBond(aFunctionalGroupAtom, tmpCAtom);
            aFunctionalGroup.addAtom(tmpCAtom);
            aFunctionalGroup.addBond(tmpBond);
        }
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)String.format("\t\texpanded environment: %dx C_ar and %dx C_al", tmpAromaticCAtomCount, tmpAliphaticCAtomCount));
        }
    }

    private void expandEnvironmentGeneralized(IAtom aFunctionalGroupAtom, IAtomContainer aFunctionalGroup) {
        int tmpRAtomCount;
        List<EnvironmentalC> tmpEnvironment = this.markedAtomToConnectedEnvCMapCache.get(aFunctionalGroupAtom);
        if (Objects.isNull(tmpEnvironment)) {
            if (ErtlFunctionalGroupsFinder.isDbg()) {
                LOGGING_TOOL.debug((Object)"\t\tfound no environment to expand.");
            }
            return;
        }
        int tmpRAtomsForCCount = tmpRAtomCount = tmpEnvironment.size();
        if (aFunctionalGroupAtom.getAtomicNumber() == 8 && aFunctionalGroupAtom.getImplicitHydrogenCount() == 1) {
            this.addHydrogens(aFunctionalGroupAtom, 1, aFunctionalGroup);
            aFunctionalGroupAtom.setImplicitHydrogenCount(Integer.valueOf(0));
            if (ErtlFunctionalGroupsFinder.isDbg()) {
                LOGGING_TOOL.debug((Object)"\t\texpanded hydrogen on connected OH-Group");
            }
        } else if (this.isHeteroatom(aFunctionalGroupAtom)) {
            tmpRAtomCount += aFunctionalGroupAtom.getImplicitHydrogenCount().intValue();
        }
        this.addRAtoms(aFunctionalGroupAtom, tmpRAtomCount, aFunctionalGroup);
        if (aFunctionalGroupAtom.getImplicitHydrogenCount() != 0) {
            aFunctionalGroupAtom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
        if (ErtlFunctionalGroupsFinder.isDbg()) {
            LOGGING_TOOL.debug((Object)String.format("\t\texpanded environment: %dx R-atom (incl. %d for H replacement)", tmpRAtomCount, tmpRAtomCount - tmpRAtomsForCCount));
        }
    }

    private boolean isHeteroatom(IAtom anAtom) {
        Integer tmpAtomicNr = anAtom.getAtomicNumber();
        return tmpAtomicNr != 1 && tmpAtomicNr != 6 && tmpAtomicNr != 0 && tmpAtomicNr != null && !(anAtom instanceof PseudoAtom);
    }

    private static boolean isNonmetal(IAtom anAtom) {
        Integer tmpAtomicNumber = anAtom.getAtomicNumber();
        if (Objects.isNull(tmpAtomicNumber)) {
            return false;
        }
        int tmpAtomicNumberInt = tmpAtomicNumber;
        return NONMETAL_ATOMIC_NUMBERS.contains(tmpAtomicNumberInt);
    }

    private void addHydrogens(IAtom anAtom, int aNrOfHydrogenAtoms, IAtomContainer aMolecule) {
        for (int i = 0; i < aNrOfHydrogenAtoms; ++i) {
            IAtom tmpHydrogenAtom = (IAtom)anAtom.getBuilder().newInstance(IAtom.class, new Object[]{"H"});
            tmpHydrogenAtom.setAtomTypeName("H");
            tmpHydrogenAtom.setImplicitHydrogenCount(Integer.valueOf(0));
            aMolecule.addAtom(tmpHydrogenAtom);
            aMolecule.addBond((IBond)anAtom.getBuilder().newInstance(IBond.class, new Object[]{anAtom, tmpHydrogenAtom, IBond.Order.SINGLE}));
        }
    }

    private void addRAtoms(IAtom anAtom, int aNrOfRAtoms, IAtomContainer aMolecule) {
        for (int i = 0; i < aNrOfRAtoms; ++i) {
            IPseudoAtom tmpRAtom = (IPseudoAtom)anAtom.getBuilder().newInstance(IPseudoAtom.class, new Object[]{"R"});
            tmpRAtom.setAttachPointNum(1);
            tmpRAtom.setImplicitHydrogenCount(Integer.valueOf(0));
            aMolecule.addAtom((IAtom)tmpRAtom);
            aMolecule.addBond((IBond)anAtom.getBuilder().newInstance(IBond.class, new Object[]{anAtom, tmpRAtom, IBond.Order.SINGLE}));
        }
    }

    private List<IAtomContainer> partitionIntoGroups(IAtomContainer aSourceContainer, int[] anAtomIdxToFGIdxMap, int aFunctionalGroupCount) {
        IAtomContainer tmpFunctionalGroup;
        ArrayList<IAtomContainer> tmpFunctionalGroups = new ArrayList<IAtomContainer>(aFunctionalGroupCount);
        for (int i = 0; i < aFunctionalGroupCount; ++i) {
            tmpFunctionalGroups.add((IAtomContainer)aSourceContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]));
        }
        HashMap<IAtom, IAtomContainer> tmpAtomtoFGMap = new HashMap<IAtom, IAtomContainer>((int)((float)aSourceContainer.getAtomCount() / 0.75f + 2.0f), 0.75f);
        for (int tmpAtomIdx = 0; tmpAtomIdx < aSourceContainer.getAtomCount(); ++tmpAtomIdx) {
            int tmpFGroupIdx = anAtomIdxToFGIdxMap[tmpAtomIdx];
            if (tmpFGroupIdx == -1) continue;
            IAtom tmpAtom = aSourceContainer.getAtom(tmpAtomIdx);
            IAtomContainer tmpPartitionedFunctionalGroup = (IAtomContainer)tmpFunctionalGroups.get(tmpFGroupIdx);
            tmpPartitionedFunctionalGroup.addAtom(tmpAtom);
            tmpAtomtoFGMap.put(tmpAtom, tmpPartitionedFunctionalGroup);
        }
        for (IBond tmpBond : aSourceContainer.bonds()) {
            IAtomContainer tmpFGofBeginAtom = (IAtomContainer)tmpAtomtoFGMap.get(tmpBond.getBegin());
            IAtomContainer tmpFGofEndAtom = (IAtomContainer)tmpAtomtoFGMap.get(tmpBond.getEnd());
            if (Objects.isNull(tmpFGofBeginAtom) || Objects.isNull(tmpFGofEndAtom) || tmpFGofBeginAtom != tmpFGofEndAtom) continue;
            tmpFGofBeginAtom.addBond(tmpBond);
        }
        for (ISingleElectron tmpSingleElectron : aSourceContainer.singleElectrons()) {
            tmpFunctionalGroup = (IAtomContainer)tmpAtomtoFGMap.get(tmpSingleElectron.getAtom());
            if (Objects.isNull(tmpFunctionalGroup)) continue;
            tmpFunctionalGroup.addSingleElectron(tmpSingleElectron);
        }
        for (ILonePair tmpLonePair : aSourceContainer.lonePairs()) {
            tmpFunctionalGroup = (IAtomContainer)tmpAtomtoFGMap.get(tmpLonePair.getAtom());
            if (Objects.isNull(tmpFunctionalGroup)) continue;
            tmpFunctionalGroup.addLonePair(tmpLonePair);
        }
        return tmpFunctionalGroups;
    }

    private void checkConstraints(IAtomContainer aMolecule) throws IllegalArgumentException {
        for (IAtom tmpAtom : aMolecule.atoms()) {
            if (ErtlFunctionalGroupsFinder.isCharged(tmpAtom)) {
                throw new IllegalArgumentException("Input molecule must not contain any charges.");
            }
            if (ErtlFunctionalGroupsFinder.isNonmetal(tmpAtom)) continue;
            throw new IllegalArgumentException("Input molecule must not contain metal, metalloid, or pseudo atoms.");
        }
        Objects.requireNonNull(this.adjListCache, "Adjacency list cache must already be set-up for this check!");
        ConnectedComponents tmpConnectedComponents = new ConnectedComponents(this.adjListCache);
        if (tmpConnectedComponents.nComponents() > 1) {
            throw new IllegalArgumentException("Input molecule must consist of only a single connected structure.");
        }
    }

    private static boolean isDbg() {
        return LOGGING_TOOL.isDebugEnabled();
    }

    private class EnvironmentalC {
        private final EnvironmentalCType type;
        private final int bondIndex;
        private final IBond.Order bondOrder;
        private final IBond.Stereo bondStereo;
        private final boolean[] bondFlags;

        public EnvironmentalC(EnvironmentalCType aType, IBond aConnectingBond, int anIndexInBond) {
            this.type = aType;
            this.bondIndex = anIndexInBond;
            this.bondOrder = aConnectingBond.getOrder();
            this.bondStereo = aConnectingBond.getStereo();
            this.bondFlags = aConnectingBond.getFlags();
        }

        public EnvironmentalCType getType() {
            return this.type;
        }

        public IBond createBond(IAtom aTargetAtom, IAtom anEnvCAtom) {
            IBond tmpBond = (IBond)aTargetAtom.getBuilder().newInstance(IBond.class, new Object[0]);
            if (this.bondIndex == 0) {
                tmpBond.setAtoms(new IAtom[]{anEnvCAtom, aTargetAtom});
            } else {
                tmpBond.setAtoms(new IAtom[]{aTargetAtom, anEnvCAtom});
            }
            tmpBond.setOrder(this.bondOrder);
            tmpBond.setStereo(this.bondStereo);
            tmpBond.setFlags(this.bondFlags);
            return tmpBond;
        }
    }

    private static enum EnvironmentalCType {
        C_AROMATIC,
        C_ALIPHATIC;

    }

    public static enum Mode {
        DEFAULT,
        NO_GENERALIZATION,
        ONLY_MARKED_ATOMS;

    }
}

