/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.hash.AtomEncoder;
import org.openscience.cdk.hash.BasicAtomEncoder;
import org.openscience.cdk.hash.HashGeneratorMaker;
import org.openscience.cdk.hash.MoleculeHashGenerator;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ErtlFunctionalGroupsFinder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class ErtlFunctionalGroupsFinderUtility {
    private static final Logger LOGGER = Logger.getLogger(ErtlFunctionalGroupsFinderUtility.class.getName());

    private ErtlFunctionalGroupsFinderUtility() {
    }

    public static MoleculeHashGenerator getFunctionalGroupHashGenerator() {
        MoleculeHashGenerator tmpHashGenerator = new HashGeneratorMaker().depth(8).elemental().encode((AtomEncoder)BasicAtomEncoder.BOND_ORDER_SUM).encode((AtomEncoder)CustomAtomEncoder.AROMATICITY).molecular();
        return tmpHashGenerator;
    }

    public static boolean isAtomOrBondCountZero(IAtomContainer aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'.");
        int tmpAtomCount = aMolecule.getAtomCount();
        int tmpBondCount = aMolecule.getBondCount();
        return tmpAtomCount == 0 || tmpBondCount == 0;
    }

    public static boolean shouldBeFiltered(IAtomContainer aMolecule) throws NullPointerException {
        return ErtlFunctionalGroupsFinderUtility.shouldBeFiltered(aMolecule, true);
    }

    public static boolean shouldBeFiltered(IAtomContainer aMolecule, boolean areSingleAtomsFiltered) throws NullPointerException {
        boolean tmpShouldBeFiltered;
        Objects.requireNonNull(aMolecule, "Given molecule is null.");
        try {
            tmpShouldBeFiltered = areSingleAtomsFiltered ? ErtlFunctionalGroupsFinder.containsMetalMetalloidOrPseudoAtom(aMolecule) || ErtlFunctionalGroupsFinderUtility.isAtomOrBondCountZero(aMolecule) : ErtlFunctionalGroupsFinder.containsMetalMetalloidOrPseudoAtom(aMolecule) || aMolecule.getAtomCount() == 0;
        }
        catch (Exception anException) {
            LOGGER.log(Level.WARNING, anException.toString() + " Molecule ID: " + ErtlFunctionalGroupsFinderUtility.getIDForLogging(aMolecule), anException);
            tmpShouldBeFiltered = true;
        }
        return tmpShouldBeFiltered;
    }

    public static boolean shouldBePreprocessed(IAtomContainer aMolecule) throws NullPointerException {
        boolean tmpNeedsPreprocessing;
        Objects.requireNonNull(aMolecule, "Given molecule is null.");
        try {
            tmpNeedsPreprocessing = ErtlFunctionalGroupsFinder.containsChargedAtom(aMolecule) || ErtlFunctionalGroupsFinder.isStructureUnconnected(aMolecule);
        }
        catch (Exception anException) {
            LOGGER.log(Level.WARNING, anException.toString() + " Molecule ID: " + ErtlFunctionalGroupsFinderUtility.getIDForLogging(aMolecule), anException);
            throw new NullPointerException("An unknown error occurred.");
        }
        return tmpNeedsPreprocessing;
    }

    public static boolean isValidArgumentForFindMethod(IAtomContainer aMolecule) throws NullPointerException {
        return ErtlFunctionalGroupsFinderUtility.isValidArgumentForFindMethod(aMolecule, true);
    }

    public static boolean isValidArgumentForFindMethod(IAtomContainer aMolecule, boolean areSingleAtomsFiltered) throws NullPointerException {
        boolean tmpIsValid;
        Objects.requireNonNull(aMolecule, "Given molecule is null.");
        try {
            tmpIsValid = areSingleAtomsFiltered ? !ErtlFunctionalGroupsFinder.containsMetalMetalloidOrPseudoAtom(aMolecule) && !ErtlFunctionalGroupsFinderUtility.isAtomOrBondCountZero(aMolecule) && !ErtlFunctionalGroupsFinder.containsChargedAtom(aMolecule) && !ErtlFunctionalGroupsFinder.isStructureUnconnected(aMolecule) : !ErtlFunctionalGroupsFinder.containsMetalMetalloidOrPseudoAtom(aMolecule) && aMolecule.getAtomCount() != 0 && !ErtlFunctionalGroupsFinder.containsChargedAtom(aMolecule) && !ErtlFunctionalGroupsFinder.isStructureUnconnected(aMolecule);
        }
        catch (Exception anException) {
            LOGGER.log(Level.SEVERE, anException.toString() + " Molecule ID: " + ErtlFunctionalGroupsFinderUtility.getIDForLogging(aMolecule), anException);
            tmpIsValid = false;
        }
        return tmpIsValid;
    }

    public static IAtomContainer selectBiggestUnconnectedComponent(IAtomContainer aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecules is 'null'.");
        IAtomContainerSet tmpUnconnectedComponentsSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)aMolecule);
        IAtomContainer tmpBiggestComponent = null;
        for (IAtomContainer tmpComponent : tmpUnconnectedComponentsSet.atomContainers()) {
            if (!Objects.isNull(tmpBiggestComponent) && tmpBiggestComponent.getAtomCount() >= tmpComponent.getAtomCount()) continue;
            tmpBiggestComponent = tmpComponent;
        }
        Objects.requireNonNull(tmpBiggestComponent, "The resulting biggest component is 'null'.");
        tmpBiggestComponent.setProperties(aMolecule.getProperties());
        return tmpBiggestComponent;
    }

    public static void neutralizeCharges(IAtomContainer aMolecule) throws NullPointerException, CDKException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'.");
        Iterable tmpAtoms = aMolecule.atoms();
        for (IAtom tmpAtom : tmpAtoms) {
            ErtlFunctionalGroupsFinderUtility.neutralizeCharges(tmpAtom, aMolecule);
        }
    }

    public static void neutralizeCharges(IAtom anAtom, IAtomContainer aParentMolecule) throws NullPointerException, CDKException {
        Objects.requireNonNull(anAtom, "Given atom is 'null'.");
        Objects.requireNonNull(aParentMolecule, "Given parent molecule is 'null'.");
        boolean tmpIsAtomInMolecule = aParentMolecule.contains(anAtom);
        if (!tmpIsAtomInMolecule) {
            throw new CDKException("Given atom is not part of the given atom container.");
        }
        Integer tmpFormalChargeObject = anAtom.getFormalCharge();
        if (Objects.isNull(tmpFormalChargeObject)) {
            return;
        }
        int tmpFormalCharge = tmpFormalChargeObject;
        if (tmpFormalCharge != 0) {
            anAtom.setFormalCharge(Integer.valueOf(0));
            IChemObjectBuilder tmpBuilder = aParentMolecule.getBuilder();
            if (Objects.isNull(tmpBuilder)) {
                throw new CDKException("Builder of the given atom container is 'null'.");
            }
            CDKHydrogenAdder tmpHAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)tmpBuilder);
            CDKAtomTypeMatcher tmpMatcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)tmpBuilder);
            IAtomType tmpMatchedType = tmpMatcher.findMatchingAtomType(aParentMolecule, anAtom);
            if (Objects.isNull(tmpMatchedType)) {
                throw new CDKException("Matched atom type is 'null'.");
            }
            AtomTypeManipulator.configure((IAtom)anAtom, (IAtomType)tmpMatchedType);
            tmpHAdder.addImplicitHydrogens(aParentMolecule, anAtom);
        }
    }

    public static void perceiveAtomTypesAndConfigureAtoms(IAtomContainer aMolecule) throws NullPointerException, CDKException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'.");
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)aMolecule);
    }

    public static boolean applyAromaticityDetection(IAtomContainer aMolecule, Aromaticity anAromaticityModel) throws NullPointerException, CDKException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'.");
        Objects.requireNonNull(anAromaticityModel, "Given aromaticity model is 'null'.");
        boolean tmpIsAromatic = false;
        try {
            tmpIsAromatic = anAromaticityModel.apply(aMolecule);
        }
        catch (Intractable anIntractableException) {
            LOGGER.log(Level.SEVERE, anIntractableException.toString() + " Molecule ID: " + ErtlFunctionalGroupsFinderUtility.getIDForLogging(aMolecule), anIntractableException);
            String tmpMessage = anIntractableException.getMessage();
            Throwable tmpCause = anIntractableException.getCause();
            throw new CDKException(tmpMessage, tmpCause);
        }
        return tmpIsAromatic;
    }

    public static IAtomContainer applyFiltersAndPreprocessing(IAtomContainer aMolecule, Aromaticity anAromaticityModel) throws NullPointerException {
        return ErtlFunctionalGroupsFinderUtility.applyFiltersAndPreprocessing(aMolecule, anAromaticityModel, true);
    }

    public static IAtomContainer applyFiltersAndPreprocessing(IAtomContainer aMolecule, Aromaticity anAromaticityModel, boolean areSingleAtomsFiltered) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given atom container is 'null'.");
        Objects.requireNonNull(anAromaticityModel, "Given aromaticity model is 'null'.");
        try {
            boolean tmpContainsInvalidAtoms;
            boolean tmpIsUnconnected;
            ErtlFunctionalGroupsFinderUtility.perceiveAtomTypesAndConfigureAtoms(aMolecule);
            if (areSingleAtomsFiltered) {
                boolean tmpIsAtomOrBondCountZero = ErtlFunctionalGroupsFinderUtility.isAtomOrBondCountZero(aMolecule);
                if (tmpIsAtomOrBondCountZero) {
                    return null;
                }
            } else {
                boolean tmpIsAtomCountZero;
                boolean bl = tmpIsAtomCountZero = aMolecule.getAtomCount() == 0;
                if (tmpIsAtomCountZero) {
                    return null;
                }
            }
            if (tmpIsUnconnected = ErtlFunctionalGroupsFinder.isStructureUnconnected(aMolecule)) {
                aMolecule = ErtlFunctionalGroupsFinderUtility.selectBiggestUnconnectedComponent(aMolecule);
            }
            if (tmpContainsInvalidAtoms = ErtlFunctionalGroupsFinder.containsMetalMetalloidOrPseudoAtom(aMolecule)) {
                return null;
            }
            boolean tmpIsCharged = ErtlFunctionalGroupsFinder.containsChargedAtom(aMolecule);
            if (tmpIsCharged) {
                ErtlFunctionalGroupsFinderUtility.neutralizeCharges(aMolecule);
            }
            ErtlFunctionalGroupsFinderUtility.applyAromaticityDetection(aMolecule, anAromaticityModel);
        }
        catch (Exception anException) {
            LOGGER.log(Level.SEVERE, anException.toString() + " Molecule ID: " + ErtlFunctionalGroupsFinderUtility.getIDForLogging(aMolecule), anException);
            return null;
        }
        return aMolecule;
    }

    public static void restoreOriginalEnvironmentalCarbons(List<IAtomContainer> aListOfFunctionalGroups, IAtomContainer aMolecule, boolean aConvertExplicitHydrogens, boolean aFillEmptyValences, IChemObjectBuilder aBuilder) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(aListOfFunctionalGroups, "Given list of functional groups is null.");
        Objects.requireNonNull(aMolecule, "Given molecule is null.");
        Objects.requireNonNull(aBuilder, "Given chem object builder is null.");
        if (aListOfFunctionalGroups.isEmpty()) {
            return;
        }
        if (aMolecule.isEmpty()) {
            throw new IllegalArgumentException("Given molecule is empty.");
        }
        for (IAtomContainer tmpFG : aListOfFunctionalGroups) {
            boolean tmpIsFGofMolecule = false;
            for (Object tmpAtom : tmpFG.atoms()) {
                if (!aMolecule.contains((IAtom)tmpAtom)) continue;
                tmpIsFGofMolecule = true;
            }
            if (tmpIsFGofMolecule) continue;
            throw new IllegalArgumentException("At least one functional group has been given that does not originate from the given molecule or the molecule has been cloned for the extraction of functional groups.");
        }
        CDKHydrogenAdder tmpHadder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)aBuilder);
        for (int i = 0; i < aListOfFunctionalGroups.size(); ++i) {
            IAtomContainer tmpFG = aListOfFunctionalGroups.get(i);
            if (aConvertExplicitHydrogens) {
                AtomContainerManipulator.suppressHydrogens((IAtomContainer)tmpFG);
            }
            ArrayList<IAtom> tmpListofFGatoms = new ArrayList<IAtom>();
            for (IAtom tmpAtom : tmpFG.atoms()) {
                tmpListofFGatoms.add(tmpAtom);
            }
            for (IAtom tmpAtom : tmpListofFGatoms) {
                if (tmpAtom.getAtomicNumber().equals(1) || aMolecule.contains(tmpAtom)) continue;
                IAtom tmpConnectedAtomInGroup = (IAtom)tmpFG.getConnectedAtomsList(tmpAtom).get(0);
                tmpFG.removeBond(tmpAtom, tmpConnectedAtomInGroup);
                tmpFG.removeAtom(tmpAtom);
                for (IAtom tmpConnectedAtomInOriginalStructure : aMolecule.getConnectedAtomsList(tmpConnectedAtomInGroup)) {
                    if (!tmpConnectedAtomInOriginalStructure.getSymbol().equals("C") || tmpFG.contains(tmpConnectedAtomInOriginalStructure)) continue;
                    tmpFG.addAtom(tmpConnectedAtomInOriginalStructure);
                    tmpFG.addBond(aMolecule.getBond(tmpConnectedAtomInGroup, tmpConnectedAtomInOriginalStructure));
                }
            }
            if (!aFillEmptyValences) continue;
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)tmpFG);
                tmpHadder.addImplicitHydrogens(tmpFG);
                continue;
            }
            catch (CDKException aCDKException) {
                LOGGER.log(Level.WARNING, aCDKException.toString(), aCDKException);
            }
        }
    }

    public static String createPseudoSmilesCode(IAtomContainer aMolecule) throws NullPointerException, CDKException {
        String tmpPseudoSmilesCode;
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'.");
        SmilesGenerator tmpSmilesGenerator = new SmilesGenerator(17);
        try {
            tmpPseudoSmilesCode = tmpSmilesGenerator.create(aMolecule);
        }
        catch (NullPointerException anException) {
            throw new CDKException(anException.getMessage(), (Throwable)anException);
        }
        tmpPseudoSmilesCode = tmpPseudoSmilesCode.replaceAll("\\*", "R");
        tmpPseudoSmilesCode = tmpPseudoSmilesCode.replaceAll("\\[se", "[Se*");
        StringBuilder tmpStringBuilder = new StringBuilder(tmpPseudoSmilesCode);
        int tmpLength = tmpStringBuilder.length();
        for (int tmpIndex = 0; tmpIndex < tmpLength; ++tmpIndex) {
            char tmpChar = tmpStringBuilder.charAt(tmpIndex);
            int tmpPrevChar = 95;
            int tmpPrevPrevChar = 95;
            if (tmpIndex > 0) {
                tmpPrevChar = tmpStringBuilder.charAt(tmpIndex - 1);
            }
            if (tmpIndex > 1) {
                tmpPrevPrevChar = tmpStringBuilder.charAt(tmpIndex - 2);
            }
            switch (tmpChar) {
                case 'c': {
                    if ((tmpPrevChar == 83 || tmpPrevChar == 84 || tmpPrevChar == 65) && tmpPrevPrevChar == 91) break;
                    tmpStringBuilder.setCharAt(tmpIndex, 'C');
                    tmpStringBuilder.insert(tmpIndex + 1, '*');
                    break;
                }
                case 'n': {
                    if ((tmpPrevChar == 77 || tmpPrevChar == 90 || tmpPrevChar == 67 || tmpPrevChar == 73 || tmpPrevChar == 83 || tmpPrevChar == 82) && tmpPrevPrevChar == 91) break;
                    tmpStringBuilder.setCharAt(tmpIndex, 'N');
                    tmpStringBuilder.insert(tmpIndex + 1, '*');
                    break;
                }
                case 's': {
                    if ((tmpPrevChar == 67 || tmpPrevChar == 79 || tmpPrevChar == 65 || tmpPrevChar == 69 || tmpPrevChar == 72) && tmpPrevPrevChar == 91 || tmpPrevChar == 117 && tmpPrevPrevChar == 85) break;
                    tmpStringBuilder.setCharAt(tmpIndex, 'S');
                    tmpStringBuilder.insert(tmpIndex + 1, '*');
                    break;
                }
                case 'o': {
                    if ((tmpPrevChar == 77 || tmpPrevChar == 67 || tmpPrevChar == 80 || tmpPrevChar == 72 || tmpPrevChar == 78) && tmpPrevPrevChar == 91 || tmpPrevChar == 117 && tmpPrevPrevChar == 85) break;
                    tmpStringBuilder.setCharAt(tmpIndex, 'O');
                    tmpStringBuilder.insert(tmpIndex + 1, '*');
                    break;
                }
                case 'p': {
                    if (tmpPrevChar == 78 && tmpPrevPrevChar == 91 || tmpPrevChar == 117 && tmpPrevPrevChar == 85) break;
                    tmpStringBuilder.setCharAt(tmpIndex, 'P');
                    tmpStringBuilder.insert(tmpIndex + 1, '*');
                    break;
                }
            }
            tmpLength = tmpStringBuilder.length();
        }
        tmpPseudoSmilesCode = tmpStringBuilder.toString();
        return tmpPseudoSmilesCode;
    }

    private static String getIDForLogging(IAtomContainer aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'.");
        String tmpCdkTitle = (String)aMolecule.getProperty((Object)"cdk:Title");
        String tmpTitle = aMolecule.getTitle();
        String tmpID = aMolecule.getID();
        if (!Objects.isNull(tmpCdkTitle) && !tmpCdkTitle.isEmpty()) {
            return "CDK title: " + tmpCdkTitle;
        }
        if (!Objects.isNull(tmpTitle) && !tmpTitle.isEmpty()) {
            return "Title: " + tmpTitle;
        }
        if (!Objects.isNull(tmpID) && !tmpID.isEmpty()) {
            return "ID: " + tmpID;
        }
        return "No title or id could be determined.";
    }

    static enum CustomAtomEncoder implements AtomEncoder
    {
        AROMATICITY{

            public int encode(IAtom anAtom, IAtomContainer aContainer) {
                return anAtom.isAromatic() ? 3 : 2;
            }
        };

    }
}

