/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.efgf.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.iterator.IteratingSDFReader;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.efgf.app.ExtractFunctionalGroupsTask;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class ErtlFunctionalGroupsFinderPerformanceSnapshotApp {
    private static final String EXCEPTIONS_LOG_FILE_NAME = "Exceptions_Log.txt";
    private static final String RESULTS_FILE_NAME = "Results.txt";
    private static final String NON_METALLIC_ATOMIC_NUMBERS = "1,2,6,7,8,9,10,15,16,17,18,34,35,36,53,54,86";
    private Set<Integer> nonMetallicAtomicNumbersSet;
    private String workingPath = new File("").getAbsoluteFile().getAbsolutePath() + File.separator;
    private int numberOfThreadsToUse;
    private IAtomContainer[] moleculesArray;
    private Aromaticity aromaticityModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErtlFunctionalGroupsFinderPerformanceSnapshotApp(String[] anArgs) throws IOException {
        LocalDateTime tmpDateTime = LocalDateTime.now();
        String tmpTimeStamp = tmpDateTime.format(DateTimeFormatter.ofPattern("uuuu_MM_dd_HH_mm"));
        File tmpExceptionsLogFile = new File(this.workingPath + EXCEPTIONS_LOG_FILE_NAME);
        FileWriter tmpExceptionsLogFileWriter = new FileWriter(tmpExceptionsLogFile, true);
        PrintWriter tmpExceptionsPrintWriter = new PrintWriter(tmpExceptionsLogFileWriter);
        tmpExceptionsPrintWriter.println("#########################################################################");
        tmpExceptionsPrintWriter.println("Time-stamp: " + tmpTimeStamp);
        tmpExceptionsPrintWriter.println();
        tmpExceptionsPrintWriter.flush();
        tmpExceptionsPrintWriter.close();
        FileInputStream tmpDBFileInputStream = null;
        ExecutorService executor = null;
        PrintWriter tmpResultsPrintWriter = null;
        IteratingSDFReader tmpDBReader = null;
        boolean tmpHasAnErrorOccurred = false;
        try {
            if (anArgs.length != 2) {
                throw new IllegalArgumentException("Two arguments (a file name and the number of threads to use) are required.");
            }
            this.numberOfThreadsToUse = 0;
            try {
                this.numberOfThreadsToUse = Integer.parseInt(anArgs[1]);
            }
            catch (NumberFormatException aNumberFormatException) {
                throw new IllegalArgumentException("Argument \"" + anArgs[1] + "\" must be an integer.");
            }
            if (this.numberOfThreadsToUse <= 0) {
                throw new IllegalArgumentException("The number of threads to use must be at least 1.");
            }
            File tmpDBFile = new File(this.workingPath + anArgs[0]);
            try {
                tmpDBFileInputStream = new FileInputStream(tmpDBFile);
            }
            catch (FileNotFoundException | SecurityException anException) {
                throw new IllegalArgumentException("The database file (name) is not valid: " + anException.getMessage());
            }
            CycleFinder tmpCycleFinder = Cycles.or((CycleFinder)Cycles.all(), (CycleFinder)Cycles.vertexShort());
            this.aromaticityModel = new Aromaticity(ElectronDonation.daylight(), tmpCycleFinder);
            String[] tmpMetalNumbersStrings = NON_METALLIC_ATOMIC_NUMBERS.split(",");
            Integer[] tmpMetalNumbersInt = new Integer[tmpMetalNumbersStrings.length];
            for (int i = 0; i < tmpMetalNumbersStrings.length; ++i) {
                tmpMetalNumbersInt[i] = Integer.parseInt(tmpMetalNumbersStrings[i]);
            }
            this.nonMetallicAtomicNumbersSet = new HashSet<Integer>(Arrays.asList(tmpMetalNumbersInt));
            File tmpResultsLogFile = new File(this.workingPath + RESULTS_FILE_NAME);
            FileWriter tmpResultsLogFileWriter = new FileWriter(tmpResultsLogFile, true);
            tmpResultsPrintWriter = new PrintWriter(tmpResultsLogFileWriter);
            tmpResultsPrintWriter.println("#########################################################################");
            tmpResultsPrintWriter.println("Time-stamp: " + tmpTimeStamp);
            tmpResultsPrintWriter.println();
            tmpResultsPrintWriter.println("Application initialized. Loading database file named " + anArgs[0] + ".");
            tmpResultsPrintWriter.flush();
            System.out.println("\nApplication initialized. Loading database file named " + anArgs[0] + ".");
            tmpDBReader = new IteratingSDFReader((InputStream)tmpDBFileInputStream, SilentChemObjectBuilder.getInstance(), true);
            LinkedList<IAtomContainer> tmpMoleculesList = new LinkedList<IAtomContainer>();
            while (tmpDBReader.hasNext()) {
                try {
                    IAtomContainer tmpMolecule = tmpDBReader.next();
                    tmpMolecule = this.applyFiltersAndPreprocessing(tmpMolecule);
                    tmpMoleculesList.add(tmpMolecule);
                }
                catch (Exception tmpMolecule) {}
            }
            try {
                tmpDBReader.close();
            }
            catch (IOException ex) {
                this.appendToLogfile(ex);
            }
            long tmpSeed = System.nanoTime();
            Collections.shuffle(tmpMoleculesList, new Random(tmpSeed));
            this.moleculesArray = new IAtomContainer[tmpMoleculesList.size()];
            this.moleculesArray = tmpMoleculesList.toArray(this.moleculesArray);
            tmpResultsPrintWriter.println("\nDone Loading database. Found and processed " + this.moleculesArray.length + " valid molecules.");
            System.out.println("Done Loading database. Found and processed " + this.moleculesArray.length + " valid molecules.");
            tmpResultsPrintWriter.flush();
            int tmpNumberOfMolecules = this.moleculesArray.length;
            int tmpNumberOfMoleculesPerThread = tmpNumberOfMolecules / this.numberOfThreadsToUse;
            LinkedList<ExtractFunctionalGroupsTask> tmpListOfThreads = new LinkedList<ExtractFunctionalGroupsTask>();
            int tmpLastEndIndex = tmpNumberOfMolecules - tmpNumberOfMolecules % this.numberOfThreadsToUse - 1;
            for (int i = 0; i <= tmpLastEndIndex; i += tmpNumberOfMoleculesPerThread) {
                IAtomContainer[] tmpMoleculesArrayForThread = Arrays.copyOfRange(this.moleculesArray, i, i + tmpNumberOfMoleculesPerThread);
                tmpListOfThreads.add(new ExtractFunctionalGroupsTask(tmpMoleculesArrayForThread));
            }
            executor = Executors.newFixedThreadPool(this.numberOfThreadsToUse);
            List<Object> tmpFuturesList = new LinkedList();
            long tmpStartTime = System.currentTimeMillis();
            try {
                tmpFuturesList = executor.invokeAll(tmpListOfThreads);
            }
            catch (Exception ex) {
                this.appendToLogfile(ex);
                throw ex;
            }
            long tmpEndTime = System.currentTimeMillis();
            tmpResultsPrintWriter.println("Divided molecules onto " + this.numberOfThreadsToUse + " threads. Extraction of functional groups took " + (tmpEndTime - tmpStartTime) + " ms.");
            System.out.println("Divided molecules onto " + this.numberOfThreadsToUse + " threads. Extraction of functional groups took " + (tmpEndTime - tmpStartTime) + " ms.");
            int tmpExceptionsCounter = 0;
            for (Future future : tmpFuturesList) {
                tmpExceptionsCounter += ((Integer)future.get()).intValue();
            }
            tmpResultsPrintWriter.println(tmpExceptionsCounter + " molecules produced an exception.");
            tmpResultsPrintWriter.flush();
            executor.shutdownNow();
            tmpResultsPrintWriter.println();
            tmpResultsPrintWriter.flush();
            tmpResultsPrintWriter.close();
        }
        catch (Exception anException) {
            this.appendToLogfile(anException);
            anException.printStackTrace(System.err);
            if (anException instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            if (!Objects.isNull(executor)) {
                executor.shutdownNow();
            }
            if (!Objects.isNull(tmpResultsPrintWriter)) {
                tmpResultsPrintWriter.close();
            }
            if (!Objects.isNull(tmpDBFileInputStream)) {
                tmpDBFileInputStream.close();
            }
            if (!Objects.isNull(tmpDBReader)) {
                tmpDBReader.close();
            }
            if (tmpHasAnErrorOccurred) {
                System.exit(1);
            }
        }
    }

    private IAtomContainer applyFiltersAndPreprocessing(IAtomContainer aMolecule) throws IllegalArgumentException, CDKException {
        if (aMolecule.getAtomCount() == 0 || aMolecule.getBondCount() == 0) {
            throw new IllegalArgumentException("Molecule must be filtered!");
        }
        aMolecule.removeProperty((Object)"cdk:CtabSgroups");
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)aMolecule);
        if (!ConnectivityChecker.isConnected((IAtomContainer)aMolecule)) {
            IAtomContainerSet tmpFragmentsSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)aMolecule);
            IAtomContainer tmpBiggestFragment = null;
            for (IAtomContainer tmpFragment : tmpFragmentsSet.atomContainers()) {
                if (tmpBiggestFragment != null && tmpBiggestFragment.getAtomCount() >= tmpFragment.getAtomCount()) continue;
                tmpBiggestFragment = tmpFragment;
            }
            if (!Objects.isNull(tmpBiggestFragment)) {
                aMolecule = tmpBiggestFragment;
            }
        }
        for (IAtom tmpAtom : aMolecule.atoms()) {
            if (!this.nonMetallicAtomicNumbersSet.contains(tmpAtom.getAtomicNumber())) {
                throw new IllegalArgumentException("Molecule must be filtered!");
            }
            if (tmpAtom.getFormalCharge() == 0) continue;
            tmpAtom.setFormalCharge(Integer.valueOf(0));
            CDKHydrogenAdder tmpHAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)aMolecule.getBuilder());
            CDKAtomTypeMatcher tmpMatcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)aMolecule.getBuilder());
            IAtomType tmpMatchedType = tmpMatcher.findMatchingAtomType(aMolecule, tmpAtom);
            if (tmpMatchedType != null) {
                AtomTypeManipulator.configure((IAtom)tmpAtom, (IAtomType)tmpMatchedType);
            }
            tmpHAdder.addImplicitHydrogens(aMolecule, tmpAtom);
        }
        this.aromaticityModel.apply(aMolecule);
        return aMolecule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToLogfile(Exception anException) {
        if (anException == null) {
            return;
        }
        PrintWriter tmpPrintWriter = null;
        try {
            FileWriter tmpFileWriter = new FileWriter(this.workingPath + EXCEPTIONS_LOG_FILE_NAME, true);
            tmpPrintWriter = new PrintWriter(tmpFileWriter);
            StringWriter tmpStringWriter = new StringWriter();
            anException.printStackTrace(new PrintWriter(tmpStringWriter));
            String tmpStackTrace = tmpStringWriter.toString();
            tmpPrintWriter.println(tmpStackTrace);
        }
        catch (IOException anIOException) {
            anIOException.printStackTrace(System.err);
        }
        finally {
            if (tmpPrintWriter != null) {
                tmpPrintWriter.println();
                tmpPrintWriter.flush();
                tmpPrintWriter.close();
            }
        }
    }
}

