/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.efgf.app;

import java.util.concurrent.Callable;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ErtlFunctionalGroupsFinder;

public class ExtractFunctionalGroupsTask
implements Callable<Integer> {
    private final IAtomContainer[] moleculesArray;
    private final ErtlFunctionalGroupsFinder ertlFinder;

    public ExtractFunctionalGroupsTask(IAtomContainer[] aListOfMolecules) {
        this.moleculesArray = aListOfMolecules;
        this.ertlFinder = new ErtlFunctionalGroupsFinder();
    }

    @Override
    public Integer call() throws Exception {
        int tmpExceptionsCounter = 0;
        for (IAtomContainer tmpMolecule : this.moleculesArray) {
            try {
                this.ertlFinder.find(tmpMolecule, false);
            }
            catch (Exception anException) {
                ++tmpExceptionsCounter;
            }
        }
        return tmpExceptionsCounter;
    }
}

