/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.Checks;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.test.Tools;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public interface ChecksTests {
    @Test
    default public void checks_Instantiate_Throws() {
        Tools.assertInstantiateThrows(Checks.class);
    }

    @Test
    default public void checks_contractCheck_WhenNull_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.contractCheck(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void checks_contractCheck_WithValid_Works() {
        Contract contract = Contract.create(Instant.class);
        Assertions.assertSame((Object)contract, (Object)Checks.contractCheck((Contract)contract));
    }

    @Test
    default public void checks_contractsCheck_WhenNull_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.contractsCheck(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void checks_contractsCheck_WithValid_Works(@Mock Contracts contracts) {
        Contract contract = Contract.create(Instant.class);
        Assertions.assertSame((Object)contract, (Object)Checks.contractCheck((Contract)contract));
    }

    @Test
    default public void checks_configCheck_WhenNull_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.configCheck(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void checks_configCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.configCheck((Object)config));
    }

    @Test
    default public void checks_nameCheck_WhenNull_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.nameCheck(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void checks_nameCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.nameCheck((Object)config));
    }

    @Test
    default public void checks_builderConsumerCheck_WhenNull_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.builderConsumerCheck(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void checks_builderConsumerCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.builderConsumerCheck((Object)config));
    }

    @Test
    default public void checks_builderCheck_WhenNull_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.builderCheck(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void checks_builderCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.builderCheck((Object)config));
    }

    @Test
    default public void checks_typeCheck_WhenNull_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.typeCheck(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void checks_typeCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.typeCheck((Object)config));
    }

    @Test
    default public void checks_illegalCheck_WhenFailedIsFalse_Works() {
        String actual = (String)Checks.illegalCheck((Object)"abc", (boolean)false, (String)"");
        Assertions.assertSame((Object)"abc", (Object)actual);
    }

    @Test
    default public void checks_illegalCheck_WhenValid_Works() {
        String actual = (String)Checks.illegalCheck((Object)"abc", (boolean)false, (String)"");
        Assertions.assertSame((Object)"abc", (Object)actual);
    }

    @Test
    default public void checks_illegalCheck_WhenFailed_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.illegalCheck((Object)"abc", (boolean)true, (String)"Xyz."));
        Tools.assertThrown((Throwable)thrown, "Xyz.");
    }

    @Test
    default public void checks_illegalCheck_WhenNullMessage_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Checks.illegalCheck((Object)"abc", (boolean)false, null));
        Tools.assertThrown(thrown);
    }
}

