/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.AutoClose;
import io.github.jonloucks.contracts.api.BindStrategy;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.api.ContractException;
import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.api.GlobalContracts;
import io.github.jonloucks.contracts.api.Promisor;
import io.github.jonloucks.contracts.test.Tools;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public interface ContractsTests {
    @Test
    default public void contracts_claim_NotBound_Throws() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            Contract contract = Contract.create((String)"test", (Object[])new Integer[0]);
            ContractException thrown = (ContractException)Assertions.assertThrows(ContractException.class, () -> contracts.claim(contract));
            Tools.assertThrown((Throwable)thrown);
        });
    }

    @Test
    default public void contracts_replaceBinding_Works() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            Contract<Integer> contract = Tools.createReplaceableContract(Integer.class);
            try (AutoClose firstBinding = contracts.bind(contract, () -> 9);
                 AutoClose secondBinding = contracts.bind(contract, () -> 100);){
                AutoClose ignored = secondBinding;
                Tools.implicitClose(firstBinding);
                Assertions.assertEquals((int)100, (Integer)((Integer)contracts.claim(contract)));
            }
        });
    }

    @Test
    default public void contracts_bind_WithExisting_IF_NOT_BOUND_Works() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            Contract<Integer> contract = Tools.createReplaceableContract(Integer.class);
            try (AutoClose firstBinding = contracts.bind(contract, () -> 9);
                 AutoClose secondBinding = contracts.bind(contract, () -> 100, BindStrategy.IF_NOT_BOUND);){
                AutoClose ignored1 = firstBinding;
                AutoClose ignored2 = secondBinding;
                Assertions.assertEquals((int)9, (Integer)((Integer)contracts.claim(contract)));
            }
        });
    }

    @Test
    default public void contracts_bind_WithExisting_ALWAYS_Works() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            Contract<Integer> contract = Tools.createReplaceableContract(Integer.class);
            try (AutoClose firstBinding = contracts.bind(contract, () -> 9);
                 AutoClose secondBinding = contracts.bind(contract, () -> 100, BindStrategy.ALWAYS);){
                AutoClose ignored1 = firstBinding;
                AutoClose ignored2 = secondBinding;
                Assertions.assertEquals((int)100, (Integer)((Integer)contracts.claim(contract)));
            }
        });
    }

    @Test
    default public void contracts_idempotent_DoesNotThrow() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            Contract contract = Contract.create((String)"test", (Object[])new Integer[0]);
            try (AutoClose closeBinding = contracts.bind(contract, () -> 9);){
                Assertions.assertDoesNotThrow(() -> {
                    Tools.implicitClose(closeBinding);
                    Tools.implicitClose(closeBinding);
                });
            }
        });
    }

    @Test
    default public void contracts_open_twice_IsIgnored() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            Contract contract = Contract.create((String)"test", (Object[])new Integer[0]);
            try (AutoClose closeBinding = contracts.bind(contract, () -> 3);){
                AutoClose ignored = closeBinding;
                contracts.open().close();
                Assertions.assertEquals((int)3, (Integer)((Integer)contracts.claim(contract)));
            }
        });
    }

    @Test
    default public void contracts_bind_AlreadyBoundAndNotReplaceable_Throws() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            Contract contract = Contract.create((String)"test", (Object[])new Integer[0]);
            try (AutoClose closeBinding = contracts.bind(contract, () -> 3);){
                AutoClose ignored = closeBinding;
                ContractException thrown = (ContractException)Assertions.assertThrows(ContractException.class, () -> contracts.bind(contract, () -> 4, BindStrategy.ALWAYS));
                Tools.assertThrown((Throwable)thrown);
            }
        });
    }

    @Test
    default public void contracts_bind_Twice_IsIgnored() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            Contract<Integer> contract = Tools.createReplaceableContract(Integer.class);
            Promisor promisor = () -> 7;
            try (AutoClose closeBinding = contracts.bind(contract, promisor);){
                AutoClose ignored = closeBinding;
                contracts.bind(contract, promisor).close();
                Assertions.assertTrue((boolean)contracts.isBound(contract));
            }
        });
    }

    @Test
    default public void contracts_BindOnClose_Throws() {
        ContractsTestsTools.runWithScenario((contracts, closeContracts) -> {
            final Contract contract = Contract.create((String)"test", (Object[])new Integer[0]);
            Promisor<Integer> promisor = new Promisor<Integer>(){

                public Integer demand() {
                    return 0;
                }

                public int decrementUsage() {
                    contracts.bind(contract, (Promisor)this);
                    return 1;
                }
            };
            contracts.bind(contract, (Promisor)promisor);
            ContractException thrown = (ContractException)Assertions.assertThrows(ContractException.class, () -> closeContracts.close());
            Tools.assertThrown((Throwable)thrown);
        });
    }

    @Test
    default public void contracts_InternalCoverage() {
        Tools.assertInstantiateThrows(ContractsTestsTools.class);
    }

    public static final class ContractsTestsTools {
        private ContractsTestsTools() {
            throw new AssertionError((Object)"Illegal constructor");
        }

        static void runWithScenario(ScenarioConfig config) {
            Contracts contracts = GlobalContracts.createContracts((Contracts.Config)new Contracts.Config(){});
            try (AutoClose autoClose = contracts.open();){
                config.accept(contracts, autoClose);
            }
        }

        static interface ScenarioConfig
        extends BiConsumer<Contracts, AutoClose> {
        }
    }
}

