/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.ContractException;
import io.github.jonloucks.contracts.test.Tools;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public interface ExceptionTests {
    @Test
    default public void exception_ContractException_WithNullMessage_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new ContractException(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void exception_ContractException_IsSerializable() {
        Tools.assertIsSerializable(ContractException.class);
    }

    @Test
    default public void exception_ContractException_WithValid_Works() {
        ContractException exception = new ContractException("Abc.");
        Tools.assertThrown((Throwable)exception, "Abc.");
    }

    @Test
    default public void exception_ContractException_WithCause_Works() {
        OutOfMemoryError cause = new OutOfMemoryError("Out of memory.");
        ContractException exception = new ContractException("Abc.", (Throwable)cause);
        Tools.assertThrown((Throwable)exception, cause, "Abc.");
    }
}

