/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.Promisor;
import io.github.jonloucks.contracts.api.Promisors;
import io.github.jonloucks.contracts.test.Decoy;
import io.github.jonloucks.contracts.test.Tools;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public interface ExtractorPromisorTests {
    @Test
    default public void extractPromisor_NullReferent_Throws() {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> promisors.createExtractPromisor(null, t -> "xyz"));
            Tools.assertThrown(thrown);
        });
    }

    @Test
    default public void extractPromisor_NullRecast_Throws() {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> promisors.createExtractPromisor(() -> "abc", null));
            Tools.assertThrown(thrown);
        });
    }

    @Test
    default public void extractPromisor_Valid_Works(@Mock Promisor<Decoy<Integer>> referent, @Mock Decoy<Integer> deliverable) {
        Tools.withContracts(contracts -> {
            int i;
            int usages = 5;
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Mockito.when((Object)((Decoy)referent.demand())).thenReturn((Object)deliverable);
            Promisor promisor = promisors.createExtractPromisor(referent, c -> "abc");
            Assertions.assertNotNull((Object)promisor, (String)"should not return null.");
            for (i = 0; i < 5; ++i) {
                promisor.incrementUsage();
            }
            for (i = 0; i < 5; ++i) {
                promisor.decrementUsage();
            }
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertSame((Object)"abc", (Object)promisor.demand(), (String)"deliverables should match."), () -> ((Promisor)Mockito.verify((Object)referent, (VerificationMode)Mockito.times((int)5))).decrementUsage(), () -> ((Promisor)Mockito.verify((Object)referent, (VerificationMode)Mockito.times((int)5))).incrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).incrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).decrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).open(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).close()});
        });
    }
}

