/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.AutoClose;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.api.Promisor;
import io.github.jonloucks.contracts.api.Promisors;
import io.github.jonloucks.contracts.test.Decoy;
import io.github.jonloucks.contracts.test.Tools;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public interface LifeCyclePromisorTests {
    @Test
    default public void lifeCyclePromisor_WithNullPromisor_Throws() {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> promisors.createLifeCyclePromisor(null));
            Tools.assertThrown(thrown);
        });
    }

    @Test
    default public void lifeCyclePromisor_demand_WithoutUsage_Throws() {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Promisor promisor = promisors.createLifeCyclePromisor(() -> "abc");
            IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> promisor.demand());
            Tools.assertThrown(thrown);
        });
    }

    @Test
    default public void lifeCyclePromisor_WithNullDeliverable_IsAllowed() {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Promisor promisor = promisors.createLifeCyclePromisor(() -> null);
            promisor.incrementUsage();
            Assertions.assertNotNull((Object)promisor, (String)"should not return null.");
            Assertions.assertNull((Object)promisor.demand());
        });
    }

    @Test
    default public void lifeCyclePromisor_Valid_Works(@Mock Promisor<Decoy<Integer>> referent, @Mock Decoy<Integer> deliverable) {
        Tools.withContracts(contracts -> {
            int usages = 5;
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Mockito.when((Object)((Decoy)referent.demand())).thenReturn((Object)deliverable);
            Mockito.when((Object)deliverable.open()).thenReturn((Object)deliverable);
            Promisor promisor = promisors.createLifeCyclePromisor(referent);
            Assertions.assertNotNull((Object)promisor, (String)"should not return null.");
            for (int i = 0; i < 5; ++i) {
                promisor.incrementUsage();
            }
            Decoy actual = (Decoy)promisor.demand();
            for (int i = 0; i < 5; ++i) {
                promisor.decrementUsage();
            }
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertSame((Object)deliverable, (Object)actual, (String)"deliverables should match."), () -> ((Promisor)Mockito.verify((Object)referent, (VerificationMode)Mockito.times((int)5))).decrementUsage(), () -> ((Promisor)Mockito.verify((Object)referent, (VerificationMode)Mockito.times((int)5))).incrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).incrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).decrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.times((int)1))).open(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.times((int)1))).close()});
        });
    }

    @ParameterizedTest(name="Threads = {0}")
    @ValueSource(ints={1, 3, 29})
    default public void lifeCyclePromisor_ClaimsDuringOpen(final int threadCount) throws Throwable {
        ConcurrencyTestsTool.runWithScenario(new ConcurrencyTestsTool.ScenarioConfig(){

            @Override
            public int threadCount() {
                return threadCount;
            }

            @Override
            public void mockupDeliverable(Decoy<String> mockDeliverable) {
                ConcurrencyTestsTool.overrideOpen(mockDeliverable, Duration.ofMillis(100L), () -> {});
            }
        });
    }

    @ParameterizedTest(name="Threads = {0}")
    @ValueSource(ints={1, 3, 29})
    default public void lifeCyclePromisor_ThrowingOpen(final int threadCount) throws Throwable {
        ConcurrencyTestsTool.runWithScenario(new ConcurrencyTestsTool.ScenarioConfig(){

            @Override
            public int threadCount() {
                return threadCount;
            }

            @Override
            public float successPercentage() {
                return 0.0f;
            }

            @Override
            public void mockupDeliverable(Decoy<String> mockDeliverable) {
                ConcurrencyTestsTool.overrideOpen(mockDeliverable, Duration.ofMillis(0L), () -> {
                    switch (threadCount % 3) {
                        case 0: {
                            throw new RuntimeException("RuntimeException");
                        }
                        case 1: {
                            throw new Error("Error");
                        }
                        case 2: {
                            throw new ArithmeticException("Error");
                        }
                    }
                });
            }
        });
    }

    @ParameterizedTest(name="Threads = {0}")
    @ValueSource(ints={1, 3, 29})
    default public void lifeCyclePromisor_ClaimsDuringClose(final int threadCount) throws Throwable {
        ConcurrencyTestsTool.runWithScenario(new ConcurrencyTestsTool.ScenarioConfig(){

            @Override
            public int threadCount() {
                return threadCount;
            }

            @Override
            public void mockupDeliverable(Decoy<String> mockDeliverable) {
                ConcurrencyTestsTool.overrideClose(mockDeliverable, Duration.ofMillis(100L), () -> {});
            }

            @Override
            public void beforeWaitForCompletion(Promisor<Decoy<String>> testSubject) {
                Tools.sleep(Duration.ofMillis(100L));
                testSubject.decrementUsage();
            }
        });
    }

    @ParameterizedTest(name="Threads = {0}")
    @ValueSource(ints={1, 3, 29})
    default public void lifeCyclePromisor_ClaimsDuringDemand(final int threadCount) throws Throwable {
        ConcurrencyTestsTool.runWithScenario(new ConcurrencyTestsTool.ScenarioConfig(){

            @Override
            public int threadCount() {
                return threadCount;
            }

            @Override
            public Duration demandDelay() {
                return Duration.ofMillis(100L);
            }
        });
    }

    @ParameterizedTest(name="Threads = {0}")
    @ValueSource(ints={1, 3, 29})
    default public void lifeCyclePromisor_Demand_Reentrancy_Works(final int threadCount) throws Throwable {
        ConcurrencyTestsTool.runWithScenario(new ConcurrencyTestsTool.ScenarioConfig(){

            @Override
            public int threadCount() {
                return threadCount;
            }

            @Override
            public boolean reentrancy() {
                return true;
            }
        });
    }

    @Test
    default public void lifecyclePromisor_InternalCoverage() {
        Tools.assertInstantiateThrows(ConcurrencyTestsTool.class);
    }

    public static final class ConcurrencyTestsTool {
        private ConcurrencyTestsTool() {
            throw new AssertionError((Object)"Illegal constructor");
        }

        static void runWithScenario(final ScenarioConfig config) {
            int totalClaims = config.threadCount() * config.claimsPerThread();
            int expectedSuccesses = (int)config.successPercentage() * totalClaims;
            int expectedFailures = totalClaims - expectedSuccesses;
            Contract contract = Contract.create((String)"Contract", (Object[])new Decoy[0]);
            Thread[] claimThreads = new Thread[config.threadCount()];
            AtomicInteger failedCount = new AtomicInteger(0);
            AtomicInteger successCount = new AtomicInteger(0);
            CountDownLatch latch = new CountDownLatch(config.threadCount());
            Decoy mockDeliverable = (Decoy)Mockito.spy((Object[])new Decoy[0]);
            Promisor mockPromisor = (Promisor)Mockito.spy((Object[])new Promisor[0]);
            AtomicBoolean firstDemand = new AtomicBoolean(true);
            Tools.withContracts(contracts -> {
                config.mockupDeliverable(mockDeliverable);
                ConcurrencyTestsTool.overrideDemand(mockPromisor, config.demandDelay(), () -> {
                    if (firstDemand.compareAndSet(true, false)) {
                        config.demandDelay();
                    } else if (config.reentrancy()) {
                        return (Decoy)contracts.claim(contract);
                    }
                    return mockDeliverable;
                });
                Promisor testSubject = ConcurrencyTestsTool.createTestSubject(contracts, mockPromisor);
                try (AutoClose closeBinding = contracts.bind(contract, testSubject);){
                    int i;
                    AutoClose ignored2 = closeBinding;
                    for (i = 0; i < config.threadCount(); ++i) {
                        claimThreads[i] = new Thread("Claim-" + i, (Contracts)contracts, contract, successCount, failedCount, latch){
                            final /* synthetic */ Contracts val$contracts;
                            final /* synthetic */ Contract val$contract;
                            final /* synthetic */ AtomicInteger val$successCount;
                            final /* synthetic */ AtomicInteger val$failedCount;
                            final /* synthetic */ CountDownLatch val$latch;
                            {
                                this.val$contracts = contracts;
                                this.val$contract = contract;
                                this.val$successCount = atomicInteger;
                                this.val$failedCount = atomicInteger2;
                                this.val$latch = countDownLatch;
                                super(arg0);
                            }

                            @Override
                            public void run() {
                                try {
                                    for (int i = 0; i < config.claimsPerThread(); ++i) {
                                        try {
                                            this.val$contracts.claim(this.val$contract);
                                            this.val$successCount.incrementAndGet();
                                            continue;
                                        }
                                        catch (Throwable thrown) {
                                            this.val$failedCount.incrementAndGet();
                                        }
                                    }
                                }
                                finally {
                                    this.val$latch.countDown();
                                }
                            }
                        };
                    }
                    for (i = 0; i < config.threadCount(); ++i) {
                        claimThreads[i].start();
                    }
                    config.beforeWaitForCompletion(testSubject);
                    try {
                        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES), (String)"Test took too long");
                    }
                    catch (InterruptedException e) {
                        Assertions.fail((String)"Test took too long");
                    }
                }
                Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)expectedSuccesses, (int)successCount.get(), (String)"Success count"), () -> Assertions.assertEquals((int)expectedFailures, (int)failedCount.get(), (String)"Failed count")});
                if (expectedSuccesses > 0) {
                    ((Decoy)Mockito.verify((Object)mockDeliverable, (VerificationMode)Mockito.times((int)1))).open();
                    ((Decoy)Mockito.verify((Object)mockDeliverable, (VerificationMode)Mockito.times((int)1))).close();
                }
            });
        }

        static <T> Promisor<T> createTestSubject(Contracts contracts, Promisor<T> promisor) {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            return promisors.createLifeCyclePromisor(promisor);
        }

        static <T> void overrideOpen(Decoy<T> decoy, Duration duration, Runnable block) {
            ((Decoy)Mockito.doAnswer(invocation -> {
                Tools.sleep(duration);
                block.run();
                return decoy;
            }).when(decoy)).open();
        }

        static <T> void overrideClose(Decoy<T> decoy, Duration duration, Runnable block) {
            ((Decoy)Mockito.doAnswer(invocation -> {
                Tools.sleep(duration);
                block.run();
                return null;
            }).when(decoy)).close();
        }

        private static <T> void overrideDemand(Promisor<T> promisor, Duration duration, Supplier<T> block) {
            Mockito.when((Object)promisor.demand()).thenAnswer(invocation -> {
                Tools.sleep(duration);
                return block.get();
            });
        }

        static interface ScenarioConfig {
            public int threadCount();

            default public void mockupDeliverable(Decoy<String> mockDeliverable) {
            }

            default public void beforeWaitForCompletion(Promisor<Decoy<String>> testSubject) {
            }

            default public Duration demandDelay() {
                return Duration.ZERO;
            }

            default public int claimsPerThread() {
                return 123;
            }

            default public float successPercentage() {
                return 1.0f;
            }

            default public boolean reentrancy() {
                return false;
            }
        }
    }
}

