/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.AutoClose;
import io.github.jonloucks.contracts.api.BindStrategy;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.api.ContractException;
import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.api.Promisor;
import io.github.jonloucks.contracts.api.Repository;
import io.github.jonloucks.contracts.test.Tools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public interface RepositoryTests {
    @Test
    default public void repository_Factory() {
        Tools.withContracts(contracts -> {
            Supplier repositoryFactory = (Supplier)contracts.claim(Repository.FACTORY);
            Tools.assertObject(repositoryFactory);
        });
    }

    @Test
    default public void repository_Main_UseCase() {
        Tools.withContracts(contracts -> {
            Contract contract = Contract.create((String)"test repository", (Object[])new Repository[0]);
            try (AutoClose ignored = contracts.bind(contract, () -> (Repository)((Supplier)contracts.claim(Repository.FACTORY)).get());){
                Repository repository = (Repository)contracts.claim(contract);
                Tools.assertObject(repository);
            }
        });
    }

    @Test
    default public void repository_check_WithNoRequirements() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> Assertions.assertDoesNotThrow(() -> ((Repository)repository).check()));
    }

    @Test
    default public void repository_check_WithOneRequirement_Throws() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract contract = Contract.create((String)"a requirement", (Object[])new Integer[0]);
            repository.require(contract);
            ContractException thrown = (ContractException)Assertions.assertThrows(ContractException.class, () -> ((Repository)repository).check());
            Tools.assertThrown((Throwable)thrown);
        });
    }

    @Test
    default public void repository_check_WithFulfilledRequirements() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract contract = Contract.create((String)"a requirement", (Object[])new Integer[0]);
            repository.require(contract);
            try (AutoClose closeBinding = contracts.bind(contract, () -> 42);){
                AutoClose ignored = closeBinding;
                Assertions.assertDoesNotThrow(() -> ((Repository)repository).check());
            }
        });
    }

    @Test
    default public void repository_store_isBound() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract textContract = Contract.create((String)"test text", (Object[])new String[0]);
            try (AutoClose closeBinding = repository.store(textContract, () -> "x");){
                AutoClose ignored = closeBinding;
                Assertions.assertTrue((boolean)contracts.isBound(textContract), (String)"Contract should have been bound");
            }
            Assertions.assertFalse((boolean)contracts.isBound(textContract), (String)"Contract should not be bound");
        });
    }

    @Test
    default public void repository_store_Works() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract textContract = Contract.create((String)"test text", (Object[])new String[0]);
            try (AutoClose closeBinding = repository.store(textContract, () -> "x");){
                AutoClose ignored = closeBinding;
                String text = (String)contracts.claim(textContract);
                Assertions.assertEquals((Object)"x", (Object)text, (String)"contract deliverable should match");
            }
        });
    }

    @Test
    default public void repository_store_WhenClosedTwice_DoesNothing() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract textContract = Contract.create((String)"test text", (Object[])new String[0]);
            try (AutoClose closeStore = repository.store(textContract, () -> "x");){
                Assertions.assertDoesNotThrow(() -> ((AutoClose)closeStore).close());
                Assertions.assertDoesNotThrow(() -> ((AutoClose)closeStore).close());
            }
        });
    }

    @Test
    default public void repository_open_WhenCalledTwice_DoesNothing() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract textContract = Contract.create((String)"test text", (Object[])new String[0]);
            try (AutoClose closeBinding = repository.store(textContract, () -> "y");){
                AutoClose ignored = closeBinding;
                try (AutoClose closeRepository = repository.open();){
                    AutoClose autoClose = closeRepository;
                }
                Assertions.assertEquals((Object)"y", (Object)contracts.claim(textContract), (String)"contract deliverable should not change");
            }
        });
    }

    @Test
    default public void repository_close_WhenCalledTwice_DoesNothing() {
        Tools.withContracts(contracts -> {
            Repository repository = (Repository)((Supplier)contracts.claim(Repository.FACTORY)).get();
            try (AutoClose closeRepository = repository.open();){
                closeRepository.close();
                Assertions.assertDoesNotThrow(() -> ((AutoClose)closeRepository).close());
            }
        });
    }

    @Test
    default public void repository_close_ReleasesResources() {
        Tools.withContracts(contracts -> {
            Repository repository = (Repository)((Supplier)contracts.claim(Repository.FACTORY)).get();
            int count = 10;
            ArrayList<Contract> contractList = new ArrayList<Contract>();
            LinkedList<Integer> expectedOrder = new LinkedList<Integer>();
            ArrayList actualOrder = new ArrayList();
            for (int i = 0; i < 10; ++i) {
                Integer deliverable = i;
                Promisor promisor = (Promisor)Mockito.spy((Object[])new Promisor[0]);
                AtomicInteger referenceCount = new AtomicInteger();
                Mockito.when((Object)((Integer)promisor.demand())).thenReturn((Object)deliverable);
                Mockito.when((Object)promisor.incrementUsage()).thenAnswer(invocation -> referenceCount.incrementAndGet());
                Mockito.when((Object)promisor.decrementUsage()).thenAnswer(invocation -> {
                    int currentCount = referenceCount.decrementAndGet();
                    if (currentCount == 0) {
                        actualOrder.add(deliverable);
                    }
                    return currentCount;
                });
                Contract contract = Contract.create((String)("Contact " + deliverable), (Object[])new Integer[0]);
                contractList.add(contract);
                expectedOrder.push(deliverable);
                repository.keep(contract, promisor);
            }
            try (AutoClose closeRepository = repository.open();){
                AutoClose ignoreCloseRepository = closeRepository;
                for (int i = 0; i < 10; ++i) {
                    contracts.claim((Contract)contractList.get(i));
                }
            }
            Assertions.assertFalse((boolean)actualOrder.isEmpty(), (String)"Actual order should not be empty");
            Assertions.assertEquals((int)expectedOrder.size(), (int)actualOrder.size(), (String)"closed promisors count");
            Assertions.assertEquals(expectedOrder, actualOrder, (String)"closed promisors order");
        });
    }

    @Test
    default public void repository_keep_WhenCalledTwice_Throws() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract textContract = Contract.create((String)"test text", (Object[])new String[0]);
            repository.keep(textContract, () -> "x");
            ContractException thrown = (ContractException)Assertions.assertThrows(ContractException.class, () -> repository.keep(textContract, () -> "y"));
            Tools.assertThrown((Throwable)thrown);
        });
    }

    @Test
    default public void repository_keep_Replace_Works() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract textContract = Contract.create(String.class, b -> b.replaceable(true));
            try (AutoClose closeFirstBinding = contracts.bind(textContract, () -> "x");){
                AutoClose ignoredFirstBinding = closeFirstBinding;
                repository.keep(textContract, () -> "y");
                String text = (String)contracts.claim(textContract);
                Assertions.assertEquals((Object)"y", (Object)text, (String)"contract deliverable replace should match");
            }
        });
    }

    @Test
    default public void repository_keep_WhenNotReplaceableAndBound_IsIgnored() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract textContract = Contract.create(String.class, b -> b.replaceable(false));
            try (AutoClose closeFirstBinding = contracts.bind(textContract, () -> "x");){
                AutoClose ignoredFirstBinding = closeFirstBinding;
                repository.keep(textContract, () -> "y");
                String text = (String)contracts.claim(textContract);
                Assertions.assertEquals((Object)"x", (Object)text, (String)"contract deliverable should not change");
            }
        });
    }

    @Test
    default public void repository_keep_WhenNotReplaceableAndBoundAnd_BIND_ALWAYS_Throws() {
        RepositoryTestsTool.runWithScenario((contracts, repository) -> {
            Contract textContract = Contract.create(String.class, b -> b.replaceable(false));
            try (AutoClose closeFirstBinding = contracts.bind(textContract, () -> "x");){
                AutoClose ignoredFirstBinding = closeFirstBinding;
                ContractException thrown = (ContractException)Assertions.assertThrows(ContractException.class, () -> repository.keep(textContract, () -> "y", BindStrategy.ALWAYS));
                Tools.assertThrown((Throwable)thrown);
            }
        });
    }

    @Test
    default public void repository_InternalCoverage() {
        Tools.assertInstantiateThrows(RepositoryTestsTool.class);
    }

    public static final class RepositoryTestsTool {
        private RepositoryTestsTool() {
            throw new AssertionError((Object)"Illegal constructor.");
        }

        static void runWithScenario(ScenarioConfig block) {
            Tools.withContracts(contracts -> {
                Repository repository = (Repository)((Supplier)contracts.claim(Repository.FACTORY)).get();
                try (AutoClose closeRepository = repository.open();){
                    AutoClose ignored = closeRepository;
                    block.accept(contracts, repository);
                }
            });
        }

        static interface ScenarioConfig
        extends BiConsumer<Contracts, Repository> {
        }
    }
}

