/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.AutoClose;
import io.github.jonloucks.contracts.api.Checks;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.api.GlobalContracts;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public final class Tools {
    private Tools() {
        throw new AssertionError((Object)"Illegal constructor call");
    }

    public static void assertFails(Executable executable) {
        Executable validExecutable = (Executable)Checks.nullCheck((Object)executable, (String)"Executable must be present.");
        AssertionError thrown = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, (Executable)validExecutable));
        Tools.assertObject(thrown);
        Assertions.assertNotNull((Object)((Throwable)((Object)thrown)).getMessage());
    }

    public static void assertObject(Object object) {
        final class Unknown {
            Unknown() {
            }
        }
        Unknown unknown = new Unknown();
        Assertions.assertNotNull((Object)object, (String)"object was null.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)object.hashCode(), (int)object.hashCode(), (String)"Hash codes should not change."), () -> Assertions.assertNotNull((Object)object.toString(), (String)"Object toString() was null."), () -> Assertions.assertFalse((boolean)object.equals(null), (String)"Object.equals(null) should be false."), () -> Assertions.assertFalse((boolean)object.equals(unknown), (String)"Object.equals(unknown) should be false.")});
    }

    public static void assertInstantiateThrows(Class<?> theClass) {
        Class validClass = (Class)Checks.typeCheck(theClass);
        Throwable thrown = Assertions.assertThrows(Throwable.class, () -> {
            Constructor constructor = validClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
        });
        Assertions.assertTrue((thrown instanceof IllegalAccessException || thrown instanceof InaccessibleObjectException || thrown instanceof InvocationTargetException || thrown instanceof NoSuchMethodException || thrown instanceof AssertionError ? 1 : 0) != 0, (String)("Exception thrown not expected " + thrown.getClass().getName()));
    }

    public static void assertThrown(Throwable thrown, Throwable cause, String reason) {
        Tools.assertObject(thrown);
        Assertions.assertAll((Executable[])new Executable[]{() -> Tools.assertMessage(thrown.getMessage()), () -> Assertions.assertEquals((Object)cause, (Object)thrown.getCause(), (String)"The cause should match."), () -> Assertions.assertEquals((Object)reason, (Object)thrown.getMessage(), (String)"The reason should match."), () -> Assertions.assertNotNull((Object)thrown.toString(), (String)"The string should not be null.")});
    }

    public static void assertMessage(String message) {
        Assertions.assertNotNull((Object)message, (String)"Message must be present.");
        Assertions.assertFalse((boolean)message.isEmpty(), (String)"Message should not be empty.");
        Assertions.assertTrue((boolean)Character.isUpperCase(message.charAt(0)), (String)"Message should start with a upper case character.");
        Assertions.assertEquals((char)'.', (char)message.charAt(message.length() - 1), (String)("Message should end with a dot: " + message + "."));
    }

    public static void assertThrown(Throwable thrown) {
        Assertions.assertNotNull((Object)thrown, (String)"Thrown must be present.");
        Tools.assertThrown(thrown, thrown.getCause(), thrown.getMessage());
    }

    public static void assertThrown(Throwable thrown, Throwable cause) {
        Assertions.assertNotNull((Object)thrown, (String)"Thrown must be present.");
        Tools.assertThrown(thrown, cause, thrown.getMessage());
    }

    public static void assertThrown(Throwable thrown, String reason) {
        Assertions.assertNotNull((Object)thrown, (String)"Thrown must be present.");
        Tools.assertThrown(thrown, thrown.getCause(), reason);
    }

    public static <T> void assertContract(Contract<T> contract, Contract.Config<T> config, T valid) {
        Assertions.assertNotNull(contract, (String)"Contract must not be null.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Tools.assertObject(contract), () -> Assertions.assertSame((Object)config.cast(valid), (Object)contract.cast(valid), (String)"Casting a valid value should work."), () -> Assertions.assertNull((Object)contract.cast(null), (String)"Casting null should return null."), () -> Assertions.assertThrows(ClassCastException.class, () -> contract.cast(System.class), (String)"Invalid cast should thrown."), () -> Assertions.assertSame((Object)config.typeName(), (Object)contract.getTypeName(), (String)"Contract type mismatch."), () -> Assertions.assertSame((Object)config.name(), (Object)contract.getName(), (String)"Contract name mismatch."), () -> Assertions.assertSame((Object)config.isReplaceable(), (Object)contract.isReplaceable(), (String)"Contract replacement mismatch.")});
    }

    public static void sanitize(Executable ... sanitizers) {
        if (Optional.ofNullable(sanitizers).isPresent()) {
            for (Executable sanitizer : sanitizers) {
                if (!Optional.ofNullable(sanitizer).isPresent()) continue;
                try {
                    sanitizer.execute();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static void clean() {
        Tools.sanitize(() -> {
            Contracts.Config config = new Contracts.Config(){};
            ServiceLoader loader = ServiceLoader.load(config.serviceLoaderClass());
            loader.reload();
        });
    }

    public static void sleep(Duration duration) {
        Duration validDuration = (Duration)Checks.nullCheck((Object)duration, (String)"Duration must be present.");
        CountDownLatch latch = new CountDownLatch(1);
        Checks.illegalCheck((Object)validDuration, (boolean)validDuration.isNegative(), (String)"Duration must not be negative.");
        if (validDuration.isZero()) {
            return;
        }
        try {
            Assertions.assertFalse((boolean)latch.await(validDuration.toMillis(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static <T> Contract<T> createReplaceableContract(final Class<T> type) {
        return Contract.create((Contract.Config)new Contract.Config<T>(){

            public T cast(Object instance) {
                return type.cast(instance);
            }

            public boolean isReplaceable() {
                return true;
            }
        });
    }

    public static void assertIsSerializable(Class<?> clazz) {
        Assertions.assertTrue((boolean)Serializable.class.isAssignableFrom(clazz), (String)"Class must implement Serializable.");
        try {
            Field serialVersionUIDField = clazz.getDeclaredField("serialVersionUID");
            Assertions.assertNotNull((Object)serialVersionUIDField, (String)"The serialVersionUID field must exist.");
            Assertions.assertTrue((boolean)Modifier.isStatic(serialVersionUIDField.getModifiers()), (String)"The serialVersionUID must be static.");
            Assertions.assertTrue((boolean)Modifier.isFinal(serialVersionUIDField.getModifiers()), (String)"The serialVersionUID must be final.");
            Assertions.assertEquals(Long.TYPE, serialVersionUIDField.getType(), (String)"The serialVersionUID must be of type long.");
        }
        catch (NoSuchFieldException ignored) {
            Assertions.fail((String)("Unable to find serialVersionUID field in class " + clazz.getName() + "."));
        }
    }

    public static void withContracts(Consumer<Contracts> block) {
        Contracts.Config config = new Contracts.Config(){

            public boolean useShutdownHooks() {
                return false;
            }
        };
        Tools.withContracts(config, block);
    }

    public static void withContracts(Contracts.Config config, Consumer<Contracts> block) {
        Contracts.Config validConfig = (Contracts.Config)Checks.configCheck((Object)config);
        Consumer validBlock = (Consumer)Checks.nullCheck(block, (String)"Block must be present.");
        Contracts contracts = GlobalContracts.createContracts((Contracts.Config)validConfig);
        try (AutoClose closeContracts = contracts.open();){
            AutoClose ignored = closeContracts;
            validBlock.accept(contracts);
        }
    }

    public static void implicitClose(AutoClose close) {
        close.close();
    }
}

