/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.test.Tools;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public interface ToolsTests {
    @Test
    default public void tools_Instantiate_Throws() {
        Tools.assertInstantiateThrows(Tools.class);
    }

    @Test
    default public void tools_sanitize_WithNullEllipses_DoesNotThrow() {
        Assertions.assertDoesNotThrow(() -> Tools.sanitize(null));
    }

    @Test
    default public void tools_sanitize_WithNullElement_DoesNotThrow() {
        Assertions.assertDoesNotThrow(() -> Tools.sanitize(new Executable[]{null}));
    }

    @Test
    default public void tools_sanitize_WithSingeSanitize_Works(@Mock Executable sanitizer) throws Throwable {
        Assertions.assertDoesNotThrow(() -> Tools.sanitize(sanitizer));
        ((Executable)Mockito.verify((Object)sanitizer, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    default public void tools_sanitize_WithMany_Works(@Mock Executable sanitizer) throws Throwable {
        Executable throwingSanitizer = () -> {
            throw new IllegalStateException("Oh My");
        };
        Assertions.assertDoesNotThrow(() -> Tools.sanitize(throwingSanitizer, sanitizer, throwingSanitizer));
        ((Executable)Mockito.verify((Object)sanitizer, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    default public void tools_assertFails_WhenNoFailure_Fails() {
        Tools.assertFails(() -> Tools.assertFails(() -> {}));
    }

    @Test
    default public void tools_assertFails_WhenThrowsNonAssertions_Fails() {
        Tools.assertFails(() -> Tools.assertFails(() -> {
            throw new IllegalStateException("Oh My.");
        }));
    }

    @Test
    default public void tools_assertFails_WhenThrowsAsserts_Succeeds() {
        Assertions.assertDoesNotThrow(() -> Tools.assertFails(() -> {
            throw new AssertionError((Object)"Oh My.");
        }));
    }

    @Test
    default public void tools_assertContract_Works() {
        Contract validContract = Contract.create((String)"test", (Object[])new String[0]);
        Contract.Config validConfig = String.class::cast;
        Tools.assertFails(() -> Tools.assertContract(null, validConfig, "abc"));
        Tools.assertFails(() -> Tools.assertContract(validContract, null, "abc"));
    }

    @Test
    default public void tools_assertThrown_Works() {
        String validReason = "This is a reason.";
        RuntimeException validCause = new RuntimeException("This is a cause.");
        RuntimeException validException = new RuntimeException("This is a reason.");
        RuntimeException exceptionWithNullReason = new RuntimeException((String)null);
        RuntimeException validExceptionWithCause = new RuntimeException("This is a reason.", validCause);
        RuntimeException unknownException = new RuntimeException("This is an unknown exception.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Tools.assertFails(() -> Tools.assertThrown(null, validCause, "This is a reason.")), () -> Tools.assertFails(() -> Tools.assertThrown(validCause, null, null)), () -> Tools.assertFails(() -> Tools.assertThrown(validCause, unknownException, null)), () -> Tools.assertFails(() -> Tools.assertThrown(validCause, validCause, "This is a reason.")), () -> Tools.assertFails(() -> Tools.assertThrown(exceptionWithNullReason, validCause, "This is a reason.")), () -> Assertions.assertDoesNotThrow(() -> Tools.assertThrown(validException, null, "This is a reason.")), () -> Tools.assertFails(() -> Tools.assertThrown(validExceptionWithCause, null, "This is a reason.")), () -> Tools.assertFails(() -> Tools.assertThrown(validExceptionWithCause, validCause, "Different.")), () -> Assertions.assertDoesNotThrow(() -> Tools.assertThrown(validExceptionWithCause, validCause, "This is a reason."))});
    }

    @Test
    default public void tools_assertThrownThrown_Works() {
        String validReason = "This is a reason.";
        RuntimeException validCause = new RuntimeException("This is a cause.");
        RuntimeException validException = new RuntimeException("This is a reason.");
        RuntimeException exceptionWithNullReason = new RuntimeException((String)null);
        RuntimeException validExceptionWithCause = new RuntimeException("This is a reason.", validCause);
        RuntimeException unknownException = new RuntimeException("This is an unknown exception.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Tools.assertFails(() -> Tools.assertThrown(null, validCause)), () -> Tools.assertFails(() -> Tools.assertThrown(validCause, unknownException)), () -> Tools.assertFails(() -> Tools.assertThrown(validCause, validCause)), () -> Tools.assertFails(() -> Tools.assertThrown(exceptionWithNullReason, validCause)), () -> Assertions.assertDoesNotThrow(() -> Tools.assertThrown(validException, (Throwable)null)), () -> Tools.assertFails(() -> Tools.assertThrown(validExceptionWithCause, (Throwable)null)), () -> Assertions.assertDoesNotThrow(() -> Tools.assertThrown(validExceptionWithCause, validCause))});
    }

    @Test
    default public void tools_assertInstantiateThrows_With() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Tools.assertInstantiateThrows(null));
        Tools.assertThrown(thrown);
    }

    @Test
    default public void tools_assertInstantiate_WithPublic_Fails() {
        Tools.assertFails(() -> Tools.assertInstantiateThrows(String.class));
    }

    @Test
    default public void tools_assertObject_WithNull_Fails() {
        Tools.assertFails(() -> Tools.assertObject(null));
    }

    @Test
    default public void tools_assertObject_WithBadHashCode_Fails() {
        Object object = new Object(){
            private final AtomicInteger counter = new AtomicInteger();

            public int hashCode() {
                return this.counter.incrementAndGet();
            }
        };
        Tools.assertFails(() -> Tools.assertObject(object));
    }

    @Test
    default public void tools_assertObject_WithNullToString_Fails() {
        Object object = new Object(){

            public String toString() {
                return null;
            }
        };
        Tools.assertFails(() -> Tools.assertObject(object));
    }

    @Test
    default public void tools_assertObject_BadEquals_Fails() {
        Object object = new Object(){

            public boolean equals(Object that) {
                return null == that;
            }

            public int hashCode() {
                return 1;
            }
        };
        Tools.assertFails(() -> Tools.assertObject(object));
    }

    @Test
    default public void tools_assertObject_WithString_Passes() {
        Assertions.assertDoesNotThrow(() -> Tools.assertObject("abc"));
    }

    @Test
    default public void tools_sleep_WithNullDuration_Throws() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Tools.sleep(null));
        Tools.assertThrown((Throwable)thrown, "Duration must be present.");
    }

    @ParameterizedTest(name="Duration {0} milliseconds")
    @ValueSource(ints={0, 5, 10, 100, 200})
    default public void tools_sleep_WithDuration(long milliseconds) {
        Duration expectedDuration = Duration.ofMillis(milliseconds);
        Duration allowedDifference = Duration.ofMillis(10L);
        Instant start = Instant.now();
        Tools.sleep(expectedDuration);
        Duration actualDuration = Duration.between(start, Instant.now());
        Assertions.assertTrue((actualDuration.compareTo(expectedDuration) >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((actualDuration.minus(expectedDuration).compareTo(allowedDifference) <= 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="Duration {0} milliseconds")
    @ValueSource(ints={-1, -2})
    default public void tools_sleep_WithInvalidDuration(long milliseconds) {
        Duration expectedDuration = Duration.ofMillis(milliseconds);
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Tools.sleep(expectedDuration));
        Tools.assertThrown((Throwable)thrown, "Duration must not be negative.");
    }
}

