/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.test.BadContractsFactory;
import io.github.jonloucks.contracts.test.Tools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public interface BadContractsFactoryTests {
    @Test
    default public void badContractsFactory_HasProtectedConstructor() throws Throwable {
        Class<?> klass = Class.forName(BadContractsFactory.class.getCanonicalName());
        Constructor<?> constructor = klass.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        int modifiers = constructor.getModifiers();
        Assertions.assertFalse((boolean)Modifier.isPublic(modifiers), (String)"constructor should not be public.");
    }

    @Test
    default public void badContractsFactory_HasPrivateConstructor() throws Throwable {
        BadContractsFactory badContractsFactory = new BadContractsFactory();
        Contracts.Config config = new Contracts.Config(){};
        Tools.assertThrown(Exception.class, () -> badContractsFactory.create(config));
    }
}

