/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.Checks;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.test.Tools;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public interface ChecksTests {
    @Test
    default public void checks_Instantiate_Throws() {
        Tools.assertInstantiateThrows(Checks.class);
    }

    @Test
    default public void checks_contractCheck_WhenNull_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.contractCheck(null));
    }

    @Test
    default public void checks_contractCheck_WithValid_Works() {
        Contract contract = Contract.create(Instant.class);
        Assertions.assertSame((Object)contract, (Object)Checks.contractCheck((Contract)contract));
    }

    @Test
    default public void checks_contractsCheck_WhenNull_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.contractsCheck(null));
    }

    @Test
    default public void checks_contractsCheck_WithValid_Works() {
        Contract contract = Contract.create(Instant.class);
        Assertions.assertSame((Object)contract, (Object)Checks.contractCheck((Contract)contract));
    }

    @Test
    default public void checks_configCheck_WhenNull_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.configCheck(null));
    }

    @Test
    default public void checks_configCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.configCheck((Object)config));
    }

    @Test
    default public void checks_nameCheck_WhenNull_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.nameCheck(null));
    }

    @Test
    default public void checks_nameCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.nameCheck((Object)config));
    }

    @Test
    default public void checks_builderConsumerCheck_WhenNull_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.builderConsumerCheck(null));
    }

    @Test
    default public void checks_builderConsumerCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.builderConsumerCheck((Object)config));
    }

    @Test
    default public void checks_builderCheck_WhenNull_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.builderCheck(null));
    }

    @Test
    default public void checks_builderCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.builderCheck((Object)config));
    }

    @Test
    default public void checks_typeCheck_WhenNull_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.typeCheck(null));
    }

    @Test
    default public void checks_typeCheck_WithValid_Works() {
        Object config = new Object();
        Assertions.assertSame((Object)config, (Object)Checks.typeCheck((Object)config));
    }

    @Test
    default public void checks_illegalCheck_WhenFailedIsFalse_Works() {
        String actual = (String)Checks.illegalCheck((Object)"abc", (boolean)false, (String)"");
        Assertions.assertSame((Object)"abc", (Object)actual);
    }

    @Test
    default public void checks_illegalCheck_WhenValid_Works() {
        String actual = (String)Checks.illegalCheck((Object)"abc", (boolean)false, (String)"");
        Assertions.assertSame((Object)"abc", (Object)actual);
    }

    @Test
    default public void checks_illegalCheck_WhenFailed_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.illegalCheck((Object)"abc", (boolean)true, (String)"Xyz."), "Xyz.");
    }

    @Test
    default public void checks_illegalCheck_WhenNullMessage_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.illegalCheck((Object)"abc", (boolean)false, null));
    }
}

