/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.test.Tools;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public interface ContractTests {
    @Test
    default public void contract_Instantiate_Throws() {
        Tools.assertInstantiateThrows(Contract.class);
    }

    @Test
    default public void contract_create_withNullTypes_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Contract.create((String)"test", (Object[])null));
    }

    @Test
    default public void contract_create_withNullConfig_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Contract.create((Contract.Config)null));
    }

    @Test
    default public void contract_create_withNullClass_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Contract.create((Class)null));
    }

    @Test
    default public void contract_create_withNullClassAndBuilder_Throws() {
        Consumer<Contract.Config.Builder> builderConsumer = b -> {};
        Tools.assertThrown(IllegalArgumentException.class, () -> Contract.create(null, (Consumer)builderConsumer));
    }

    @Test
    default public void contract_create_withClassAndNullBuilder_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Contract.create(String.class, null));
    }

    @Test
    default public void contract_create_withClassAndBuilder_Works() {
        Contract contract = Contract.create(String.class, b -> {
            Assertions.assertSame((Object)b, (Object)b.name("test"));
            Assertions.assertSame((Object)b, (Object)b.replaceable(true));
            Assertions.assertSame((Object)b, (Object)b.typeName("chars"));
        });
        Tools.assertObject(contract);
        Assertions.assertEquals((Object)"test", (Object)contract.getName());
        Assertions.assertEquals((Object)"chars", (Object)contract.getTypeName());
        Assertions.assertTrue((boolean)contract.isReplaceable(), (String)"Contract should have been replaceable");
    }

    @Test
    default public void contract_create_IntegerContract_Works() {
        String contractName = "testContract";
        Contract contract = Contract.create((String)"testContract", (Object[])new Integer[0]);
        Contract.Config<Integer> expectedConfig = new Contract.Config<Integer>(){

            public String name() {
                return "testContract";
            }

            public String typeName() {
                return Integer.class.getTypeName();
            }

            public Integer cast(Object instance) {
                return (Integer)instance;
            }
        };
        Tools.assertContract(contract, expectedConfig, 0);
    }

    @Test
    default public void contract_create_ByClass_Works() {
        final Class<String> contractClass = String.class;
        Contract contract = Contract.create(contractClass);
        Contract.Config<String> expectedConfig = new Contract.Config<String>(){

            public String name() {
                return contractClass.getTypeName();
            }

            public String typeName() {
                return contractClass.getTypeName();
            }

            public String cast(Object instance) {
                return (String)contractClass.cast(instance);
            }
        };
        Tools.assertContract(contract, expectedConfig, "hello");
    }

    @Test
    default public void contract_create_Works() {
        Contract.Config<String> config = new Contract.Config<String>(){

            public String cast(Object instance) {
                return (String)instance;
            }

            public String typeName() {
                return String.class.getName();
            }

            public String name() {
                return "Some String contract";
            }
        };
        Contract contract = Contract.create((Contract.Config)config);
        Tools.assertContract(contract, config, "abc");
    }

    @Test
    default public void contract_Config_Defaults() {
        Contract.Config defaults = x -> (String)x;
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)defaults.isReplaceable(), (String)"Default for replaceable."), () -> Assertions.assertEquals((Object)"", (Object)defaults.name(), (String)"Default for name."), () -> Assertions.assertEquals((Object)"", (Object)defaults.typeName(), (String)"Default for typeName."), () -> Assertions.assertSame((Object)"abc", (Object)defaults.cast((Object)"abc"), (String)"Cast should work."), () -> Assertions.assertThrows(ClassCastException.class, () -> defaults.cast((Object)12L), (String)"Cast should fail on wrong type")});
    }
}

