/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.AutoClose;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.api.ContractException;
import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.api.ContractsFactory;
import io.github.jonloucks.contracts.api.GlobalContracts;
import io.github.jonloucks.contracts.api.Promisor;
import io.github.jonloucks.contracts.test.BadContractsFactory;
import io.github.jonloucks.contracts.test.Tools;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public interface GlobalContractsTests {
    @Test
    default public void globalContracts_Instantiate_Throws() {
        Tools.assertInstantiateThrows(GlobalContracts.class);
    }

    @Test
    default public void globalContracts_getInstance_Works() {
        Tools.assertObject(GlobalContracts.getInstance());
    }

    @Test
    default public void globalContracts_claimContract_WithNullContract_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> GlobalContracts.claimContract(null));
    }

    @Test
    default public void globalContracts_singleton_WithNullPromisor_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> GlobalContracts.singleton(null));
    }

    @Test
    default public void globalContracts_lifeCycle_WithNullPromisor_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> GlobalContracts.lifeCycle(null));
    }

    @Test
    default public void globalContracts_claimContract_WithUnknownContract_Throws() {
        Contract contract = Contract.create((String)"testContract", (Object[])new String[0]);
        Tools.assertThrown(ContractException.class, () -> GlobalContracts.claimContract((Contract)contract));
    }

    @Test
    default public void globalContracts_lifeCycle_WithNPromisor_Works() {
        Promisor sourcePromisor = () -> 12;
        Promisor lifeCyclePromisor = GlobalContracts.lifeCycle((Promisor)sourcePromisor);
        Tools.assertObject(lifeCyclePromisor);
        lifeCyclePromisor.incrementUsage();
        Assertions.assertEquals((Integer)((Integer)sourcePromisor.demand()), (Integer)((Integer)lifeCyclePromisor.demand()));
    }

    @Test
    default public void globalContracts_singleton_WithNPromisor_Works() {
        Promisor sourcePromisor = () -> 12;
        Promisor singletonPromisor = GlobalContracts.singleton((Promisor)sourcePromisor);
        Tools.assertObject(singletonPromisor);
        singletonPromisor.incrementUsage();
        Assertions.assertEquals((Integer)((Integer)sourcePromisor.demand()), (Integer)((Integer)singletonPromisor.demand()));
    }

    @Test
    default public void globalContracts_claimContract_WithPromisedContract_Works() {
        Contract contract = Contract.create((String)"testContract", (Object[])new String[0]);
        try (AutoClose releaseBinding = GlobalContracts.bindContract((Contract)contract, () -> "abc");){
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)releaseBinding), () -> Assertions.assertSame((Object)"abc", (Object)GlobalContracts.claimContract((Contract)contract))});
        }
    }

    @Test
    default public void globalContracts_isContractBound_WithUnboundContract_Works() {
        Contract contract = Contract.create((String)"testContract", (Object[])new String[0]);
        Assertions.assertFalse((boolean)GlobalContracts.isContractBound((Contract)contract), (String)"Unbound Contract was bound.");
    }

    @Test
    default public void globalContracts_isContractBound_WithBoundContract_Works() {
        Contract contract = Contract.create((String)"testContract", (Object[])new String[0]);
        try (AutoClose closeBinding = GlobalContracts.bindContract((Contract)contract, () -> "abc");){
            Tools.ignore(closeBinding);
            Assertions.assertTrue((boolean)GlobalContracts.isContractBound((Contract)contract), (String)"Unbound Contract was bound.");
        }
    }

    @Test
    default public void globalContracts_DefaultConfig() {
        Contracts.Config config = new Contracts.Config(){};
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)config.useReflection(), (String)"config.useReflection() default."), () -> Assertions.assertTrue((boolean)config.useServiceLoader(), (String)"config.useServiceLoader() default."), () -> Assertions.assertTrue((boolean)config.useShutdownHooks(), (String)"config.useShutdownHooks() default."), () -> Assertions.assertNotNull((Object)config.reflectionClassName(), (String)"config.reflectionClassName() was null.")});
    }

    @ParameterizedTest
    @MethodSource(value={"io.github.jonloucks.contracts.test.GlobalContractsTests$GlobalContractsTestsTools#validConfigs"})
    default public void globalContracts_HappyPath(Contracts.Config contractsConfig) {
        Contract contract = Contract.create((String)"string contract", (Object[])new String[0]);
        Contract unboundContract = Contract.create((String)"unbound string contract", (Object[])new String[0]);
        Contracts contracts = GlobalContracts.createContracts((Contracts.Config)contractsConfig);
        Assumptions.assumeTrue((boolean)Optional.ofNullable(contracts).isPresent(), (String)"createContracts failed");
        try (AutoClose closeContracts = contracts.open();){
            Tools.ignore(closeContracts);
            try (AutoClose closeBinding = contracts.bind(contract, () -> "hello");){
                Tools.ignore(closeBinding);
                Assertions.assertFalse((boolean)contracts.isBound(unboundContract), (String)"Contract should be bound.");
                Assertions.assertTrue((boolean)contracts.isBound(contract), (String)"Contract should be bound.");
                Assertions.assertEquals((Object)"hello", (Object)contracts.claim(contract), (String)"Claimed value should match.");
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"io.github.jonloucks.contracts.test.GlobalContractsTests$GlobalContractsTestsTools#invalidConfigs"})
    default public void globalContracts_SadPath(Contracts.Config contractsConfig) {
        Tools.assertThrown(ContractException.class, () -> GlobalContracts.createContracts((Contracts.Config)contractsConfig));
    }

    @Test
    default public void globalContracts_InternalCoverage() {
        Tools.assertInstantiateThrows(GlobalContractsTestsTools.class);
    }

    public static final class GlobalContractsTestsTools {
        private GlobalContractsTestsTools() {
            throw new AssertionError((Object)"Illegal constructor");
        }

        static Stream<Arguments> validConfigs() {
            return Stream.of(Arguments.of((Object[])new Object[]{new Contracts.Config(){}}), Arguments.of((Object[])new Object[]{new Contracts.Config(){

                public boolean useServiceLoader() {
                    return false;
                }

                public boolean useReflection() {
                    return true;
                }
            }}), Arguments.of((Object[])new Object[]{new Contracts.Config(){

                public boolean useServiceLoader() {
                    return true;
                }

                public boolean useReflection() {
                    return false;
                }
            }}));
        }

        static Stream<Arguments> invalidConfigs() {
            return Stream.of(Arguments.of((Object[])new Object[]{new Contracts.Config(){

                public boolean useServiceLoader() {
                    return false;
                }

                public boolean useReflection() {
                    return false;
                }
            }}), Arguments.of((Object[])new Object[]{new Contracts.Config(){

                public boolean useServiceLoader() {
                    return true;
                }

                public boolean useReflection() {
                    return false;
                }

                public Class<? extends ContractsFactory> serviceLoaderClass() {
                    return BadContractsFactory.class;
                }
            }}), Arguments.of((Object[])new Object[]{new Contracts.Config(){

                public boolean useServiceLoader() {
                    return false;
                }

                public boolean useReflection() {
                    return true;
                }

                public String reflectionClassName() {
                    return BadContractsFactory.class.getName();
                }
            }}), Arguments.of((Object[])new Object[]{new Contracts.Config(){

                public boolean useServiceLoader() {
                    return false;
                }

                public boolean useReflection() {
                    return true;
                }

                public String reflectionClassName() {
                    return "";
                }
            }}));
        }
    }
}

