/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.AutoClose;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.api.ContractException;
import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.test.Tools;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public interface PartnersTests {
    @Test
    default public void partners_shadowPartners_Works() {
        Tools.withContracts(partner -> {
            Contracts.Config config = new Contracts.Config(){
                final /* synthetic */ Contracts val$partner;
                {
                    this.val$partner = contracts;
                }

                public List<Contracts> getPartners() {
                    return Collections.singletonList(this.val$partner);
                }
            };
            Tools.withContracts(config, primary -> {
                Contract contract = Contract.create(String.class);
                try (AutoClose close1 = partner.bind(contract, () -> "Partner");
                     AutoClose close2 = primary.bind(contract, () -> "Primary");){
                    Tools.ignore(close1);
                    Tools.ignore(close2);
                    Assertions.assertEquals((Object)"Primary", (Object)primary.claim(contract));
                }
            });
        });
    }

    @Test
    default public void partners_unboundContracts_Works() {
        Tools.withContracts(partner -> {
            Contracts.Config config = new Contracts.Config(){
                final /* synthetic */ Contracts val$partner;
                {
                    this.val$partner = contracts;
                }

                public List<Contracts> getPartners() {
                    return Collections.singletonList(this.val$partner);
                }
            };
            Tools.withContracts(config, primary -> {
                Contract contract = Contract.create(String.class);
                Assertions.assertFalse((boolean)primary.isBound(contract));
                Tools.assertThrown(Assertions.assertThrows(ContractException.class, () -> primary.claim(contract)));
            });
        });
    }

    @Test
    default public void partners_boundPartners_Works() {
        Tools.withContracts(partner -> {
            Contracts.Config config = new Contracts.Config(){
                final /* synthetic */ Contracts val$partner;
                {
                    this.val$partner = contracts;
                }

                public List<Contracts> getPartners() {
                    return Collections.singletonList(this.val$partner);
                }
            };
            Tools.withContracts(config, primary -> {
                Contract contract = Contract.create(String.class);
                try (AutoClose close1 = partner.bind(contract, () -> "Partner");){
                    Tools.ignore(close1);
                    Assertions.assertTrue((boolean)primary.isBound(contract));
                    Assertions.assertEquals((Object)"Partner", (Object)primary.claim(contract));
                }
            });
        });
    }

    @Test
    default public void partners_boundPrimary_Works() {
        Tools.withContracts(partner -> {
            Contracts.Config config = new Contracts.Config(){
                final /* synthetic */ Contracts val$partner;
                {
                    this.val$partner = contracts;
                }

                public List<Contracts> getPartners() {
                    return Collections.singletonList(this.val$partner);
                }
            };
            Tools.withContracts(config, primary -> {
                Contract contract = Contract.create(String.class);
                try (AutoClose close = primary.bind(contract, () -> "Primary");){
                    Tools.ignore(close);
                    Assertions.assertTrue((boolean)primary.isBound(contract));
                    Assertions.assertEquals((Object)"Primary", (Object)primary.claim(contract));
                }
            });
        });
    }
}

