/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.Promisor;
import io.github.jonloucks.contracts.api.Promisors;
import io.github.jonloucks.contracts.test.Decoy;
import io.github.jonloucks.contracts.test.Tools;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public interface SingletonPromisorTests {
    @Test
    default public void createSingletonPromisor_WithNullReferent_Throws() {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Tools.assertThrown(IllegalArgumentException.class, () -> promisors.createSingletonPromisor(null));
        });
    }

    @Test
    default public void createSingletonPromisor_Valid_Works(@Mock Promisor<Decoy<Integer>> referent, @Mock Decoy<Integer> deliverable) {
        Tools.withContracts(contracts -> {
            int usages = 5;
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Mockito.when((Object)((Decoy)referent.demand())).thenReturn((Object)deliverable);
            Promisor promisor = promisors.createSingletonPromisor(referent);
            Assertions.assertNotNull((Object)promisor, (String)"should not return null.");
            for (int i = 0; i < 5; ++i) {
                promisor.incrementUsage();
            }
            Decoy delivery1 = (Decoy)promisor.demand();
            Decoy delivery2 = (Decoy)promisor.demand();
            for (int i = 0; i < 5; ++i) {
                promisor.decrementUsage();
            }
            Assertions.assertAll((Executable[])new Executable[]{() -> Tools.assertObject(promisor), () -> Assertions.assertSame((Object)deliverable, (Object)delivery1, (String)"first deliverable should match."), () -> Assertions.assertSame((Object)deliverable, (Object)delivery2, (String)"second deliverable should match."), () -> ((Promisor)Mockito.verify((Object)referent, (VerificationMode)Mockito.times((int)1))).demand(), () -> ((Promisor)Mockito.verify((Object)referent, (VerificationMode)Mockito.times((int)5))).decrementUsage(), () -> ((Promisor)Mockito.verify((Object)referent, (VerificationMode)Mockito.times((int)5))).incrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).incrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).decrementUsage(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).open(), () -> ((Decoy)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).close()});
        });
    }
}

