/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.AutoClose;
import io.github.jonloucks.contracts.api.Checks;
import io.github.jonloucks.contracts.api.Contract;
import io.github.jonloucks.contracts.api.ContractException;
import io.github.jonloucks.contracts.api.Contracts;
import io.github.jonloucks.contracts.api.Promisor;
import io.github.jonloucks.contracts.test.Tools;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public interface ValidateTests {
    @Test
    default public void validate_WithNullContracts_Throws() {
        Tools.assertThrown(IllegalArgumentException.class, () -> Checks.validateContracts(null));
    }

    @Test
    default public void validate_WhenBindReturnsNull_Throws(@Mock Contracts contracts) {
        Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
        Tools.assertThrown(ContractException.class, () -> Checks.validateContracts((Contracts)contracts));
    }

    @Test
    default public void validate_WithFirstIsBoundIsTrue_Throws(@Mock Contracts contracts) {
        Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)true);
        Tools.assertThrown(ContractException.class, () -> Checks.validateContracts((Contracts)contracts), "Contract should not be bound.");
    }

    @Test
    default public void validate_bind_ReturnsNull_Throws(@Mock Contracts contracts) {
        Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)contracts.bind((Contract)Mockito.any(), (Promisor)Mockito.any())).thenAnswer(invocationOnMock -> null);
        Tools.assertThrown(ContractException.class, () -> Checks.validateContracts((Contracts)contracts), "Contract bind returned null.");
    }

    @Test
    default public void validate_isBound_AfterBind_ReturnsFalse_Throws(@Mock Contracts contracts, @Mock AutoClose closeBinding) {
        Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)contracts.bind((Contract)Mockito.any(), (Promisor)Mockito.any())).thenAnswer(invocationOnMock -> {
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
            return closeBinding;
        });
        Tools.assertThrown(ContractException.class, () -> Checks.validateContracts((Contracts)contracts), "Contract should have been bound.");
    }

    @Test
    default public void validate_claim_AfterBind_ReturnsUnexpected_Throws(@Mock Contracts contracts, @Mock AutoClose closeBinding) {
        Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)contracts.bind((Contract)Mockito.any(), (Promisor)Mockito.any())).thenAnswer(invocationOnMock -> {
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)true);
            return closeBinding;
        });
        ((AutoClose)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
            return null;
        }).when((Object)closeBinding)).close();
        Mockito.when((Object)contracts.claim((Contract)Mockito.any())).thenAnswer(invocationOnMock -> null);
        Tools.assertThrown(ContractException.class, () -> Checks.validateContracts((Contracts)contracts), "Contract claiming not working.");
    }

    @Test
    default public void validate_claim_AfterBind_ThrowsUnexpected_Throws(@Mock Contracts contracts, @Mock AutoClose closeBinding) {
        Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)contracts.bind((Contract)Mockito.any(), (Promisor)Mockito.any())).thenAnswer(invocationOnMock -> {
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)true);
            return closeBinding;
        });
        ((AutoClose)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
            return null;
        }).when((Object)closeBinding)).close();
        Mockito.when((Object)contracts.claim((Contract)Mockito.any())).thenAnswer(invocationOnMock -> {
            throw new ArithmeticException("Math overflow.");
        });
        Tools.assertThrown(ContractException.class, () -> Checks.validateContracts((Contracts)contracts), "Contracts unexpected validation error.");
    }

    @Test
    default public void validate_Success_DoesNotThrow(@Mock Contracts contracts, @Mock AutoClose closeBinding) {
        AtomicReference promisor = new AtomicReference();
        Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)contracts.bind((Contract)Mockito.any(), (Promisor)Mockito.any())).thenAnswer(invocationOnMock -> {
            promisor.set((Promisor)invocationOnMock.getArgument(1));
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)true);
            return closeBinding;
        });
        ((AutoClose)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
            return null;
        }).when((Object)closeBinding)).close();
        Mockito.when((Object)contracts.claim((Contract)Mockito.any())).thenAnswer(invocationOnMock -> ((Promisor)promisor.get()).demand());
        Assertions.assertDoesNotThrow(() -> Checks.validateContracts((Contracts)contracts));
    }

    @Test
    default public void validate_AfterUnbindContractIsStillBound_Throws(@Mock Contracts contracts, @Mock AutoClose closeBinding) {
        AtomicReference promisor = new AtomicReference();
        Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)false);
        ((AutoClose)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)true);
            return null;
        }).when((Object)closeBinding)).close();
        Mockito.when((Object)contracts.bind((Contract)Mockito.any(), (Promisor)Mockito.any())).thenAnswer(onMock -> {
            promisor.set((Promisor)onMock.getArgument(1));
            Mockito.when((Object)contracts.isBound((Contract)Mockito.any())).thenReturn((Object)true);
            return closeBinding;
        });
        Mockito.when((Object)contracts.claim((Contract)Mockito.any())).thenAnswer(invocationOnMock -> ((Promisor)promisor.get()).demand());
        Tools.assertThrown(ContractException.class, () -> Checks.validateContracts((Contracts)contracts), "Contract unbinding not working.");
    }
}

